/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.packagers.JibConfiguration;
import org.jreleaser.model.api.packagers.JibPackager;
import org.jreleaser.model.api.packagers.PackagerRepository;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.AbstractArtifact;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.CommitAuthor;
import org.jreleaser.model.internal.common.CommitAuthorAware;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.AbstractJibConfiguration;
import org.jreleaser.model.internal.packagers.AbstractRepositoryTap;
import org.jreleaser.model.internal.packagers.JibConfiguration;
import org.jreleaser.model.internal.packagers.JibSpec;
import org.jreleaser.model.internal.packagers.RepositoryPackager;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class JibPackager
extends AbstractJibConfiguration<JibPackager>
implements RepositoryPackager<org.jreleaser.model.api.packagers.JibPackager>,
CommitAuthorAware {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private static final long serialVersionUID = -5161609035832200577L;
    private final Map<String, JibSpec> specs = new LinkedHashMap<String, JibSpec>();
    private final CommitAuthor commitAuthor = new CommitAuthor();
    private final JibRepository repository = new JibRepository();
    private Boolean continueOnError;
    private String downloadUrl;
    private String version;
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.JibPackager immutable = new org.jreleaser.model.api.packagers.JibPackager(){
        private static final long serialVersionUID = -1607794151817682330L;
        private Set<? extends JibConfiguration.Registry> registries;
        private Map<String, ? extends org.jreleaser.model.api.packagers.JibSpec> specs;

        public Map<String, ? extends org.jreleaser.model.api.packagers.JibSpec> getSpecs() {
            if (null == this.specs) {
                this.specs = JibPackager.this.specs.values().stream().map(JibSpec::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.packagers.JibSpec::getName, Function.identity()));
            }
            return this.specs;
        }

        public String getVersion() {
            return JibPackager.this.getVersion();
        }

        public JibPackager.JibRepository getRepository() {
            return JibPackager.this.repository.asImmutable();
        }

        public org.jreleaser.model.api.common.CommitAuthor getCommitAuthor() {
            return JibPackager.this.commitAuthor.asImmutable();
        }

        public String getTemplateDirectory() {
            return JibPackager.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(JibPackager.this.getSkipTemplates());
        }

        public String getBaseImage() {
            return JibPackager.this.getBaseImage();
        }

        public String getCreationTime() {
            return JibPackager.this.getCreationTime();
        }

        public JibConfiguration.Format getFormat() {
            return JibPackager.this.getFormat();
        }

        public Map<String, String> getEnvironment() {
            return Collections.unmodifiableMap(JibPackager.this.getEnvironment());
        }

        public Set<String> getVolumes() {
            return Collections.unmodifiableSet(JibPackager.this.getVolumes());
        }

        public Set<String> getExposedPorts() {
            return Collections.unmodifiableSet(JibPackager.this.getExposedPorts());
        }

        public String getUser() {
            return JibPackager.this.getUser();
        }

        public String getWorkingDirectory() {
            return JibPackager.this.getWorkingDirectory();
        }

        public Map<String, String> getLabels() {
            return Collections.unmodifiableMap(JibPackager.this.getLabels());
        }

        public Set<String> getImageNames() {
            return Collections.unmodifiableSet(JibPackager.this.getImageNames());
        }

        public Set<? extends JibConfiguration.Registry> getRegistries() {
            if (null == this.registries) {
                this.registries = JibPackager.this.getRegistries().stream().map(JibConfiguration.Registry::asImmutable).collect(Collectors.toSet());
            }
            return this.registries;
        }

        public PackagerRepository getPackagerRepository() {
            return this.getRepository();
        }

        public String getType() {
            return "jib";
        }

        public String getDownloadUrl() {
            return JibPackager.this.downloadUrl;
        }

        public boolean supportsPlatform(String platform) {
            return JibPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return JibPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return JibPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return JibPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return JibPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return JibPackager.this.isContinueOnError();
        }

        public Active getActive() {
            return JibPackager.this.getActive();
        }

        public boolean isEnabled() {
            return JibPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(JibPackager.this.asMap(full));
        }

        public String getPrefix() {
            return JibPackager.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(JibPackager.this.getExtraProperties());
        }
    };
    @JsonIgnore
    private boolean failed;

    @Override
    public org.jreleaser.model.api.packagers.JibPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(JibPackager source) {
        super.merge(source);
        this.continueOnError = this.merge(this.continueOnError, source.continueOnError);
        this.downloadUrl = this.merge(this.downloadUrl, source.downloadUrl);
        this.version = this.merge(this.version, source.version);
        this.failed = source.failed;
        this.setSpecs(this.mergeModel(this.specs, source.specs));
        this.setCommitAuthor(source.commitAuthor);
        this.setRepository(source.repository);
    }

    @Override
    public boolean resolveEnabled(Project project, Distribution distribution) {
        this.resolveEnabled(project);
        if (!this.supportsDistribution(distribution.getType())) {
            this.disable();
        }
        return this.isEnabled();
    }

    @Override
    public void fail() {
        this.failed = true;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public boolean isContinueOnError() {
        return null != this.continueOnError && this.continueOnError != false;
    }

    @Override
    public void setContinueOnError(Boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    @Override
    public boolean isContinueOnErrorSet() {
        return null != this.continueOnError;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isUnix((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    public Set<Stereotype> getSupportedStereotypes() {
        return EnumSet.allOf(Stereotype.class);
    }

    @Override
    public List<Artifact> resolveCandidateArtifacts(JReleaserContext context, Distribution distribution) {
        if (distribution.getType() == Distribution.DistributionType.FLAT_BINARY && this.supportsDistribution(distribution.getType())) {
            return distribution.getArtifacts().stream().filter(AbstractArtifact::isActiveAndSelected).filter(artifact -> this.supportsPlatform(artifact.getPlatform())).filter(this::isNotSkipped).sorted(Artifact.comparatorByPlatform()).collect(Collectors.toList());
        }
        ArrayList<String> fileExtensions = new ArrayList<String>(this.getSupportedFileExtensions(distribution.getType()));
        fileExtensions.sort(Comparator.naturalOrder());
        return distribution.getArtifacts().stream().filter(AbstractArtifact::isActiveAndSelected).filter(artifact -> fileExtensions.stream().anyMatch(ext -> artifact.getResolvedPath(context, distribution).toString().endsWith((String)ext))).filter(artifact -> this.supportsPlatform(artifact.getPlatform())).filter(this::isNotSkipped).sorted(Artifact.comparatorByPlatform().thenComparingInt(artifact -> {
            String ext = FileType.getExtension((Path)artifact.getResolvedPath(context, distribution));
            return fileExtensions.indexOf(ext);
        })).collect(Collectors.toList());
    }

    @Override
    public List<Artifact> resolveArtifacts(JReleaserContext context, Distribution distribution) {
        return this.resolveCandidateArtifacts(context, distribution).stream().filter(Artifact::resolvedPathExists).collect(Collectors.toList());
    }

    private boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipJib"));
    }

    @Override
    public boolean isSnapshotSupported() {
        return true;
    }

    @Override
    public String getType() {
        return "jib";
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public CommitAuthor getCommitAuthor() {
        return this.commitAuthor;
    }

    @Override
    public void setCommitAuthor(CommitAuthor commitAuthor) {
        this.commitAuthor.merge(commitAuthor);
    }

    public List<JibSpec> getActiveSpecs() {
        return this.specs.values().stream().filter(AbstractActivatable::isEnabled).collect(Collectors.toList());
    }

    public Map<String, JibSpec> getSpecs() {
        return this.specs;
    }

    public void setSpecs(Map<String, JibSpec> specs) {
        this.specs.clear();
        this.specs.putAll(specs);
    }

    public void addSpecs(Map<String, JibSpec> specs) {
        this.specs.putAll(specs);
    }

    public void addSpec(JibSpec spec) {
        this.specs.put(spec.getName(), spec);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getType(), super.asMap(full));
        return map;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("version", this.version);
        props.put("commitAuthor", this.commitAuthor.asMap(full));
        props.put("repository", this.repository.asMap(full));
        props.put("downloadUrl", this.downloadUrl);
        props.put("continueOnError", this.isContinueOnError());
        List specs = this.specs.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!specs.isEmpty()) {
            props.put("specs", specs);
        }
    }

    public void setRepository(JibRepository repository) {
        this.repository.merge(repository);
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public JibRepository getPackagerRepository() {
        return this.repository;
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, CollectionUtils.setOf((Object[])new String[]{FileType.JAR.extension()}));
        SUPPORTED.put(Distribution.DistributionType.FLAT_BINARY, Collections.emptySet());
    }

    public static final class JibRepository
    extends AbstractRepositoryTap<JibRepository>
    implements Domain {
        private static final long serialVersionUID = 695045361878174791L;
        private Boolean versionedSubfolders;
        @JsonIgnore
        private final JibPackager.JibRepository immutable = new JibPackager.JibRepository(){
            private static final long serialVersionUID = -8630728744390799997L;

            public boolean isVersionedSubfolders() {
                return this.isVersionedSubfolders();
            }

            public String getBasename() {
                return this.getBasename();
            }

            public String getCanonicalRepoName() {
                return this.getCanonicalRepoName();
            }

            public String getName() {
                return this.getName();
            }

            public String getTagName() {
                return this.getTagName();
            }

            public String getBranch() {
                return this.getBranch();
            }

            public String getBranchPush() {
                return this.getBranchPush();
            }

            public String getUsername() {
                return this.getUsername();
            }

            public String getToken() {
                return this.getToken();
            }

            public String getCommitMessage() {
                return this.getCommitMessage();
            }

            public Active getActive() {
                return this.getActive();
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public String getOwner() {
                return this.getOwner();
            }

            public String getPrefix() {
                return this.prefix();
            }

            public Map<String, Object> getExtraProperties() {
                return Collections.unmodifiableMap(this.getExtraProperties());
            }
        };

        public JibRepository() {
            super("jib", "jib");
        }

        public JibPackager.JibRepository asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(JibRepository source) {
            super.merge(source);
            this.versionedSubfolders = this.merge(this.versionedSubfolders, source.versionedSubfolders);
        }

        @Override
        public String prefix() {
            return "repository";
        }

        public boolean isVersionedSubfolders() {
            return null != this.versionedSubfolders && this.versionedSubfolders != false;
        }

        public void setVersionedSubfolders(Boolean versionedSubfolders) {
            this.versionedSubfolders = versionedSubfolders;
        }

        public boolean isVersionedSubfoldersSet() {
            return null != this.versionedSubfolders;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            Map<String, Object> map = super.asMap(full);
            map.put("versionedSubfolders", this.isVersionedSubfolders());
            return map;
        }
    }
}

