/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.catalog.AbstractCataloger;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public final class SlsaCataloger
extends AbstractCataloger<SlsaCataloger, org.jreleaser.model.api.catalog.SlsaCataloger> {
    private static final long serialVersionUID = 5931727179221721620L;
    private static final String ATTESTATION_INTOTO = "-attestation.intoto";
    private String attestationName;
    private Boolean artifacts;
    private Boolean files;
    private Boolean deployables;
    @JsonIgnore
    private final org.jreleaser.model.api.catalog.SlsaCataloger immutable = new org.jreleaser.model.api.catalog.SlsaCataloger(){
        private static final long serialVersionUID = -5814032090448108458L;

        public String getAttestationName() {
            return SlsaCataloger.this.attestationName;
        }

        public boolean isArtifacts() {
            return SlsaCataloger.this.isArtifacts();
        }

        public boolean isFiles() {
            return SlsaCataloger.this.isFiles();
        }

        public boolean isDeployables() {
            return SlsaCataloger.this.isDeployables();
        }

        public String getGroup() {
            return SlsaCataloger.this.getType();
        }

        public String getType() {
            return SlsaCataloger.this.getType();
        }

        public Active getActive() {
            return SlsaCataloger.this.getActive();
        }

        public boolean isEnabled() {
            return SlsaCataloger.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return SlsaCataloger.this.asMap(full);
        }

        public String getPrefix() {
            return SlsaCataloger.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(SlsaCataloger.this.getExtraProperties());
        }
    };

    public SlsaCataloger() {
        super("slsa");
    }

    @Override
    public org.jreleaser.model.api.catalog.SlsaCataloger asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(SlsaCataloger source) {
        super.merge(source);
        this.attestationName = this.merge(this.attestationName, source.attestationName);
        this.artifacts = this.merge(this.artifacts, source.artifacts);
        this.files = this.merge(this.files, source.files);
        this.deployables = this.merge(this.deployables, source.deployables);
    }

    @Override
    public boolean isSet() {
        return super.isSet() || StringUtils.isNotBlank((String)this.attestationName) || this.isArtifactsSet() || this.isFilesSet() || this.isDeployablesSet();
    }

    public String getResolvedAttestationName(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        context.getChangelog().apply(props);
        MustacheUtils.applyTemplates((TemplateContext)props, this.resolvedExtraProperties());
        String name = Templates.resolveTemplate((String)this.attestationName, (TemplateContext)props);
        if (!name.endsWith(ATTESTATION_INTOTO)) {
            name = name + ATTESTATION_INTOTO;
        }
        return name;
    }

    public String getAttestationName() {
        return this.attestationName;
    }

    public void setAttestationName(String attestationName) {
        this.attestationName = attestationName;
    }

    public boolean isArtifactsSet() {
        return null != this.artifacts;
    }

    public boolean isArtifacts() {
        return null == this.artifacts || this.artifacts != false;
    }

    public void setArtifacts(Boolean artifacts) {
        this.artifacts = artifacts;
    }

    public boolean isFiles() {
        return null == this.files || this.files != false;
    }

    public void setFiles(Boolean files) {
        this.files = files;
    }

    public boolean isFilesSet() {
        return null != this.files;
    }

    public boolean isDeployablesSet() {
        return null != this.deployables;
    }

    public boolean isDeployables() {
        return null == this.deployables || this.deployables != false;
    }

    public void setDeployables(Boolean deployables) {
        this.deployables = deployables;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("attestationName", this.attestationName);
        props.put("artifacts", this.isArtifacts());
        props.put("files", this.isFiles());
        props.put("deployables", this.isDeployables());
    }
}

