/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPException;
import org.jreleaser.bundle.RB;
import org.jreleaser.extensions.api.workflow.WorkflowListener;
import org.jreleaser.extensions.api.workflow.WorkflowListenerException;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.logging.SimpleJReleaserLoggerAdapter;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.Signing;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.announce.Announcer;
import org.jreleaser.model.api.catalog.Cataloger;
import org.jreleaser.model.api.deploy.Deployer;
import org.jreleaser.model.api.download.Downloader;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.api.packagers.Packager;
import org.jreleaser.model.api.signing.Keyring;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.model.api.upload.Uploader;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.JReleaserModelResolver;
import org.jreleaser.model.internal.JReleaserModelValidator;
import org.jreleaser.model.internal.JReleaserScriptEvaluator;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.assemble.JavaArchiveAssembler;
import org.jreleaser.model.internal.assemble.JavaAssembler;
import org.jreleaser.model.internal.assemble.NativeImageAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.model.spi.release.Releaser;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.sdk.signing.FilesKeyring;
import org.jreleaser.sdk.signing.InMemoryKeyring;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public class JReleaserContext {
    private final JReleaserLogger logger;
    private final JReleaserModel model;
    private final Path basedir;
    private final Path outputDirectory;
    private final boolean dryrun;
    private final boolean strict;
    private final boolean gitRootSearch;
    private final JReleaserContext.Mode mode;
    private final Configurer configurer;
    private final Errors errors = new Errors();
    private final JReleaserContext.Changelog changelog = new JReleaserContext.Changelog();
    private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private final List<String> selectedPlatforms = new ArrayList<String>();
    private final List<String> rejectedPlatforms = new ArrayList<String>();
    private final List<String> includedAnnouncers = new ArrayList<String>();
    private final List<String> includedAssemblers = new ArrayList<String>();
    private final List<String> includedCatalogers = new ArrayList<String>();
    private final List<String> includedDistributions = new ArrayList<String>();
    private final List<String> includedPackagers = new ArrayList<String>();
    private final List<String> includedDownloaderTypes = new ArrayList<String>();
    private final List<String> includedDownloaderNames = new ArrayList<String>();
    private final List<String> includedDeployerTypes = new ArrayList<String>();
    private final List<String> includedDeployerNames = new ArrayList<String>();
    private final List<String> includedUploaderTypes = new ArrayList<String>();
    private final List<String> includedUploaderNames = new ArrayList<String>();
    private final List<String> excludedAnnouncers = new ArrayList<String>();
    private final List<String> excludedAssemblers = new ArrayList<String>();
    private final List<String> excludedCatalogers = new ArrayList<String>();
    private final List<String> excludedDistributions = new ArrayList<String>();
    private final List<String> excludedPackagers = new ArrayList<String>();
    private final List<String> excludedDownloaderTypes = new ArrayList<String>();
    private final List<String> excludedDownloaderNames = new ArrayList<String>();
    private final List<String> excludedDeployerTypes = new ArrayList<String>();
    private final List<String> excludedDeployerNames = new ArrayList<String>();
    private final List<String> excludedUploaderTypes = new ArrayList<String>();
    private final List<String> excludedUploaderNames = new ArrayList<String>();
    private final List<WorkflowListener> workflowListeners = new ArrayList<WorkflowListener>();
    private Releaser<?> releaser;
    private JReleaserCommand command;
    private final JReleaserScriptEvaluator scriptEvaluator = new JReleaserScriptEvaluator();
    @JsonIgnore
    private final org.jreleaser.model.api.JReleaserContext immutable = new org.jreleaser.model.api.JReleaserContext(){
        private static final long serialVersionUID = -4198066601336237321L;

        public Path relativize(Path basedir, Path other) {
            return JReleaserContext.this.relativize(basedir, other);
        }

        public Path relativizeToBasedir(Path other) {
            return JReleaserContext.this.relativizeToBasedir(other);
        }

        public JReleaserLogger getLogger() {
            return JReleaserContext.this.logger;
        }

        public JReleaserContext.Mode getMode() {
            return JReleaserContext.this.mode;
        }

        public org.jreleaser.model.api.JReleaserModel getModel() {
            return JReleaserContext.this.model.asImmutable();
        }

        public Path getBasedir() {
            return JReleaserContext.this.getBasedir();
        }

        public Path getOutputDirectory() {
            return JReleaserContext.this.getOutputDirectory();
        }

        public Path getChecksumsDirectory() {
            return JReleaserContext.this.getChecksumsDirectory();
        }

        public Path getCatalogsDirectory() {
            return JReleaserContext.this.getCatalogsDirectory();
        }

        public Path getSignaturesDirectory() {
            return JReleaserContext.this.getSignaturesDirectory();
        }

        public Path getPrepareDirectory() {
            return JReleaserContext.this.getPrepareDirectory();
        }

        public Path getPackageDirectory() {
            return JReleaserContext.this.getPackageDirectory();
        }

        public Path getAssembleDirectory() {
            return JReleaserContext.this.getAssembleDirectory();
        }

        public Path getDownloadDirectory() {
            return JReleaserContext.this.getDownloadDirectory();
        }

        public Path getArtifactsDirectory() {
            return JReleaserContext.this.getArtifactsDirectory();
        }

        public Path getDeployDirectory() {
            return JReleaserContext.this.getDeployDirectory();
        }

        public boolean isDryrun() {
            return JReleaserContext.this.isDryrun();
        }

        public boolean isStrict() {
            return JReleaserContext.this.isStrict();
        }

        public boolean isGitRootSearch() {
            return JReleaserContext.this.isGitRootSearch();
        }

        public List<String> getIncludedAnnouncers() {
            return Collections.unmodifiableList(JReleaserContext.this.getIncludedAnnouncers());
        }

        public List<String> getIncludedAssemblers() {
            return Collections.unmodifiableList(JReleaserContext.this.getIncludedAssemblers());
        }

        public List<String> getIncludedDistributions() {
            return Collections.unmodifiableList(JReleaserContext.this.getIncludedDistributions());
        }

        public List<String> getIncludedPackagers() {
            return Collections.unmodifiableList(JReleaserContext.this.getIncludedPackagers());
        }

        public List<String> getIncludedDownloaderTypes() {
            return Collections.unmodifiableList(JReleaserContext.this.getIncludedDownloaderTypes());
        }

        public List<String> getIncludedDownloaderNames() {
            return Collections.unmodifiableList(JReleaserContext.this.getIncludedDownloaderNames());
        }

        public List<String> getIncludedDeployerTypes() {
            return Collections.unmodifiableList(JReleaserContext.this.getIncludedDeployerTypes());
        }

        public List<String> getIncludedDeployerNames() {
            return Collections.unmodifiableList(JReleaserContext.this.getIncludedDeployerNames());
        }

        public List<String> getIncludedUploaderTypes() {
            return Collections.unmodifiableList(JReleaserContext.this.getIncludedUploaderTypes());
        }

        public List<String> getIncludedUploaderNames() {
            return Collections.unmodifiableList(JReleaserContext.this.getIncludedUploaderNames());
        }

        public List<String> getExcludedAnnouncers() {
            return Collections.unmodifiableList(JReleaserContext.this.getExcludedAnnouncers());
        }

        public List<String> getExcludedAssemblers() {
            return Collections.unmodifiableList(JReleaserContext.this.getExcludedAssemblers());
        }

        public List<String> getExcludedDistributions() {
            return Collections.unmodifiableList(JReleaserContext.this.getExcludedDistributions());
        }

        public List<String> getExcludedPackagers() {
            return Collections.unmodifiableList(JReleaserContext.this.getExcludedPackagers());
        }

        public List<String> getExcludedDownloaderTypes() {
            return Collections.unmodifiableList(JReleaserContext.this.getExcludedDownloaderTypes());
        }

        public List<String> getExcludedDownloaderNames() {
            return Collections.unmodifiableList(JReleaserContext.this.getExcludedDownloaderNames());
        }

        public List<String> getExcludedDeployerTypes() {
            return Collections.unmodifiableList(JReleaserContext.this.getExcludedDeployerTypes());
        }

        public List<String> getExcludedDeployerNames() {
            return Collections.unmodifiableList(JReleaserContext.this.getExcludedDeployerNames());
        }

        public List<String> getExcludedUploaderTypes() {
            return Collections.unmodifiableList(JReleaserContext.this.getExcludedUploaderTypes());
        }

        public List<String> getExcludedUploaderNames() {
            return Collections.unmodifiableList(JReleaserContext.this.getExcludedUploaderNames());
        }

        public JReleaserCommand getCommand() {
            return JReleaserContext.this.getCommand();
        }

        public TemplateContext props() {
            return JReleaserContext.this.props();
        }

        public TemplateContext fullProps() {
            return JReleaserContext.this.fullProps();
        }

        public void nag(String version, String message) {
            JReleaserContext.this.nag(version, message);
        }

        public Keyring createKeyring() throws SigningException {
            return JReleaserContext.this.createKeyring();
        }

        public JReleaserContext.Changelog getChangelog() {
            return JReleaserContext.this.changelog;
        }

        public Map<String, Object> getAdditionalProperties() {
            return Collections.unmodifiableMap(JReleaserContext.this.getAdditionalProperties());
        }
    };

    public static JReleaserContext empty() {
        Path basedir = Paths.get(System.getProperty("user.dir"), new String[0]);
        return new JReleaserContext((JReleaserLogger)new SimpleJReleaserLoggerAdapter(SimpleJReleaserLoggerAdapter.Level.DEBUG), null, JReleaserContext.Mode.FULL, new JReleaserModel(), basedir, basedir.resolve("out/jreleaser"), true, true, false, Collections.emptyList(), Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JReleaserContext(JReleaserLogger logger, Configurer configurer, JReleaserContext.Mode mode, JReleaserModel model, Path basedir, Path outputDirectory, boolean dryrun, boolean gitRootSearch, boolean strict, List<String> selectedPlatforms, List<String> rejectedPlatforms) {
        this.logger = logger;
        this.configurer = configurer;
        this.mode = mode;
        this.model = model;
        this.basedir = basedir;
        this.outputDirectory = outputDirectory;
        this.dryrun = dryrun;
        this.gitRootSearch = gitRootSearch;
        this.strict = strict;
        this.selectedPlatforms.addAll(selectedPlatforms.stream().filter(PlatformUtils::isSupported).collect(Collectors.toList()));
        try {
            logger.increaseIndent();
            logger.debug(RB.$((String)"context.path.set", (Object[])new Object[]{"basedir", this.getBasedir()}));
            logger.debug(RB.$((String)"context.path.set", (Object[])new Object[]{"baseOutputDirectory", this.getOutputDirectory().getParent()}));
            logger.debug(RB.$((String)"context.path.set", (Object[])new Object[]{"outputDirectory", this.getOutputDirectory()}));
            logger.debug(RB.$((String)"context.path.set", (Object[])new Object[]{"checksumDirectory", this.getChecksumsDirectory()}));
            logger.debug(RB.$((String)"context.path.set", (Object[])new Object[]{"catalogsDirectory", this.getCatalogsDirectory()}));
            logger.debug(RB.$((String)"context.path.set", (Object[])new Object[]{"signaturesDirectory", this.getSignaturesDirectory()}));
            logger.debug(RB.$((String)"context.path.set", (Object[])new Object[]{"prepareDirectory", this.getPrepareDirectory()}));
            logger.debug(RB.$((String)"context.path.set", (Object[])new Object[]{"packageDirectory", this.getPackageDirectory()}));
            logger.debug(RB.$((String)"context.path.set", (Object[])new Object[]{"downloadDirectory", this.getDownloadDirectory()}));
            logger.debug(RB.$((String)"context.path.set", (Object[])new Object[]{"assembleDirectory", this.getAssembleDirectory()}));
            logger.debug(RB.$((String)"context.path.set", (Object[])new Object[]{"artifactsDirectory", this.getArtifactsDirectory()}));
            logger.debug(RB.$((String)"context.path.set", (Object[])new Object[]{"deployDirectory", this.getDeployDirectory()}));
        }
        finally {
            logger.decreaseIndent();
        }
        ArrayList<String> unmatchedPlatforms = new ArrayList<String>(selectedPlatforms);
        unmatchedPlatforms.removeAll(this.selectedPlatforms);
        if (!unmatchedPlatforms.isEmpty()) {
            logger.warn(RB.$((String)"context.platform.selection.active", (Object[])new Object[0]));
            logger.error(RB.$((String)"context.platform.selection.no.match", (Object[])new Object[0]), new Object[]{unmatchedPlatforms});
            logger.error(RB.$((String)"context.platform.selection.valid", (Object[])new Object[0]), new Object[]{System.lineSeparator(), PlatformUtils.getSupportedOsNames(), System.lineSeparator(), PlatformUtils.getSupportedOsArchs()});
            throw new JReleaserException(RB.$((String)"context.platform.selection.unmatched", (Object[])new Object[]{unmatchedPlatforms}));
        }
        if (!this.selectedPlatforms.isEmpty()) {
            logger.warn(RB.$((String)"context.platform.selection.active", (Object[])new Object[0]));
            logger.warn(RB.$((String)"context.platform.selection.artifacts", (Object[])new Object[0]), new Object[]{this.selectedPlatforms});
        }
        this.rejectedPlatforms.addAll(rejectedPlatforms);
        if (!this.rejectedPlatforms.isEmpty()) {
            logger.warn(RB.$((String)"context.platform.selection.active", (Object[])new Object[0]));
            logger.warn(RB.$((String)"context.platform.rejection.artifacts", (Object[])new Object[0]), new Object[]{this.rejectedPlatforms});
        }
    }

    public org.jreleaser.model.api.JReleaserContext asImmutable() {
        return this.immutable;
    }

    public Object eval(String script) {
        return this.scriptEvaluator.eval(this, script);
    }

    public Path relativize(Path basedir, Path other) {
        return basedir.toAbsolutePath().relativize(other.toAbsolutePath());
    }

    public Path relativizeToBasedir(Path other) {
        return this.relativize(this.basedir, other);
    }

    public Path relativize(Path basedir, String other) {
        return this.relativize(basedir, Paths.get(other, new String[0]));
    }

    public Path relativizeToBasedir(String other) {
        return this.relativize(this.basedir, other);
    }

    public Errors validateModel() {
        if (this.errors.hasErrors()) {
            return this.errors;
        }
        this.model.getEnvironment().initProps(this);
        this.logger.info(RB.$((String)"context.configuration.validation", (Object[])new Object[0]));
        this.logger.info(RB.$((String)"context.configuration.strict", (Object[])new Object[]{this.strict}));
        if (this.mode.validateConfig()) {
            this.adjustDistributions();
        }
        try {
            JReleaserModelValidator.validate(this, this.mode, this.errors);
        }
        catch (Exception e) {
            this.logger.trace((Throwable)e);
            this.errors.configuration(e.toString());
        }
        if (this.errors.hasWarnings()) {
            this.logger.warn("== JReleaser ==");
            this.errors.logWarnings(this.logger);
        }
        if (this.errors.hasErrors()) {
            this.logger.error("== JReleaser ==");
            this.errors.logErrors(this.logger);
        }
        return this.errors;
    }

    private void adjustDistributions() {
        this.logger.debug(RB.$((String)"context.adjust.assemblies", (Object[])new Object[0]));
        try {
            JReleaserModelValidator.validate(this, JReleaserContext.Mode.ASSEMBLE, this.errors);
            JReleaserModelResolver.resolve(this, this.errors);
        }
        catch (Exception e) {
            this.logger.trace((Throwable)e);
            this.errors.configuration(e.toString());
        }
        for (Assembler assembler : this.model.getAssemble().findAllAssemblers()) {
            if (!assembler.isExported()) continue;
            Distribution distribution = this.model.getDistributions().get(assembler.getName());
            if (null == distribution) {
                distribution = new Distribution();
                distribution.setType(assembler.getDistributionType());
                distribution.setStereotype(assembler.getStereotype());
                distribution.setName(assembler.getName());
                this.model.getDistributions().put(assembler.getName(), distribution);
            }
            distribution.setName(assembler.getName());
            distribution.setType(assembler.getDistributionType());
            distribution.setActive(assembler.getActive());
            if (assembler instanceof JavaAssembler) {
                distribution.getExecutable().setName(((JavaAssembler)assembler).getExecutable());
                distribution.setJava(((JavaAssembler)assembler).getJava());
                if (assembler instanceof NativeImageAssembler) {
                    distribution.getExecutable().setWindowsExtension(FileType.EXE.type());
                    distribution.getExtraProperties().put("graalVMNativeImage", "true");
                }
            } else if (assembler instanceof JavaArchiveAssembler) {
                JavaArchiveAssembler javaArchiveAssembler = (JavaArchiveAssembler)assembler;
                distribution.getExecutable().setName(javaArchiveAssembler.getExecutable().getName());
                distribution.getExecutable().setUnixExtension(javaArchiveAssembler.getExecutable().getUnixExtension());
                distribution.getExecutable().setWindowsExtension(javaArchiveAssembler.getExecutable().getWindowsExtension());
                distribution.getJava().setMainClass(javaArchiveAssembler.getJava().getMainClass());
                distribution.getJava().setMainModule(javaArchiveAssembler.getJava().getMainModule());
            }
            this.mergeArtifacts(assembler, distribution);
            LinkedHashMap<String, Object> extraProperties = new LinkedHashMap<String, Object>(distribution.getExtraProperties());
            extraProperties.putAll(assembler.getExtraProperties());
            distribution.mergeExtraProperties(extraProperties);
        }
    }

    private void mergeArtifacts(Assembler<?> assembler, Distribution distribution) {
        for (Artifact incoming : assembler.getOutputs()) {
            Optional<Artifact> artifact = distribution.getArtifacts().stream().filter(other -> {
                if (this.isPlatformSelected(incoming)) {
                    incoming.select();
                }
                if (this.isPlatformSelected((Artifact)other)) {
                    other.select();
                }
                if (incoming.isSelected() && other.isSelected()) {
                    Path p1 = incoming.getResolvedPath(this, assembler);
                    Path p2 = other.getResolvedPath(this, distribution);
                    return p1.equals(p2);
                }
                return false;
            }).findFirst();
            if (artifact.isPresent()) {
                artifact.get().mergeWith(incoming);
                continue;
            }
            distribution.addArtifact(incoming);
        }
    }

    public boolean isPlatformSelected(Artifact artifact) {
        return this.isPlatformSelected(artifact.getPlatform());
    }

    public boolean isPlatformSelected(String platform) {
        if (StringUtils.isBlank((String)platform)) {
            return true;
        }
        if (!this.selectedPlatforms.isEmpty()) {
            return this.selectedPlatforms.stream().anyMatch(selected -> PlatformUtils.isCompatible((String)selected, (String)platform));
        }
        if (!this.rejectedPlatforms.isEmpty()) {
            return this.rejectedPlatforms.stream().noneMatch(selected -> PlatformUtils.isCompatible((String)selected, (String)platform));
        }
        return true;
    }

    public JReleaserLogger getLogger() {
        return this.logger;
    }

    public Configurer getConfigurer() {
        return this.configurer;
    }

    public JReleaserContext.Mode getMode() {
        return this.mode;
    }

    public JReleaserModel getModel() {
        return this.model;
    }

    public Path getBasedir() {
        return this.basedir;
    }

    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    public Path getChecksumsDirectory() {
        return this.outputDirectory.resolve("checksums");
    }

    public Path getCatalogsDirectory() {
        return this.outputDirectory.resolve("catalogs");
    }

    public Path getSignaturesDirectory() {
        return this.outputDirectory.resolve("signatures");
    }

    public Path getPrepareDirectory() {
        return this.outputDirectory.resolve("prepare");
    }

    public Path getPackageDirectory() {
        return this.outputDirectory.resolve("package");
    }

    public Path getAssembleDirectory() {
        return this.outputDirectory.resolve("assemble");
    }

    public Path getDownloadDirectory() {
        return this.outputDirectory.resolve("download");
    }

    public Path getArtifactsDirectory() {
        return this.outputDirectory.resolve("artifacts");
    }

    public Path getDeployDirectory() {
        return this.outputDirectory.resolve("deploy");
    }

    public boolean isDryrun() {
        return this.dryrun;
    }

    public boolean isGitRootSearch() {
        return this.gitRootSearch;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public JReleaserContext.Changelog getChangelog() {
        return this.changelog;
    }

    public Releaser<?> getReleaser() {
        return this.releaser;
    }

    public void setReleaser(Releaser<?> releaser) {
        this.releaser = releaser;
    }

    private List<String> normalize(List<String> list) {
        if (null == list || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tmp = new ArrayList<String>(list);
        for (int i = 0; i < tmp.size(); ++i) {
            String s = ((String)tmp.get(i)).trim();
            if (!s.contains("-")) {
                s = StringUtils.getHyphenatedName((String)s);
            }
            tmp.set(i, s.toLowerCase(Locale.ENGLISH));
        }
        return tmp;
    }

    public List<WorkflowListener> getWorkflowListeners() {
        return this.workflowListeners;
    }

    public void setWorkflowListeners(Collection<WorkflowListener> workflowListeners) {
        this.workflowListeners.clear();
        this.workflowListeners.addAll(workflowListeners);
    }

    public List<String> getIncludedAnnouncers() {
        return this.includedAnnouncers;
    }

    public void setIncludedAnnouncers(List<String> includedAnnouncers) {
        this.includedAnnouncers.clear();
        this.includedAnnouncers.addAll(this.normalize(includedAnnouncers));
    }

    public List<String> getIncludedAssemblers() {
        return this.includedAssemblers;
    }

    public void setIncludedAssemblers(List<String> includedAssemblerTypes) {
        this.includedAssemblers.clear();
        this.includedAssemblers.addAll(this.normalize(includedAssemblerTypes));
    }

    public List<String> getIncludedCatalogers() {
        return this.includedCatalogers;
    }

    public void setIncludedCatalogers(List<String> includedCatalogers) {
        this.includedCatalogers.clear();
        this.includedCatalogers.addAll(this.normalize(includedCatalogers));
    }

    public List<String> getIncludedDistributions() {
        return this.includedDistributions;
    }

    public void setIncludedDistributions(List<String> includedDistributions) {
        this.includedDistributions.clear();
        this.includedDistributions.addAll(includedDistributions);
    }

    public List<String> getIncludedPackagers() {
        return this.includedPackagers;
    }

    public void setIncludedPackagers(List<String> includedPackagers) {
        this.includedPackagers.clear();
        this.includedPackagers.addAll(includedPackagers);
    }

    public List<String> getIncludedDownloaderTypes() {
        return this.includedDownloaderTypes;
    }

    public void setIncludedDownloaderTypes(List<String> includedDownloaderTypes) {
        this.includedDownloaderTypes.clear();
        this.includedDownloaderTypes.addAll(this.normalize(includedDownloaderTypes));
    }

    public List<String> getIncludedDownloaderNames() {
        return this.includedDownloaderNames;
    }

    public void setIncludedDownloaderNames(List<String> includedDownloaderNames) {
        this.includedDownloaderNames.clear();
        this.includedDownloaderNames.addAll(includedDownloaderNames);
    }

    public List<String> getIncludedDeployerTypes() {
        return this.includedDeployerTypes;
    }

    public void setIncludedDeployerTypes(List<String> includedDeployerTypes) {
        this.includedDeployerTypes.clear();
        this.includedDeployerTypes.addAll(this.normalize(includedDeployerTypes));
    }

    public List<String> getIncludedDeployerNames() {
        return this.includedDeployerNames;
    }

    public void setIncludedDeployerNames(List<String> includedDeployerNames) {
        this.includedDeployerNames.clear();
        this.includedDeployerNames.addAll(includedDeployerNames);
    }

    public List<String> getIncludedUploaderTypes() {
        return this.includedUploaderTypes;
    }

    public void setIncludedUploaderTypes(List<String> includedUploaderTypes) {
        this.includedUploaderTypes.clear();
        this.includedUploaderTypes.addAll(this.normalize(includedUploaderTypes));
    }

    public List<String> getIncludedUploaderNames() {
        return this.includedUploaderNames;
    }

    public void setIncludedUploaderNames(List<String> includedUploaderNames) {
        this.includedUploaderNames.clear();
        this.includedUploaderNames.addAll(includedUploaderNames);
    }

    public List<String> getExcludedAnnouncers() {
        return this.excludedAnnouncers;
    }

    public void setExcludedAnnouncers(List<String> excludedAnnouncers) {
        this.excludedAnnouncers.clear();
        this.excludedAnnouncers.addAll(this.normalize(excludedAnnouncers));
    }

    public List<String> getExcludedAssemblers() {
        return this.excludedAssemblers;
    }

    public void setExcludedAssemblers(List<String> excludedAssemblerTypes) {
        this.excludedAssemblers.clear();
        this.excludedAssemblers.addAll(this.normalize(excludedAssemblerTypes));
    }

    public List<String> getExcludedCatalogers() {
        return this.excludedCatalogers;
    }

    public void setExcludedCatalogers(List<String> excludedCatalogers) {
        this.excludedCatalogers.clear();
        this.excludedCatalogers.addAll(this.normalize(excludedCatalogers));
    }

    public List<String> getExcludedDistributions() {
        return this.excludedDistributions;
    }

    public void setExcludedDistributions(List<String> excludedDistributions) {
        this.excludedDistributions.clear();
        this.excludedDistributions.addAll(excludedDistributions);
    }

    public List<String> getExcludedPackagers() {
        return this.excludedPackagers;
    }

    public void setExcludedPackagers(List<String> excludedPackagers) {
        this.excludedPackagers.clear();
        this.excludedPackagers.addAll(this.normalize(excludedPackagers));
    }

    public List<String> getExcludedDownloaderTypes() {
        return this.excludedDownloaderTypes;
    }

    public void setExcludedDownloaderTypes(List<String> excludedDownloaderTypes) {
        this.excludedDownloaderTypes.clear();
        this.excludedDownloaderTypes.addAll(this.normalize(excludedDownloaderTypes));
    }

    public List<String> getExcludedDownloaderNames() {
        return this.excludedDownloaderNames;
    }

    public void setExcludedDownloaderNames(List<String> excludedDownloaderNames) {
        this.excludedDownloaderNames.clear();
        this.excludedDownloaderNames.addAll(excludedDownloaderNames);
    }

    public List<String> getExcludedDeployerTypes() {
        return this.excludedDeployerTypes;
    }

    public void setExcludedDeployerTypes(List<String> excludedDeployerTypes) {
        this.excludedDeployerTypes.clear();
        this.excludedDeployerTypes.addAll(this.normalize(excludedDeployerTypes));
    }

    public List<String> getExcludedDeployerNames() {
        return this.excludedDeployerNames;
    }

    public void setExcludedDeployerNames(List<String> excludedDeployerNames) {
        this.excludedDeployerNames.clear();
        this.excludedDeployerNames.addAll(excludedDeployerNames);
    }

    public List<String> getExcludedUploaderTypes() {
        return this.excludedUploaderTypes;
    }

    public void setExcludedUploaderTypes(List<String> excludedUploaderTypes) {
        this.excludedUploaderTypes.clear();
        this.excludedUploaderTypes.addAll(this.normalize(excludedUploaderTypes));
    }

    public List<String> getExcludedUploaderNames() {
        return this.excludedUploaderNames;
    }

    public void setExcludedUploaderNames(List<String> excludedUploaderNames) {
        this.excludedUploaderNames.clear();
        this.excludedUploaderNames.addAll(excludedUploaderNames);
    }

    public JReleaserCommand getCommand() {
        return this.command;
    }

    public void setCommand(JReleaserCommand command) {
        this.command = command;
    }

    public TemplateContext props() {
        TemplateContext props = new TemplateContext(this.model.props());
        props.set("basedir", (Object)this.getBasedir());
        props.set("baseOutputDirectory", (Object)this.getOutputDirectory().getParent());
        props.set("outputDirectory", (Object)this.getOutputDirectory());
        props.set("checksumDirectory", (Object)this.getChecksumsDirectory());
        props.set("catalogsDirectory", (Object)this.getCatalogsDirectory());
        props.set("signaturesDirectory", (Object)this.getSignaturesDirectory());
        props.set("prepareDirectory", (Object)this.getPrepareDirectory());
        props.set("packageDirectory", (Object)this.getPackageDirectory());
        props.set("downloadDirectory", (Object)this.getDownloadDirectory());
        props.set("assembleDirectory", (Object)this.getAssembleDirectory());
        props.set("artifactsDirectory", (Object)this.getArtifactsDirectory());
        props.set("deployDirectory", (Object)this.getDeployDirectory());
        if (null != this.getCommand()) {
            props.set("command", (Object)this.getCommand().toStep());
        }
        return props;
    }

    public TemplateContext fullProps() {
        TemplateContext props = new TemplateContext(this.props());
        props.setAll(this.model.props());
        return props;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String toString() {
        return "JReleaserContext[basedir=" + this.basedir.toAbsolutePath() + ", outputDirectory=" + this.outputDirectory.toAbsolutePath() + ", dryrun=" + this.dryrun + ", gitRootSearch=" + this.gitRootSearch + ", strict=" + this.strict + ", mode=" + this.mode + "]";
    }

    public void report() {
        Project project = this.model.getProject();
        SortedProperties props = new SortedProperties();
        props.put("timestamp", this.model.getTimestamp());
        props.put("platform", PlatformUtils.getCurrentFull());
        props.put("platformReplaced", this.model.getPlatform().applyReplacements(PlatformUtils.getCurrentFull()));
        if (null != this.model.getCommit()) {
            props.put("commitShortHash", this.model.getCommit().getShortHash());
            props.put("commitFullHash", this.model.getCommit().getFullHash());
        }
        props.put("projectName", project.getName());
        props.put("projectVersion", project.getVersion());
        props.put("projectSnapshot", String.valueOf(project.isSnapshot()));
        if (null != this.model.getCommit()) {
            BaseReleaser<?, ?> releaser = this.model.getRelease().getReleaser();
            props.put("tagName", releaser.getEffectiveTagName(this.model));
            String previousTagName = releaser.getResolvedPreviousTagName(this.model);
            if (StringUtils.isNotBlank((String)previousTagName)) {
                props.put("previousTagName", previousTagName);
            }
            props.put("releaseBranch", releaser.getBranch());
            if (releaser.isReleaseSupported()) {
                props.put("releaseName", releaser.getEffectiveReleaseName());
                props.put("milestoneName", releaser.getMilestone().getEffectiveName());
            }
        }
        props.put("javaVersion", System.getProperty("java.version"));
        props.put("javaVendor", System.getProperty("java.vendor"));
        props.put("javaVmVersion", System.getProperty("java.vm.version"));
        Map<String, Object> resolvedExtraProperties = project.resolvedExtraProperties();
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionMajor")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionMinor")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionPatch")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionNumber")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionPrerelease")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionTag")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionBuild")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionOptional")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionYear")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionMonth")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionDay")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionWeek")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionMicro")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.prefix() + StringUtils.capitalize((String)"versionModifier")), resolvedExtraProperties, (Properties)props);
        props.putAll(this.getAdditionalProperties());
        Path output = this.getOutputDirectory().resolve("output.properties");
        try (FileOutputStream out = new FileOutputStream(output.toFile());){
            this.logger.info(RB.$((String)"context.writing.properties", (Object[])new Object[0]), new Object[]{this.relativizeToBasedir(output)});
            props.store(out, "JReleaser " + JReleaserVersion.getPlainVersion());
        }
        catch (IOException ignored) {
            this.logger.warn(RB.$((String)"context.writing.properties.error", (Object[])new Object[0]), new Object[]{this.relativizeToBasedir(output)});
        }
    }

    public void nag(String version, String message) {
        this.logger.warn(RB.$((String)"context.nag", (Object[])new Object[]{message, version}));
    }

    public Keyring createKeyring() throws SigningException {
        try {
            Signing signing = this.model.getSigning();
            if (signing.getMode() == Signing.Mode.FILE) {
                return new FilesKeyring(signing.isVerify() ? this.basedir.resolve(signing.getPublicKey()) : null, this.basedir.resolve(signing.getSecretKey())).initialize(signing.isArmored());
            }
            return new InMemoryKeyring(signing.isVerify() ? signing.getPublicKey().getBytes(StandardCharsets.UTF_8) : null, signing.getSecretKey().getBytes(StandardCharsets.UTF_8)).initialize(signing.isArmored());
        }
        catch (IOException | PGPException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_init_keyring", (Object[])new Object[0]), e);
        }
    }

    public boolean isDistributionIncluded(Distribution distribution) {
        String distributionName = distribution.getName();
        if (!this.includedDistributions.isEmpty()) {
            return this.includedDistributions.contains(distributionName);
        }
        if (!this.excludedDistributions.isEmpty()) {
            return !this.excludedDistributions.contains(distributionName);
        }
        return true;
    }

    public void fireSessionStartEvent() throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onSessionStart(this.asImmutable());
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void fireSessionEndEvent() throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onSessionEnd(this.asImmutable());
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void fireWorkflowEvent(ExecutionEvent event) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onWorkflowStep(event, this.asImmutable());
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void fireAnnounceStepEvent(ExecutionEvent event, Announcer announcer) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onAnnounceStep(event, this.asImmutable(), announcer);
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void fireAssembleStepEvent(ExecutionEvent event, org.jreleaser.model.api.assemble.Assembler assembler) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onAssembleStep(event, this.asImmutable(), assembler);
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void fireCatalogStepEvent(ExecutionEvent event, Cataloger cataloger) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onCatalogStep(event, this.asImmutable(), cataloger);
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void fireDeployStepEvent(ExecutionEvent event, Deployer deployer) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onDeployStep(event, this.asImmutable(), deployer);
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void fireDownloadStepEvent(ExecutionEvent event, Downloader downloader) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onDownloadStep(event, this.asImmutable(), downloader);
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void fireUploadStepEvent(ExecutionEvent event, Uploader uploader) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onUploadStep(event, this.asImmutable(), uploader);
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void fireReleaseStepEvent(ExecutionEvent event, org.jreleaser.model.api.release.Releaser releaser) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onReleaseStep(event, this.asImmutable(), releaser);
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void fireDistributionStartEvent(org.jreleaser.model.api.distributions.Distribution distribution) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onDistributionStart(this.asImmutable(), distribution);
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void fireDistributionEndEvent(org.jreleaser.model.api.distributions.Distribution distribution) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onDistributionEnd(this.asImmutable(), distribution);
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void firePackagerPackageEvent(ExecutionEvent event, org.jreleaser.model.api.distributions.Distribution distribution, Packager packager) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onPackagerPackageStep(event, this.asImmutable(), distribution, packager);
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void firePackagerPublishEvent(ExecutionEvent event, org.jreleaser.model.api.distributions.Distribution distribution, Packager packager) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onPackagerPublishStep(event, this.asImmutable(), distribution, packager);
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public void firePackagerPrepareEvent(ExecutionEvent event, org.jreleaser.model.api.distributions.Distribution distribution, Packager packager) throws WorkflowListenerException {
        for (WorkflowListener workflowListener : this.workflowListeners) {
            try {
                workflowListener.onPackagerPrepareStep(event, this.asImmutable(), distribution, packager);
            }
            catch (RuntimeException e) {
                throw new WorkflowListenerException(workflowListener, e);
            }
        }
    }

    public static enum Configurer {
        CLI("CLI flags"),
        CLI_YAML("CLI yaml DSL"),
        CLI_TOML("CLI toml DSL"),
        CLI_JSON("CLI json DSL"),
        MAVEN("Maven DSL"),
        GRADLE("Gradle DSL");

        private final String dsl;

        private Configurer(String dsl) {
            this.dsl = dsl;
        }

        public String toString() {
            return this.dsl;
        }
    }

    private static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 8794541421003888869L;

        private SortedProperties() {
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            int javaMajorVersion = SemanticVersion.javaMajorVersion();
            if (javaMajorVersion < 11) {
                return super.entrySet();
            }
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            for (Object k : this.keySet()) {
                map.put(String.valueOf(k), this.get(k));
            }
            return map.entrySet();
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            int javaMajorVersion = SemanticVersion.javaMajorVersion();
            if (javaMajorVersion >= 11) {
                return super.keys();
            }
            Set<Object> keySet = this.keySet();
            ArrayList<String> keys = new ArrayList<String>(keySet.size());
            for (Object key : keySet) {
                keys.add(key.toString());
            }
            Collections.sort(keys);
            return new IteratorEnumeration<Object>(keys.iterator());
        }
    }

    private static class IteratorEnumeration<E>
    implements Enumeration<E> {
        private final Iterator<? extends E> iterator;

        public IteratorEnumeration(Iterator<? extends E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }
    }
}

