/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.mavencentral;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.function.CheckedPredicate;
import dev.failsafe.function.CheckedSupplier;
import feign.FeignException;
import feign.RequestInterceptor;
import feign.Response;
import feign.RetryableException;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import feign.form.FormData;
import feign.jackson.JacksonDecoder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.feign.TokenAuthRequestInterceptor;
import org.jreleaser.sdk.mavencentral.MavenCentralException;
import org.jreleaser.sdk.mavencentral.api.Deployment;
import org.jreleaser.sdk.mavencentral.api.MavenCentralAPI;
import org.jreleaser.sdk.mavencentral.api.MavenCentralAPIException;
import org.jreleaser.sdk.mavencentral.api.State;
import org.jreleaser.util.StringUtils;

public class MavenCentral {
    private final JReleaserContext context;
    private final MavenCentralAPI api;
    private final boolean dryrun;
    private final Retrier retrier;

    public MavenCentral(JReleaserContext context, String apiHost, String username, String password, int connectTimeout, int readTimeout, boolean dryrun, int retryDelay, int maxRetries) {
        Objects.requireNonNull(context, "'context' must not be blank");
        StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank");
        StringUtils.requireNonBlank((String)username, (String)"'username' must not be blank");
        StringUtils.requireNonBlank((String)password, (String)"'password' must not be blank");
        this.context = context;
        this.dryrun = dryrun;
        this.retrier = new Retrier(context.getLogger(), retryDelay, maxRetries);
        this.api = (MavenCentralAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).decoder((Decoder)new MavenCentralDecoder()).requestInterceptor((RequestInterceptor)new TokenAuthRequestInterceptor("Bearer", username, password)).errorDecoder((ErrorDecoder)new MavenCentralErrorDecoder(context.getLogger())).target(MavenCentralAPI.class, apiHost);
    }

    public Optional<Deployment> status(String deploymentId) throws MavenCentralException {
        return this.wrap(() -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("id", deploymentId);
            return Optional.ofNullable(this.api.status(params));
        });
    }

    public void publish(String deploymentId) throws MavenCentralException {
        this.wrap(() -> {
            this.api.publish(deploymentId);
            this.waitForState(deploymentId, State.PUBLISHED, State.FAILED);
        });
    }

    public String upload(Path bundle) throws MavenCentralException {
        return this.wrap(() -> {
            FormData formData = ClientUtils.toFormData((Path)bundle);
            String deploymentId = this.api.upload(formData);
            this.waitForState(deploymentId, State.VALIDATED, State.FAILED);
            return deploymentId;
        });
    }

    private void wrap(MavenCentralOperation operation) throws MavenCentralException {
        try {
            if (!this.dryrun) {
                operation.execute();
            }
        }
        catch (MavenCentralException e) {
            this.context.getLogger().trace((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new MavenCentralException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e);
        }
    }

    private <T> T wrap(Callable<T> callable) throws MavenCentralException {
        try {
            if (!this.dryrun) {
                return callable.call();
            }
            return null;
        }
        catch (MavenCentralException e) {
            this.context.getLogger().trace((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.context.getLogger().trace((Throwable)e);
            throw new MavenCentralException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e);
        }
    }

    private void waitForState(String deploymentId, State ... states) throws MavenCentralException {
        this.context.getLogger().debug(RB.$((String)"maven.central.wait.deployment.state", (Object[])new Object[]{deploymentId, Arrays.asList(states)}));
        Optional deployment = (Optional)this.retrier.retry(o -> o.map(Deployment::isTransitioning).orElse(false), () -> this.status(deploymentId));
        if (deployment.isPresent()) {
            if (((Deployment)deployment.get()).isTransitioning()) {
                throw new IllegalStateException(RB.$((String)"maven.central.wait.deployment.transitioning", (Object[])new Object[]{deploymentId}));
            }
            if (Arrays.binarySearch((Object[])states, (Object)((Deployment)deployment.get()).getDeploymentState()) < 0) {
                Set<String> messages = this.resolveErrorMessages((Deployment)deployment.get());
                String title = RB.$((String)"maven.central.wait.deployment.invalid.state", (Object[])new Object[]{deploymentId, Arrays.asList(states), ((Deployment)deployment.get()).getDeploymentState()});
                if (!messages.isEmpty()) {
                    throw new MavenCentralException(title + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), messages));
                }
                throw new MavenCentralException(title);
            }
        }
    }

    private Set<String> resolveErrorMessages(Deployment deployment) {
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        for (Map.Entry<String, List<String>> e : deployment.getErrors().entrySet()) {
            for (String error : e.getValue()) {
                messages.add(e.getKey() + " " + error);
            }
        }
        return messages;
    }

    public static class Retrier {
        private final JReleaserLogger context;
        private final int delay;
        private final int maxRetries;

        public Retrier(JReleaserLogger context, int delay, int maxRetries) {
            this.context = context;
            this.delay = delay;
            this.maxRetries = maxRetries;
        }

        public <R> R retry(CheckedPredicate<R> stopFunction, CheckedSupplier<R> retriableOperation) {
            int maxAttempts = this.maxRetries + 1;
            RetryPolicy policy = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handle(new Class[]{IllegalStateException.class, MavenCentralAPIException.class})).handleResultIf(stopFunction)).withDelay(Duration.ofSeconds(this.delay)).withMaxRetries(this.maxRetries).onFailedAttempt(event -> {
                this.context.info(RB.$((String)"nexus.retry.attempt", (Object[])new Object[0]), new Object[]{event.getAttemptCount(), maxAttempts});
                this.context.debug(RB.$((String)"nexus.retry.failed.attempt", (Object[])new Object[0]), new Object[]{event.getAttemptCount(), maxAttempts, event.getLastResult()});
            }).build();
            return (R)Failsafe.with((Policy)policy, (Policy[])new RetryPolicy[0]).get(retriableOperation);
        }
    }

    static class MavenCentralDecoder
    implements Decoder {
        private final JacksonDecoder json = new JacksonDecoder(new ObjectMapper().registerModule((Module)new JavaTimeModule()));

        MavenCentralDecoder() {
        }

        public Object decode(Response response, Type type) throws IOException, DecodeException, FeignException {
            if (response.request().url().endsWith("/upload")) {
                InputStreamReader reader = new InputStreamReader(response.body().asInputStream(), StandardCharsets.UTF_8);
                return IOUtils.toString((Reader)reader);
            }
            return this.json.decode(response, type);
        }
    }

    static class MavenCentralErrorDecoder
    implements ErrorDecoder {
        private final ErrorDecoder defaultErrorDecoder = new ErrorDecoder.Default();
        private final JReleaserLogger logger;

        public MavenCentralErrorDecoder(JReleaserLogger logger) {
            this.logger = logger;
        }

        public Exception decode(String methodKey, Response response) {
            Exception exception = this.defaultErrorDecoder.decode(methodKey, response);
            if (exception instanceof RetryableException) {
                return exception;
            }
            if (response.status() >= 500) {
                this.logger.trace(response.request().httpMethod() + " " + response.request().url());
                this.logger.trace(response.status() + " " + response.reason());
                if (null != response.body() && null != response.body().length() && response.body().length() > 0) {
                    try (InputStreamReader reader = new InputStreamReader(response.body().asInputStream(), StandardCharsets.UTF_8);){
                        this.logger.trace(IOUtils.toString((Reader)reader));
                    }
                    catch (IOException e) {
                        this.logger.trace((Throwable)e);
                    }
                }
                return new RetryableException(response.status(), response.reason(), response.request().httpMethod(), (Long)null, response.request());
            }
            return new MavenCentralAPIException(response.status(), response.reason(), response.headers());
        }
    }

    static interface MavenCentralOperation {
        public void execute() throws MavenCentralException;
    }
}

