/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.release;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.JReleaserOutput;
import org.jreleaser.model.api.release.Releaser;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.CodebergReleaser;
import org.jreleaser.model.internal.release.GenericGitReleaser;
import org.jreleaser.model.internal.release.GiteaReleaser;
import org.jreleaser.model.internal.release.GithubReleaser;
import org.jreleaser.model.internal.release.GitlabReleaser;

public final class Release
extends AbstractModelObject<Release>
implements Domain {
    private static final long serialVersionUID = -7382956682399917298L;
    private GithubReleaser github;
    private GitlabReleaser gitlab;
    private GiteaReleaser gitea;
    private CodebergReleaser codeberg;
    private GenericGitReleaser generic;
    @JsonIgnore
    private final org.jreleaser.model.api.release.Release immutable = new org.jreleaser.model.api.release.Release(){
        private static final long serialVersionUID = 8607297611597648860L;

        public org.jreleaser.model.api.release.GithubReleaser getGithub() {
            return null != Release.this.github ? Release.this.github.asImmutable() : null;
        }

        public org.jreleaser.model.api.release.GitlabReleaser getGitlab() {
            return null != Release.this.gitlab ? Release.this.gitlab.asImmutable() : null;
        }

        public org.jreleaser.model.api.release.GiteaReleaser getGitea() {
            return null != Release.this.gitea ? Release.this.gitea.asImmutable() : null;
        }

        public org.jreleaser.model.api.release.CodebergReleaser getCodeberg() {
            return null != Release.this.codeberg ? Release.this.codeberg.asImmutable() : null;
        }

        public org.jreleaser.model.api.release.GenericGitReleaser getGeneric() {
            return null != Release.this.generic ? Release.this.generic.asImmutable() : null;
        }

        public Releaser getReleaser() {
            return Release.this.releaser();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Release.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.release.Release asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Release source) {
        this.github = this.merge(this.github, source.github);
        this.gitlab = this.merge(this.gitlab, source.gitlab);
        this.gitea = this.merge(this.gitea, source.gitea);
        this.codeberg = this.merge(this.codeberg, source.codeberg);
        this.generic = this.merge(this.generic, source.generic);
    }

    public GithubReleaser getGithub() {
        return this.github;
    }

    public void setGithub(GithubReleaser github) {
        this.github = github;
    }

    public GitlabReleaser getGitlab() {
        return this.gitlab;
    }

    public void setGitlab(GitlabReleaser gitlab) {
        this.gitlab = gitlab;
    }

    public GiteaReleaser getGitea() {
        return this.gitea;
    }

    public void setGitea(GiteaReleaser gitea) {
        this.gitea = gitea;
    }

    public CodebergReleaser getCodeberg() {
        return this.codeberg;
    }

    public void setCodeberg(CodebergReleaser codeberg) {
        this.codeberg = codeberg;
        JReleaserOutput.nag((String)"release.codeberg is deprecated since 1.6.0 and will be removed in 2.0.0. Use release.gitea instead");
    }

    public GenericGitReleaser getGeneric() {
        return this.generic;
    }

    public void setGeneric(GenericGitReleaser generic) {
        this.generic = generic;
    }

    public BaseReleaser<?, ?> getReleaser() {
        if (null != this.github) {
            return this.github;
        }
        if (null != this.gitlab) {
            return this.gitlab;
        }
        if (null != this.gitea) {
            return this.gitea;
        }
        if (null != this.codeberg) {
            return this.codeberg;
        }
        return this.generic;
    }

    public Releaser releaser() {
        if (null != this.github) {
            return this.github.asImmutable();
        }
        if (null != this.gitlab) {
            return this.gitlab.asImmutable();
        }
        if (null != this.gitea) {
            return this.gitea.asImmutable();
        }
        if (null != this.codeberg) {
            return this.codeberg.asImmutable();
        }
        if (null != this.generic) {
            return this.generic.asImmutable();
        }
        return null;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (null != this.github) {
            map.put("github", this.github.asMap(full));
        }
        if (null != this.gitlab) {
            map.put("gitlab", this.gitlab.asMap(full));
        }
        if (null != this.gitea) {
            map.put("gitea", this.gitea.asMap(full));
        }
        if (null != this.codeberg) {
            map.put("codeberg", this.codeberg.asMap(full));
        }
        if (null != this.generic) {
            map.put("generic", this.generic.asMap(full));
        }
        return map;
    }
}

