/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.api.packagers.JibConfiguration;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.AbstractArtifact;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.JibConfiguration;
import org.jreleaser.model.internal.packagers.JibPackager;
import org.jreleaser.model.internal.packagers.JibSpec;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.DefaultVersions;
import org.jreleaser.util.Errors;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class JibPackagerValidator {
    private static final Set<String> EXTENSIONS = CollectionUtils.setOf((Object[])new String[]{FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension(), FileType.ZIP.extension()});

    private JibPackagerValidator() {
    }

    public static void validateJib(JReleaserContext context, Distribution distribution, JibPackager packager, Errors errors) {
        String element = "distribution." + distribution.getName() + ".jib";
        context.getLogger().debug(element);
        JReleaserModel model = context.getModel();
        Project project = model.getProject();
        JibPackager parentPackager = model.getPackagers().getJib();
        Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType(), parentPackager);
        if (!packager.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.isEmpty()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
            packager.disable();
            return;
        }
        for (JibSpec spec : packager.getSpecs().values()) {
            if (!spec.isActiveSet() && packager.isActiveSet()) {
                spec.setActive(packager.getActive());
            }
            Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType() + "." + spec.getName(), "NEVER");
            spec.resolveEnabled(context.getModel().getProject());
        }
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        Validator.validateCommitAuthor(packager, parentPackager);
        JibPackager.JibRepository repository = packager.getPackagerRepository();
        if (!repository.isVersionedSubfoldersSet()) {
            repository.setVersionedSubfolders(parentPackager.getPackagerRepository().isVersionedSubfolders());
        }
        if (StringUtils.isBlank((String)repository.getName())) {
            repository.setName(project.getName() + "-jib");
        }
        Validator.validateRepository(context, distribution, repository, parentPackager.getRepositoryTap(), "jib.repository");
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        Validator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        if (StringUtils.isBlank((String)packager.getVersion())) {
            packager.setVersion(DefaultVersions.getInstance().getJibVersion());
        }
        if (StringUtils.isBlank((String)packager.getCreationTime())) {
            packager.setCreationTime(parentPackager.getCreationTime());
        }
        if (StringUtils.isBlank((String)packager.getUser())) {
            packager.setUser(parentPackager.getUser());
        }
        if (null == packager.getFormat()) {
            packager.setFormat(parentPackager.getFormat());
        }
        if (null == packager.getFormat()) {
            packager.setFormat(JibConfiguration.Format.DOCKER);
        }
        if (StringUtils.isBlank((String)packager.getWorkingDirectory())) {
            packager.setWorkingDirectory(parentPackager.getWorkingDirectory());
        }
        if (StringUtils.isBlank((String)packager.getWorkingDirectory())) {
            packager.setWorkingDirectory("/workspace");
        }
        if (packager.getVolumes().isEmpty()) {
            packager.setVolumes(parentPackager.getVolumes());
        }
        if (packager.getExposedPorts().isEmpty()) {
            packager.setExposedPorts(parentPackager.getExposedPorts());
        }
        if (StringUtils.isBlank((String)packager.getBaseImage())) {
            packager.setBaseImage(parentPackager.getBaseImage());
        }
        JibPackagerValidator.validateBaseImage(distribution, packager, errors);
        if (packager.getImageNames().isEmpty()) {
            packager.setImageNames(parentPackager.getImageNames());
        }
        if (packager.getImageNames().isEmpty()) {
            packager.addImageName("{{repoOwner}}/{{distributionName}}:{{tagName}}");
        }
        if (context.getModel().getProject().isSnapshot()) {
            Optional<String> imageName = packager.getImageNames().stream().filter(n -> n.endsWith(":{{tagName}}") || n.endsWith(":{{ tagName }}")).findFirst();
            packager.setImageNames(Collections.singleton(imageName.orElse(packager.getImageNames().iterator().next())));
        }
        LinkedHashMap<String, String> environment = new LinkedHashMap<String, String>();
        environment.putAll(parentPackager.getEnvironment());
        environment.putAll(packager.getEnvironment());
        packager.setEnvironment(environment);
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.putAll(parentPackager.getLabels());
        labels.putAll(packager.getLabels());
        packager.setLabels(labels);
        if (!packager.getLabels().containsKey("org.opencontainers.image.title")) {
            packager.getLabels().put("org.opencontainers.image.title", "{{distributionName}}");
        }
        JibPackagerValidator.validateLabels(packager);
        DistributionsValidator.validateArtifactPlatforms(distribution, packager, candidateArtifacts, errors);
        JibPackagerValidator.validateRegistries(context, packager, parentPackager, errors, element);
        for (Map.Entry<String, JibSpec> e : packager.getSpecs().entrySet()) {
            JibSpec spec = e.getValue();
            if (StringUtils.isBlank((String)spec.getName())) {
                spec.setName(e.getKey());
            }
            JibPackagerValidator.validateJibSpec(context, distribution, spec, packager, errors);
        }
    }

    public static void validateJibSpec(JReleaserContext context, Distribution distribution, JibSpec spec, JibPackager jib, Errors errors) {
        if (!spec.isEnabled()) {
            return;
        }
        String element = "distribution." + distribution.getName() + ".jib.spec." + spec.getName();
        context.getLogger().debug(element);
        TemplateValidator.validateTemplate(context, distribution, spec, jib, errors);
        ExtraPropertiesValidator.mergeExtraProperties(spec, jib);
        JibPackagerValidator.validateBaseImage(distribution, spec, errors);
        if (spec.getImageNames().isEmpty()) {
            spec.addImageName("{{repoOwner}}/{{distributionName}}-{{jibSpecName}}:{{tagName}}");
        }
        if (context.getModel().getProject().isSnapshot()) {
            Optional<String> imageName = spec.getImageNames().stream().filter(n -> n.endsWith(":{{tagName}}") || n.endsWith(":{{ tagName }}")).findFirst();
            spec.setImageNames(Collections.singleton(imageName.orElse("{{repoOwner}}/{{distributionName}}-{{jibSpecName}}:{{tagName}}")));
        }
        LinkedHashMap<String, String> environment = new LinkedHashMap<String, String>();
        environment.putAll(jib.getEnvironment());
        environment.putAll(spec.getEnvironment());
        spec.setEnvironment(environment);
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.putAll(jib.getLabels());
        labels.putAll(spec.getLabels());
        if (!spec.getLabels().containsKey("org.opencontainers.image.title")) {
            labels.put("org.opencontainers.image.title", jib.getLabels().get("org.opencontainers.image.title") + "-{{jibSpecName}}");
        }
        spec.setLabels(labels);
        JibPackagerValidator.validateLabels(spec);
        if (StringUtils.isBlank((String)spec.getCreationTime())) {
            spec.setCreationTime(jib.getCreationTime());
        }
        if (StringUtils.isBlank((String)spec.getUser())) {
            spec.setUser(jib.getUser());
        }
        if (null == spec.getFormat()) {
            spec.setFormat(jib.getFormat());
        }
        if (null == spec.getFormat()) {
            spec.setFormat(JibConfiguration.Format.DOCKER);
        }
        if (StringUtils.isBlank((String)spec.getWorkingDirectory())) {
            spec.setWorkingDirectory(jib.getWorkingDirectory());
        }
        if (StringUtils.isBlank((String)spec.getWorkingDirectory())) {
            spec.setWorkingDirectory("/workspace");
        }
        if (spec.getVolumes().isEmpty()) {
            spec.setVolumes(jib.getVolumes());
        }
        if (spec.getExposedPorts().isEmpty()) {
            spec.setExposedPorts(jib.getExposedPorts());
        }
        JibPackagerValidator.validateRegistries(context, spec, jib, errors, element);
        long artifactCount = distribution.getArtifacts().stream().filter(AbstractArtifact::isActiveAndSelected).count();
        if (artifactCount > 1L && spec.getMatchers().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{element + ".matchers"}));
        }
        if (null == spec.getArtifact()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            spec.disable();
        }
    }

    private static void validateBaseImage(Distribution distribution, JibConfiguration jib, Errors errors) {
        if (StringUtils.isBlank((String)jib.getBaseImage())) {
            if (distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.SINGLE_JAR || DistributionsValidator.isGraalVMDistribution(distribution)) {
                if (StringUtils.isBlank((String)distribution.getJava().getVersion())) {
                    errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"distribution." + distribution.getName() + ".java.version"}));
                    return;
                }
                int version = Integer.parseInt(distribution.getJava().getVersion());
                boolean ltsmts = version == 8 || version % 2 == 1;
                jib.setBaseImage("azul/zulu-openjdk-alpine:{{distributionJavaVersion}}" + (ltsmts ? "-jre" : ""));
            } else if (distribution.getType() == Distribution.DistributionType.JLINK) {
                if (JibPackagerValidator.isAlpineCompatible(distribution, jib)) {
                    jib.setBaseImage("alpine:latest");
                } else {
                    jib.setBaseImage("ubuntu:latest");
                }
            } else {
                jib.setBaseImage("scratch");
            }
        } else if (jib instanceof JibSpec) {
            JibSpec spec = (JibSpec)jib;
            distribution.getArtifacts().stream().filter(artifact -> artifact.getPath().endsWith(".zip")).filter(spec::matches).findFirst().ifPresent(spec::setArtifact);
        }
    }

    private static boolean isAlpineCompatible(Distribution distribution, JibConfiguration jib) {
        List artifacts = distribution.getArtifacts().stream().filter(artifact -> EXTENSIONS.stream().anyMatch(ext -> artifact.getPath().endsWith((String)ext))).collect(Collectors.toList());
        if (jib instanceof JibSpec) {
            JibSpec spec = (JibSpec)jib;
            Optional<Artifact> artifact2 = artifacts.stream().filter(spec::matches).findFirst();
            if (artifact2.isPresent()) {
                spec.setArtifact(artifact2.get());
                return PlatformUtils.isAlpineLinux((String)artifact2.get().getPlatform());
            }
            return false;
        }
        return artifacts.stream().anyMatch(artifact -> PlatformUtils.isAlpineLinux((String)artifact.getPlatform()));
    }

    private static void validateLabels(JibConfiguration self) {
        if (!self.getLabels().containsKey("org.opencontainers.image.description")) {
            self.getLabels().put("org.opencontainers.image.description", "{{projectDescription}}");
        }
        if (!self.getLabels().containsKey("org.opencontainers.image.url")) {
            self.getLabels().put("org.opencontainers.image.url", "{{projectWebsite}}");
        }
        if (!self.getLabels().containsKey("org.opencontainers.image.licenses")) {
            self.getLabels().put("org.opencontainers.image.licenses", "{{projectLicense}}");
        }
        if (!self.getLabels().containsKey("org.opencontainers.image.version")) {
            self.getLabels().put("org.opencontainers.image.version", "{{projectVersion}}");
        }
        if (!self.getLabels().containsKey("org.opencontainers.image.revision")) {
            self.getLabels().put("org.opencontainers.image.revision", "{{commitFullHash}}");
        }
    }

    private static void validateRegistries(JReleaserContext context, JibConfiguration self, JibConfiguration other, Errors errors, String element) {
        JReleaserModel model = context.getModel();
        LinkedHashSet<JibConfiguration.Registry> registries = new LinkedHashSet<JibConfiguration.Registry>();
        registries.addAll(self.getRegistries());
        registries.addAll(other.getRegistries());
        self.setRegistries(registries);
        if (self.getRegistries().isEmpty()) {
            context.getLogger().warn(RB.$((String)"validation_jib_no_registries", (Object[])new Object[]{element}));
            return;
        }
        for (JibConfiguration.Registry registry : registries) {
            BaseReleaser<?, ?> releaser = model.getRelease().getReleaser();
            String registryName = registry.getName();
            if (StringUtils.isBlank((String)registry.getServer())) {
                registry.setServer("docker.io");
            }
            registry.setToPassword(Validator.checkProperty(context, JibPackagerValidator.resolveKeys(element, registryName, ".topassword"), "registry." + registryName + ".toPassword", registry.getToPassword(), (String)null));
            registry.setFromPassword(Validator.checkProperty(context, JibPackagerValidator.resolveKeys(element, registryName, ".frompassword"), "registry." + registryName + ".fromPassword", registry.getFromPassword(), (String)null));
            registry.setPassword(Validator.checkProperty(context, JibPackagerValidator.resolveKeys(element, registryName, ".password"), "registry." + registryName + ".password", registry.getPassword(), (String)null));
            if (StringUtils.isBlank((String)registry.getPassword()) && StringUtils.isBlank((String)registry.getToPassword())) {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{element + ".registry." + registryName + ".toPassword"}));
            }
            registry.setToUsername(Validator.checkProperty(context, JibPackagerValidator.resolveKeys(element, registryName, ".tousername"), "registry." + registryName + ".toUsername", registry.getToUsername(), (String)null));
            registry.setFromUsername(Validator.checkProperty(context, JibPackagerValidator.resolveKeys(element, registryName, ".fromusername"), "registry." + registryName + ".fromUsername", registry.getFromUsername(), (String)null));
            registry.setUsername(Validator.checkProperty(context, JibPackagerValidator.resolveKeys(element, registryName, ".username"), "registry." + registryName + ".username", registry.getUsername(), (String)null));
            if (!StringUtils.isBlank((String)registry.getToUsername()) || !StringUtils.isBlank((String)registry.getFromUsername()) || !StringUtils.isBlank((String)registry.getUsername())) continue;
            if (StringUtils.isNotBlank((String)registry.getToPassword())) {
                registry.setToUsername(releaser.getUsername());
                continue;
            }
            registry.setUsername(releaser.getUsername());
        }
    }

    private static List<String> resolveKeys(String element, String registryName, String property) {
        return CollectionUtils.listOf((Object[])new String[]{element + "." + registryName + property, "jib." + registryName + property});
    }
}

