/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Downloader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.SftpDownloader;
import org.jreleaser.model.validation.SshValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SftpDownloaderValidator
extends Validator {
    public static void validateSftpDownloader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("sftp");
        Map<String, SftpDownloader> sftp = context.getModel().getDownload().getSftp();
        for (Map.Entry<String, SftpDownloader> e : sftp.entrySet()) {
            e.getValue().setName(e.getKey());
            SftpDownloaderValidator.validateSftpDownloader(context, mode, e.getValue(), errors);
        }
    }

    private static void validateSftpDownloader(JReleaserContext context, JReleaserContext.Mode mode, SftpDownloader sftp, Errors errors) {
        context.getLogger().debug("sftp.{}", new Object[]{sftp.getName()});
        if (!sftp.isActiveSet()) {
            sftp.setActive(Active.ALWAYS);
        }
        if (!sftp.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        SshValidator.validateSsh(context, sftp, sftp.getName(), "SFTP", sftp.getType(), errors);
        SftpDownloaderValidator.validateTimeout(sftp);
        if (sftp.getAssets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"sftp." + sftp.getName() + ".assets"}));
        } else {
            int index = 0;
            for (Downloader.Asset asset : sftp.getAssets()) {
                if (!StringUtils.isBlank((String)asset.getInput())) continue;
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"sftp." + sftp.getName() + ".asset[" + index++ + "].input"}));
            }
        }
    }
}

