/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.model.Announce;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.ArticleValidator;
import org.jreleaser.model.validation.DiscordValidator;
import org.jreleaser.model.validation.DiscussionsValidator;
import org.jreleaser.model.validation.GitterValidator;
import org.jreleaser.model.validation.GoogleChatValidator;
import org.jreleaser.model.validation.MailValidator;
import org.jreleaser.model.validation.MastodonValidator;
import org.jreleaser.model.validation.MattermostValidator;
import org.jreleaser.model.validation.SdkmanAnnouncerValidator;
import org.jreleaser.model.validation.SlackValidator;
import org.jreleaser.model.validation.TeamsValidator;
import org.jreleaser.model.validation.TelegramValidator;
import org.jreleaser.model.validation.TwitterValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.model.validation.WebhooksValidator;
import org.jreleaser.model.validation.ZulipValidator;
import org.jreleaser.util.Errors;

public abstract class AnnouncersValidator
extends Validator {
    public static void validateAnnouncers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (!mode.validateConfig()) {
            return;
        }
        context.getLogger().debug("announce");
        Announce announce = context.getModel().getAnnounce();
        ArticleValidator.validateArticle(context, announce.getArticle(), errors);
        DiscussionsValidator.validateDiscussions(context, announce.getDiscussions(), errors);
        DiscordValidator.validateDiscord(context, announce.getDiscord(), errors);
        GitterValidator.validateGitter(context, announce.getGitter(), errors);
        GoogleChatValidator.validateGoogleChat(context, announce.getGoogleChat(), errors);
        MailValidator.validateMail(context, announce.getMail(), errors);
        MastodonValidator.validateMastodon(context, announce.getMastodon(), errors);
        MattermostValidator.validateMattermost(context, announce.getMattermost(), errors);
        SdkmanAnnouncerValidator.validateSdkmanAnnouncer(context, announce.getSdkman(), errors);
        SlackValidator.validateSlack(context, announce.getSlack(), errors);
        TeamsValidator.validateTeams(context, announce.getTeams(), errors);
        TelegramValidator.validateTelegram(context, announce.getTelegram(), errors);
        TwitterValidator.validateTwitter(context, announce.getTwitter(), errors);
        WebhooksValidator.validateWebhooks(context, announce.getConfiguredWebhooks(), errors);
        ZulipValidator.validateZulip(context, announce.getZulip(), errors);
        boolean activeSet = announce.isActiveSet();
        if (mode.validateConfig()) {
            announce.resolveEnabled(context.getModel().getProject());
        }
        if (announce.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = announce.getArticle().isEnabled() || announce.getDiscord().isEnabled() || announce.getDiscussions().isEnabled() || announce.getGitter().isEnabled() || announce.getGoogleChat().isEnabled() || announce.getMail().isEnabled() || announce.getMastodon().isEnabled() || announce.getMattermost().isEnabled() || announce.getSdkman().isEnabled() || announce.getSlack().isEnabled() || announce.getTeams().isEnabled() || announce.getTelegram().isEnabled() || announce.getTwitter().isEnabled() || announce.getConfiguredWebhooks().isEnabled() || announce.getZulip().isEnabled();
            if (!activeSet && !enabled) {
                announce.disable();
            }
        }
    }
}

