/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jreleaser.model.AbstractJavaAssembler;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.Templates;

public class Jpackage
extends AbstractJavaAssembler<Jpackage> {
    public static final String TYPE = "jpackage";
    private final Set<Artifact> runtimeImages = new LinkedHashSet<Artifact>();
    private final ApplicationPackage applicationPackage = new ApplicationPackage();
    private final Launcher launcher = new Launcher();
    private final Linux linux = new Linux();
    private final Windows windows = new Windows();
    private final Osx osx = new Osx();
    private String jlink;
    private Boolean attachPlatform;
    private Boolean verbose;

    public Jpackage() {
        super(TYPE);
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.NATIVE_PACKAGE;
    }

    @Override
    public void freeze() {
        super.freeze();
        this.runtimeImages.forEach(AbstractModelObject::freeze);
        this.applicationPackage.freeze();
        this.launcher.freeze();
        this.linux.freeze();
        this.windows.freeze();
        this.osx.freeze();
    }

    @Override
    public void merge(Jpackage jpackage) {
        this.freezeCheck();
        super.merge(jpackage);
        this.jlink = this.merge(this.jlink, jpackage.jlink);
        this.attachPlatform = this.merge(this.attachPlatform, jpackage.attachPlatform);
        this.verbose = this.merge(this.verbose, jpackage.verbose);
        this.setRuntimeImages(jpackage.runtimeImages);
        this.setApplicationPackage(jpackage.applicationPackage);
        this.setLauncher(jpackage.launcher);
        this.setLinux(jpackage.linux);
        this.setWindows(jpackage.windows);
        this.setOsx(jpackage.osx);
    }

    public String getJlink() {
        return this.jlink;
    }

    public void setJlink(String jlink) {
        this.freezeCheck();
        this.jlink = jlink;
    }

    public boolean isAttachPlatformSet() {
        return this.attachPlatform != null;
    }

    public boolean isAttachPlatform() {
        return this.attachPlatform != null && this.attachPlatform != false;
    }

    public void setAttachPlatform(Boolean attachPlatform) {
        this.freezeCheck();
        this.attachPlatform = attachPlatform;
    }

    public boolean isVerboseSet() {
        return this.verbose != null;
    }

    public boolean isVerbose() {
        return this.verbose != null && this.verbose != false;
    }

    public void setVerbose(Boolean verbose) {
        this.freezeCheck();
        this.verbose = verbose;
    }

    public Set<Artifact> getRuntimeImages() {
        return this.freezeWrap(Artifact.sortArtifacts(this.runtimeImages));
    }

    public void setRuntimeImages(Set<Artifact> runtimeImages) {
        this.freezeCheck();
        this.runtimeImages.clear();
        this.runtimeImages.addAll(runtimeImages);
    }

    public void addRuntimeImage(Artifact jdk) {
        this.freezeCheck();
        if (null != jdk) {
            this.runtimeImages.add(jdk);
        }
    }

    public Optional<Artifact> findRuntimeImageByPlatform(String platform) {
        return this.runtimeImages.stream().filter(ri -> ri.getPlatform().equals(platform)).findFirst();
    }

    public ApplicationPackage getApplicationPackage() {
        return this.applicationPackage;
    }

    public void setApplicationPackage(ApplicationPackage applicationPackage) {
        this.applicationPackage.merge(applicationPackage);
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public void setLauncher(Launcher launcher) {
        this.launcher.merge(launcher);
    }

    public Linux getLinux() {
        return this.linux;
    }

    public void setLinux(Linux linux) {
        this.linux.merge(linux);
    }

    public Windows getWindows() {
        return this.windows;
    }

    public void setWindows(Windows windows) {
        this.windows.merge(windows);
    }

    public Osx getOsx() {
        return this.osx;
    }

    public void setOsx(Osx osx) {
        this.osx.merge(osx);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("jlink", this.jlink);
        props.put("attachPlatform", this.isAttachPlatform());
        LinkedHashMap<String, Map<String, Object>> mapped = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact runtimeImage : this.getRuntimeImages()) {
            mapped.put("runtimeImage " + i++, runtimeImage.asMap(full));
        }
        props.put("runtimeImages", mapped);
        if (this.launcher.isSet()) {
            props.put("launcher", this.launcher.asMap(full));
        }
        props.put("applicationPackage", this.applicationPackage.asMap(full));
        props.putAll(this.linux.asMap(full));
        props.putAll(this.osx.asMap(full));
        props.putAll(this.windows.asMap(full));
    }

    public PlatformPackager getResolvedPlatformPackager() {
        String currentPlatform = PlatformUtils.getCurrentFull();
        if (PlatformUtils.isMac((String)currentPlatform)) {
            return this.getOsx();
        }
        if (PlatformUtils.isWindows((String)currentPlatform)) {
            return this.getWindows();
        }
        return this.getLinux();
    }

    public Set<PlatformPackager> getPlatformPackagers() {
        return Collections.unmodifiableSet(CollectionUtils.newSet((Object[])new AbstractPlatformPackager[]{this.osx, this.linux, this.windows}));
    }

    public static class Osx
    extends AbstractPlatformPackager<Osx> {
        private String packageIdentifier;
        private String packageName;
        private String packageSigningPrefix;
        private String signingKeychain;
        private String signingKeyUsername;
        private Boolean sign;

        public Osx() {
            super("osx", Arrays.asList("dmg", "pkg"));
        }

        @Override
        public void merge(Osx packager) {
            this.freezeCheck();
            super.merge(packager);
            this.packageIdentifier = this.merge(this.packageIdentifier, packager.packageIdentifier);
            this.packageName = this.merge(this.packageName, packager.packageName);
            this.packageSigningPrefix = this.merge(this.packageSigningPrefix, packager.packageSigningPrefix);
            this.signingKeychain = this.merge(this.signingKeychain, packager.signingKeychain);
            this.signingKeyUsername = this.merge(this.signingKeyUsername, packager.signingKeyUsername);
            this.sign = this.merge(this.sign, packager.sign);
        }

        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        public void setPackageIdentifier(String packageIdentifier) {
            this.freezeCheck();
            this.packageIdentifier = packageIdentifier;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.freezeCheck();
            this.packageName = packageName;
        }

        public String getPackageSigningPrefix() {
            return this.packageSigningPrefix;
        }

        public void setPackageSigningPrefix(String packageSigningPrefix) {
            this.freezeCheck();
            this.packageSigningPrefix = packageSigningPrefix;
        }

        public String getSigningKeychain() {
            return this.signingKeychain;
        }

        public void setSigningKeychain(String signingKeychain) {
            this.freezeCheck();
            this.signingKeychain = signingKeychain;
        }

        public String getSigningKeyUsername() {
            return this.signingKeyUsername;
        }

        public void setSigningKeyUsername(String signingKeyUsername) {
            this.freezeCheck();
            this.signingKeyUsername = signingKeyUsername;
        }

        public boolean isSign() {
            return this.sign != null && this.sign != false;
        }

        public void setSign(Boolean sign) {
            this.freezeCheck();
            this.sign = sign;
        }

        @Override
        protected void asMap(boolean full, Map<String, Object> props) {
            props.put("packageIdentifier", this.packageIdentifier);
            props.put("packageName", this.packageName);
            props.put("packageSigningPrefix", this.packageSigningPrefix);
            props.put("signingKeychain", this.signingKeychain);
            props.put("signingKeyUsername", this.signingKeyUsername);
            props.put("sign", this.sign);
        }
    }

    public static class Windows
    extends AbstractPlatformPackager<Windows> {
        private Boolean console;
        private Boolean dirChooser;
        private Boolean menu;
        private Boolean perUserInstall;
        private Boolean shortcut;
        private String menuGroup;
        private String upgradeUuid;

        public Windows() {
            super("windows", Arrays.asList("msi", "exe"));
        }

        @Override
        public void merge(Windows packager) {
            this.freezeCheck();
            super.merge(packager);
            this.console = this.merge(this.console, packager.console);
            this.dirChooser = this.merge(this.dirChooser, packager.dirChooser);
            this.menu = this.merge(this.menu, packager.menu);
            this.perUserInstall = this.merge(this.perUserInstall, packager.perUserInstall);
            this.shortcut = this.merge(this.shortcut, packager.shortcut);
            this.menuGroup = this.merge(this.menuGroup, packager.menuGroup);
            this.upgradeUuid = this.merge(this.upgradeUuid, packager.upgradeUuid);
        }

        public boolean isConsole() {
            return this.console != null && this.console != false;
        }

        public void setConsole(Boolean console) {
            this.freezeCheck();
            this.console = console;
        }

        public boolean isDirChooser() {
            return this.dirChooser != null && this.dirChooser != false;
        }

        public void setDirChooser(Boolean dirChooser) {
            this.freezeCheck();
            this.dirChooser = dirChooser;
        }

        public boolean isMenu() {
            return this.menu != null && this.menu != false;
        }

        public void setMenu(Boolean menu) {
            this.freezeCheck();
            this.menu = menu;
        }

        public boolean isPerUserInstall() {
            return this.perUserInstall != null && this.perUserInstall != false;
        }

        public void setPerUserInstall(Boolean perUserInstall) {
            this.freezeCheck();
            this.perUserInstall = perUserInstall;
        }

        public boolean isShortcut() {
            return this.shortcut != null && this.shortcut != false;
        }

        public void setShortcut(Boolean shortcut) {
            this.freezeCheck();
            this.shortcut = shortcut;
        }

        public String getMenuGroup() {
            return this.menuGroup;
        }

        public void setMenuGroup(String menuGroup) {
            this.freezeCheck();
            this.menuGroup = menuGroup;
        }

        public String getUpgradeUuid() {
            return this.upgradeUuid;
        }

        public void setUpgradeUuid(String upgradeUuid) {
            this.freezeCheck();
            this.upgradeUuid = upgradeUuid;
        }

        @Override
        protected void asMap(boolean full, Map<String, Object> props) {
            props.put("console", this.console);
            props.put("dirChooser", this.dirChooser);
            props.put("menu", this.menu);
            props.put("perUserInstall", this.perUserInstall);
            props.put("shortcut", this.shortcut);
            props.put("menuGroup", this.menuGroup);
            props.put("upgradeUuid", this.upgradeUuid);
        }
    }

    public static class Linux
    extends AbstractPlatformPackager<Linux> {
        private final List<String> packageDeps = new ArrayList<String>();
        private String packageName;
        private String maintainer;
        private String menuGroup;
        private String license;
        private String appRelease;
        private String appCategory;
        private Boolean shortcut;

        public Linux() {
            super("linux", Arrays.asList("deb", "rpm"));
        }

        @Override
        public void merge(Linux packager) {
            this.freezeCheck();
            super.merge(packager);
            this.packageName = this.merge(this.packageName, packager.packageName);
            this.maintainer = this.merge(this.maintainer, packager.maintainer);
            this.menuGroup = this.merge(this.menuGroup, packager.menuGroup);
            this.license = this.merge(this.license, packager.license);
            this.appRelease = this.merge(this.appRelease, packager.appRelease);
            this.appCategory = this.merge(this.appCategory, packager.appCategory);
            this.shortcut = this.merge(this.shortcut, packager.shortcut);
            this.setPackageDeps(this.merge(this.packageDeps, packager.packageDeps));
        }

        public List<String> getPackageDeps() {
            return this.freezeWrap(this.packageDeps);
        }

        public void setPackageDeps(List<String> packageDeps) {
            this.freezeCheck();
            this.packageDeps.clear();
            this.packageDeps.addAll(packageDeps);
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.freezeCheck();
            this.packageName = packageName;
        }

        public String getMaintainer() {
            return this.maintainer;
        }

        public void setMaintainer(String maintainer) {
            this.freezeCheck();
            this.maintainer = maintainer;
        }

        public String getMenuGroup() {
            return this.menuGroup;
        }

        public void setMenuGroup(String menuGroup) {
            this.freezeCheck();
            this.menuGroup = menuGroup;
        }

        public String getLicense() {
            return this.license;
        }

        public void setLicense(String license) {
            this.freezeCheck();
            this.license = license;
        }

        public String getAppRelease() {
            return this.appRelease;
        }

        public void setAppRelease(String appRelease) {
            this.freezeCheck();
            this.appRelease = appRelease;
        }

        public String getAppCategory() {
            return this.appCategory;
        }

        public void setAppCategory(String appCategory) {
            this.freezeCheck();
            this.appCategory = appCategory;
        }

        public boolean isShortcut() {
            return this.shortcut != null && this.shortcut != false;
        }

        public void setShortcut(Boolean shortcut) {
            this.freezeCheck();
            this.shortcut = shortcut;
        }

        @Override
        protected void asMap(boolean full, Map<String, Object> props) {
            props.put("packageName", this.packageName);
            props.put("maintainer", this.maintainer);
            props.put("menuGroup", this.menuGroup);
            props.put("license", this.license);
            props.put("appRelease", this.appRelease);
            props.put("appCategory", this.appCategory);
            props.put("shortcut", this.shortcut);
            props.put("packageDeps", this.packageDeps);
        }
    }

    private static abstract class AbstractPlatformPackager<S extends AbstractPlatformPackager<S>>
    extends AbstractModelObject<S>
    implements PlatformPackager {
        protected final Artifact jdk = new Artifact();
        protected final List<String> types = new ArrayList<String>();
        protected final List<String> validTypes = new ArrayList<String>();
        protected final String platform;
        @JsonIgnore
        protected boolean enabled;
        protected String appName;
        protected String icon;
        protected String installDir;
        protected String resourceDir;

        protected AbstractPlatformPackager(String platform, List<String> validTypes) {
            this.platform = platform;
            this.validTypes.addAll(validTypes);
        }

        @Override
        public void freeze() {
            super.freeze();
            this.jdk.freeze();
        }

        @Override
        public void merge(S packager) {
            this.freezeCheck();
            this.icon = this.merge(this.icon, ((AbstractPlatformPackager)packager).icon);
            this.appName = this.merge(this.appName, ((AbstractPlatformPackager)packager).appName);
            this.enabled = this.merge(this.enabled, ((AbstractPlatformPackager)packager).enabled);
            this.installDir = this.merge(this.installDir, ((AbstractPlatformPackager)packager).installDir);
            this.resourceDir = this.merge(this.resourceDir, ((AbstractPlatformPackager)packager).resourceDir);
            this.setJdk(((AbstractPlatformPackager)packager).jdk);
            this.setTypes(this.merge(this.types, ((AbstractPlatformPackager)packager).types));
        }

        @Override
        public String getResolvedAppName(JReleaserContext context, Jpackage jpackage) {
            Map<String, Object> props = context.getModel().props();
            props.putAll(jpackage.props());
            return Templates.resolveTemplate((String)this.appName, props);
        }

        @Override
        public String getAppName() {
            return this.appName;
        }

        @Override
        public void setAppName(String appName) {
            this.freezeCheck();
            this.appName = appName;
        }

        @Override
        public String getIcon() {
            return this.icon;
        }

        @Override
        public void setIcon(String icon) {
            this.freezeCheck();
            this.icon = icon;
        }

        @Override
        public List<String> getValidTypes() {
            return this.freezeWrap(this.validTypes);
        }

        @Override
        public String getPlatform() {
            return this.platform;
        }

        @Override
        public String getResourceDir() {
            return this.resourceDir;
        }

        @Override
        public void setResourceDir(String resourceDir) {
            this.freezeCheck();
            this.resourceDir = resourceDir;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void enable() {
            this.enabled = true;
        }

        @Override
        public void disable() {
            this.enabled = false;
        }

        @Override
        public Artifact getJdk() {
            return this.jdk;
        }

        @Override
        public void setJdk(Artifact jdk) {
            this.jdk.merge(jdk);
        }

        @Override
        public List<String> getTypes() {
            return this.freezeWrap(this.types);
        }

        @Override
        public void setTypes(List<String> types) {
            this.freezeCheck();
            this.types.clear();
            this.types.addAll(types);
        }

        @Override
        public String getInstallDir() {
            return this.installDir;
        }

        @Override
        public void setInstallDir(String installDir) {
            this.freezeCheck();
            this.installDir = installDir;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("appName", this.appName);
            props.put("icon", this.icon);
            props.put("resourceDir", this.resourceDir);
            props.put("types", this.types);
            props.put("jdk", this.jdk.asMap(full));
            props.put("installDir", this.installDir);
            this.asMap(full, props);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.platform, props);
            return map;
        }

        protected abstract void asMap(boolean var1, Map<String, Object> var2);
    }

    public static class Launcher
    extends AbstractModelObject<Launcher>
    implements Domain {
        private final List<String> arguments = new ArrayList<String>();
        private final List<String> javaOptions = new ArrayList<String>();
        private final List<String> launchers = new ArrayList<String>();

        @Override
        public void merge(Launcher launcher) {
            this.freezeCheck();
            this.setArguments(this.merge(this.arguments, launcher.arguments));
            this.setJavaOptions(this.merge(this.javaOptions, launcher.javaOptions));
            this.setLaunchers(this.merge(this.launchers, launcher.launchers));
        }

        public boolean isSet() {
            return !this.arguments.isEmpty() || !this.javaOptions.isEmpty() || !this.launchers.isEmpty();
        }

        public List<String> getLaunchers() {
            return this.freezeWrap(this.launchers);
        }

        public void setLaunchers(List<String> launchers) {
            this.freezeCheck();
            this.launchers.clear();
            this.launchers.addAll(launchers);
        }

        public void addLaunchers(List<String> launchers) {
            this.freezeCheck();
            this.launchers.addAll(launchers);
        }

        public List<String> getArguments() {
            return this.freezeWrap(this.arguments);
        }

        public void setArguments(List<String> arguments) {
            this.freezeCheck();
            this.arguments.clear();
            this.arguments.addAll(arguments);
        }

        public void addArguments(List<String> arguments) {
            this.freezeCheck();
            this.arguments.addAll(arguments);
        }

        public List<String> getJavaOptions() {
            return this.freezeWrap(this.javaOptions);
        }

        public void setJavaOptions(List<String> javaOptions) {
            this.freezeCheck();
            this.javaOptions.clear();
            this.javaOptions.addAll(javaOptions);
        }

        public void addJavaOptions(List<String> javaOptions) {
            this.freezeCheck();
            this.javaOptions.addAll(javaOptions);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("arguments", this.arguments);
            props.put("javaOptions", this.javaOptions);
            props.put("launchers", this.launchers);
            return props;
        }
    }

    public static class ApplicationPackage
    extends AbstractModelObject<ApplicationPackage>
    implements Domain {
        private final List<String> fileAssociations = new ArrayList<String>();
        private String appName;
        private String appVersion;
        private String vendor;
        private String copyright;
        private String licenseFile;

        @Override
        public void merge(ApplicationPackage applicationPackage) {
            this.freezeCheck();
            this.appName = this.merge(this.appName, applicationPackage.appName);
            this.appVersion = this.merge(this.appVersion, applicationPackage.appVersion);
            this.vendor = this.merge(this.vendor, applicationPackage.vendor);
            this.copyright = this.merge(this.copyright, applicationPackage.copyright);
            this.licenseFile = this.merge(this.licenseFile, applicationPackage.licenseFile);
            this.setFileAssociations(this.merge(this.fileAssociations, applicationPackage.fileAssociations));
        }

        public String getResolvedAppVersion(JReleaserContext context, Jpackage jpackage) {
            Map<String, Object> props = context.getModel().props();
            props.putAll(jpackage.props());
            return Templates.resolveTemplate((String)this.appVersion, props);
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.freezeCheck();
            this.appName = appName;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public void setAppVersion(String appVersion) {
            this.freezeCheck();
            this.appVersion = appVersion;
        }

        public String getVendor() {
            return this.vendor;
        }

        public void setVendor(String vendor) {
            this.freezeCheck();
            this.vendor = vendor;
        }

        public String getCopyright() {
            return this.copyright;
        }

        public void setCopyright(String copyright) {
            this.freezeCheck();
            this.copyright = copyright;
        }

        public List<String> getFileAssociations() {
            return this.freezeWrap(this.fileAssociations);
        }

        public void setFileAssociations(List<String> fileAssociations) {
            this.freezeCheck();
            this.fileAssociations.clear();
            this.fileAssociations.addAll(fileAssociations);
        }

        public String getLicenseFile() {
            return this.licenseFile;
        }

        public void setLicenseFile(String licenseFile) {
            this.freezeCheck();
            this.licenseFile = licenseFile;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("appName", this.appName);
            props.put("appVersion", this.appVersion);
            props.put("copyright", this.copyright);
            props.put("vendor", this.vendor);
            props.put("licenseFile", this.licenseFile);
            props.put("fileAssociations", this.fileAssociations);
            return props;
        }
    }

    public static interface PlatformPackager
    extends Domain {
        public String getAppName();

        public void setAppName(String var1);

        public String getResolvedAppName(JReleaserContext var1, Jpackage var2);

        public String getIcon();

        public void setIcon(String var1);

        public List<String> getValidTypes();

        public String getPlatform();

        public boolean isEnabled();

        public void enable();

        public void disable();

        public Artifact getJdk();

        public void setJdk(Artifact var1);

        public List<String> getTypes();

        public void setTypes(List<String> var1);

        public String getInstallDir();

        public void setInstallDir(String var1);

        public String getResourceDir();

        public void setResourceDir(String var1);
    }
}

