/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

public enum JReleaserCommand {
    DOWNLOAD,
    ASSEMBLE,
    CHANGELOG,
    CHECKSUM,
    SIGN,
    UPLOAD,
    RELEASE,
    PREPARE,
    PACKAGE,
    PUBLISH,
    ANNOUNCE,
    FULL_RELEASE;


    public static boolean supportsAssemble(JReleaserCommand command) {
        return ASSEMBLE == command;
    }

    public static boolean supportsChangelog(JReleaserCommand command) {
        return CHANGELOG == command || RELEASE == command || ANNOUNCE == command || FULL_RELEASE == command;
    }

    public static boolean supportsChecksum(JReleaserCommand command) {
        return CHECKSUM == command || SIGN == command || UPLOAD == command || RELEASE == command || PREPARE == command || PACKAGE == command || PUBLISH == command || FULL_RELEASE == command;
    }

    public static boolean supportsSign(JReleaserCommand command) {
        return SIGN == command || UPLOAD == command || RELEASE == command || FULL_RELEASE == command;
    }

    public static boolean supportsUpload(JReleaserCommand command) {
        return UPLOAD == command || RELEASE == command || FULL_RELEASE == command;
    }

    public static boolean supportsRelease(JReleaserCommand command) {
        return RELEASE == command || FULL_RELEASE == command;
    }

    public static boolean supportsPrepare(JReleaserCommand command) {
        return PREPARE == command || PACKAGE == command || PUBLISH == command || FULL_RELEASE == command;
    }

    public static boolean supportsPackage(JReleaserCommand command) {
        return PACKAGE == command || PUBLISH == command || FULL_RELEASE == command;
    }

    public static boolean supportsPublish(JReleaserCommand command) {
        return PUBLISH == command || FULL_RELEASE == command;
    }

    public static boolean supportsAnnounce(JReleaserCommand command) {
        return ANNOUNCE == command || FULL_RELEASE == command;
    }
}

