/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.AbstractDownloader;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Active;
import org.jreleaser.model.Domain;
import org.jreleaser.model.Downloader;
import org.jreleaser.model.FtpDownloader;
import org.jreleaser.model.HttpDownloader;
import org.jreleaser.model.Project;
import org.jreleaser.model.ScpDownloader;
import org.jreleaser.model.SftpDownloader;
import org.jreleaser.util.Env;

public class Download
extends AbstractModelObject<Download>
implements Domain,
Activatable {
    private final Map<String, FtpDownloader> ftp = new LinkedHashMap<String, FtpDownloader>();
    private final Map<String, HttpDownloader> http = new LinkedHashMap<String, HttpDownloader>();
    private final Map<String, ScpDownloader> scp = new LinkedHashMap<String, ScpDownloader>();
    private final Map<String, SftpDownloader> sftp = new LinkedHashMap<String, SftpDownloader>();
    private Active active;
    @JsonIgnore
    private boolean enabled = true;

    @Override
    public void freeze() {
        super.freeze();
        this.ftp.values().forEach(AbstractDownloader::freeze);
        this.http.values().forEach(AbstractDownloader::freeze);
        this.scp.values().forEach(AbstractDownloader::freeze);
        this.sftp.values().forEach(AbstractDownloader::freeze);
    }

    @Override
    public void merge(Download download) {
        this.freezeCheck();
        this.active = this.merge(this.active, download.active);
        this.enabled = this.merge(this.enabled, download.enabled);
        this.setFtp(this.mergeModel(this.ftp, download.ftp));
        this.setHttp(this.mergeModel(this.http, download.http));
        this.setScp(this.mergeModel(this.scp, download.scp));
        this.setSftp(this.mergeModel(this.sftp, download.sftp));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.active != null;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"download.active", (String)"", (String)"ALWAYS"));
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.freezeCheck();
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of(str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public List<FtpDownloader> getActiveFtps() {
        return this.ftp.values().stream().filter(AbstractDownloader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, FtpDownloader> getFtp() {
        return this.freezeWrap(this.ftp);
    }

    public void setFtp(Map<String, FtpDownloader> ftp) {
        this.freezeCheck();
        this.ftp.clear();
        this.ftp.putAll(ftp);
    }

    public void addFtp(FtpDownloader ftp) {
        this.freezeCheck();
        this.ftp.put(ftp.getName(), ftp);
    }

    public List<HttpDownloader> getActiveHttps() {
        return this.http.values().stream().filter(AbstractDownloader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, HttpDownloader> getHttp() {
        return this.freezeWrap(this.http);
    }

    public void setHttp(Map<String, HttpDownloader> http) {
        this.freezeCheck();
        this.http.clear();
        this.http.putAll(http);
    }

    public void addHttp(HttpDownloader http) {
        this.freezeCheck();
        this.http.put(http.getName(), http);
    }

    public List<ScpDownloader> getActiveScps() {
        return this.scp.values().stream().filter(AbstractDownloader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, ScpDownloader> getScp() {
        return this.freezeWrap(this.scp);
    }

    public void setScp(Map<String, ScpDownloader> scp) {
        this.freezeCheck();
        this.scp.clear();
        this.scp.putAll(scp);
    }

    public void addScp(ScpDownloader scp) {
        this.freezeCheck();
        this.scp.put(scp.getName(), scp);
    }

    public List<SftpDownloader> getActiveSftps() {
        return this.sftp.values().stream().filter(AbstractDownloader::isEnabled).collect(Collectors.toList());
    }

    public Map<String, SftpDownloader> getSftp() {
        return this.freezeWrap(this.sftp);
    }

    public void setSftp(Map<String, SftpDownloader> sftp) {
        this.freezeCheck();
        this.sftp.clear();
        this.sftp.putAll(sftp);
    }

    public void addSftp(SftpDownloader sftp) {
        this.freezeCheck();
        this.sftp.put(sftp.getName(), sftp);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        List sftp;
        List scp;
        List http;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.enabled);
        map.put("active", (Object)this.active);
        List ftp = this.ftp.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!ftp.isEmpty()) {
            map.put("ftp", ftp);
        }
        if (!(http = this.http.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("http", http);
        }
        if (!(scp = this.scp.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("scp", scp);
        }
        if (!(sftp = this.sftp.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("sftp", sftp);
        }
        return map;
    }

    public <A extends Downloader> Map<String, A> findDownloadersByType(String downloaderType) {
        switch (downloaderType) {
            case "ftp": {
                return this.ftp;
            }
            case "http": {
                return this.http;
            }
            case "scp": {
                return this.scp;
            }
            case "sftp": {
                return this.sftp;
            }
        }
        return Collections.emptyMap();
    }

    public <A extends Downloader> List<A> findAllActiveDownloaders() {
        ArrayList<AbstractDownloader> downloaders = new ArrayList<AbstractDownloader>();
        downloaders.addAll(this.getActiveFtps());
        downloaders.addAll(this.getActiveHttps());
        downloaders.addAll(this.getActiveScps());
        downloaders.addAll(this.getActiveSftps());
        return downloaders;
    }

    public static Set<String> supportedDownloaders() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("ftp");
        set.add("http");
        set.add("scp");
        set.add("sftp");
        return Collections.unmodifiableSet(set);
    }
}

