/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.AbstractPackager;
import org.jreleaser.model.TemplatePackager;
import org.jreleaser.util.StringUtils;

public abstract class AbstractTemplatePackager<S extends AbstractTemplatePackager<S>>
extends AbstractPackager<S>
implements TemplatePackager {
    protected final List<String> skipTemplates = new ArrayList<String>();
    protected String templateDirectory;

    protected AbstractTemplatePackager(String type) {
        super(type);
    }

    @Override
    public void merge(S packager) {
        this.freezeCheck();
        super.merge(packager);
        this.templateDirectory = this.merge(this.templateDirectory, ((AbstractTemplatePackager)packager).templateDirectory);
        this.setSkipTemplates(this.merge(this.skipTemplates, ((AbstractTemplatePackager)packager).skipTemplates));
    }

    @Override
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public void setTemplateDirectory(String templateDirectory) {
        this.freezeCheck();
        this.templateDirectory = templateDirectory;
    }

    @Override
    public List<String> getSkipTemplates() {
        return this.freezeWrap(this.skipTemplates);
    }

    @Override
    public void setSkipTemplates(List<String> skipTemplates) {
        this.freezeCheck();
        this.skipTemplates.clear();
        this.skipTemplates.addAll(skipTemplates);
    }

    @Override
    public void addSkipTemplates(List<String> templates) {
        this.freezeCheck();
        this.skipTemplates.addAll(templates);
    }

    @Override
    public void addSkipTemplate(String template) {
        this.freezeCheck();
        if (StringUtils.isNotBlank((String)template)) {
            this.skipTemplates.add(template.trim());
        }
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("templateDirectory", this.templateDirectory);
        props.put("skipTemplates", this.skipTemplates);
    }
}

