/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Domain;
import org.jreleaser.model.EnabledAware;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.StringUtils;

public class Changelog
implements Domain,
EnabledAware {
    private final Set<String> includeLabels = new LinkedHashSet<String>();
    private final Set<String> excludeLabels = new LinkedHashSet<String>();
    private final Set<Category> categories = new TreeSet<Category>(Category.ORDER);
    private final List<Replacer> replacers = new ArrayList<Replacer>();
    private final Set<Labeler> labelers = new TreeSet<Labeler>(Labeler.ORDER);
    private final Hide hide = new Hide();
    private final Contributors contributors = new Contributors();
    private Boolean enabled;
    private Boolean links;
    private Sort sort = Sort.DESC;
    private String external;
    private Active formatted;
    private String format;
    private String content;
    private String contentTemplate;
    private String preset;

    void setAll(Changelog changelog) {
        this.enabled = changelog.enabled;
        this.links = changelog.links;
        this.sort = changelog.sort;
        this.external = changelog.external;
        this.formatted = changelog.formatted;
        this.format = changelog.format;
        this.content = changelog.content;
        this.contentTemplate = changelog.contentTemplate;
        this.preset = changelog.preset;
        this.setIncludeLabels(changelog.includeLabels);
        this.setExcludeLabels(changelog.excludeLabels);
        this.setCategories(changelog.categories);
        this.setReplacers(changelog.replacers);
        this.setLabelers(changelog.labelers);
        this.setHide(changelog.hide);
        this.setContributors(changelog.contributors);
    }

    public boolean resolveFormatted(Project project) {
        if (null == this.formatted) {
            this.formatted = Active.NEVER;
        }
        return this.formatted.check(project);
    }

    public Reader getResolvedContentTemplate(JReleaserContext context) {
        if (StringUtils.isNotBlank((String)this.content)) {
            return new StringReader(this.content);
        }
        Path templatePath = context.getBasedir().resolve(this.contentTemplate);
        try {
            return Files.newBufferedReader(templatePath);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabledSet() {
        return this.enabled != null;
    }

    public boolean isLinks() {
        return this.links != null && this.links != false;
    }

    public void setLinks(Boolean links) {
        this.links = links;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public void setSort(String sort) {
        if (StringUtils.isNotBlank((String)sort)) {
            this.setSort(Sort.valueOf(sort.toUpperCase()));
        }
    }

    public String getExternal() {
        return this.external;
    }

    public void setExternal(String external) {
        this.external = external;
    }

    public Active getFormatted() {
        return this.formatted;
    }

    public void setFormatted(Active formatted) {
        this.formatted = formatted;
    }

    public void setFormatted(String str) {
        this.formatted = Active.of(str);
    }

    public boolean isFormattedSet() {
        return this.formatted != null;
    }

    public Set<String> getIncludeLabels() {
        return this.includeLabels;
    }

    public void setIncludeLabels(Set<String> includeLabels) {
        this.includeLabels.clear();
        this.includeLabels.addAll(includeLabels.stream().map(String::trim).collect(Collectors.toSet()));
    }

    public Set<String> getExcludeLabels() {
        return this.excludeLabels;
    }

    public void setExcludeLabels(Set<String> excludeLabels) {
        this.excludeLabels.clear();
        this.excludeLabels.addAll(excludeLabels.stream().map(String::trim).collect(Collectors.toSet()));
    }

    public Set<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<Category> categories) {
        this.categories.clear();
        this.categories.addAll(categories);
    }

    public List<Replacer> getReplacers() {
        return this.replacers;
    }

    public void setReplacers(List<Replacer> replacers) {
        this.replacers.clear();
        this.replacers.addAll(replacers);
    }

    public Set<Labeler> getLabelers() {
        return this.labelers;
    }

    public void setLabelers(Set<Labeler> labelers) {
        this.labelers.clear();
        this.labelers.addAll(labelers);
    }

    @Deprecated
    public String getChange() {
        return this.format;
    }

    @Deprecated
    public void setChange(String change) {
        System.out.println("changelog.change has been deprecated since 0.6.0 and will be removed in the future. Use changelog.format instead");
        this.format = change;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentTemplate() {
        return this.contentTemplate;
    }

    public void setContentTemplate(String contentTemplate) {
        this.contentTemplate = contentTemplate;
    }

    public String getPreset() {
        return this.preset;
    }

    public void setPreset(String preset) {
        this.preset = preset;
    }

    public Hide getHide() {
        return this.hide;
    }

    public void setHide(Hide hide) {
        this.hide.setAll(hide);
    }

    public Contributors getContributors() {
        return this.contributors;
    }

    public void setContributors(Contributors contributors) {
        this.contributors.setAll(contributors);
    }

    @Deprecated
    public void setHideUncategorized(boolean hideUncategorized) {
        System.out.println("changelog.hideUncategorized has been deprecated since 0.6.0 and will be removed in the future. Use changelog.hide.uncategorized instead");
        this.hide.uncategorized = hideUncategorized;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("external", this.external);
        map.put("links", this.isLinks());
        map.put("sort", (Object)this.sort);
        map.put("formatted", (Object)this.formatted);
        map.put("preset", this.preset);
        map.put("format", this.format);
        map.put("content", this.content);
        map.put("contentTemplate", this.contentTemplate);
        map.put("includeLabels", this.includeLabels);
        map.put("excludeLabels", this.excludeLabels);
        map.put("hide", this.hide.asMap(full));
        map.put("contributors", this.contributors.asMap(full));
        LinkedHashMap<String, Map<String, Object>> m = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Category category : this.categories) {
            m.put("category " + i++, category.asMap(full));
        }
        map.put("categories", m);
        m = new LinkedHashMap();
        i = 0;
        for (Labeler labeler : this.labelers) {
            m.put("labeler " + i++, labeler.asMap(full));
        }
        map.put("labelers", m);
        m = new LinkedHashMap();
        i = 0;
        for (Replacer replacer : this.replacers) {
            m.put("replacer " + i++, replacer.asMap(full));
        }
        map.put("replacers", m);
        return map;
    }

    public static class Hide
    implements Domain {
        private final Set<String> categories = new LinkedHashSet<String>();
        private final Set<String> contributors = new LinkedHashSet<String>();
        private boolean uncategorized;

        void setAll(Hide hide) {
            this.uncategorized = hide.uncategorized;
            this.setCategories(hide.categories);
            this.setContributors(hide.contributors);
        }

        public boolean isUncategorized() {
            return this.uncategorized;
        }

        public void setUncategorized(boolean uncategorized) {
            this.uncategorized = uncategorized;
        }

        public Set<String> getCategories() {
            return this.categories;
        }

        public void setCategories(Set<String> categories) {
            this.categories.clear();
            this.categories.addAll(categories.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public void addCategories(Set<String> categories) {
            this.categories.addAll(categories.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public void addCategory(String category) {
            if (StringUtils.isNotBlank((String)category)) {
                this.categories.add(category.trim());
            }
        }

        public boolean containsCategory(String category) {
            if (StringUtils.isNotBlank((String)category)) {
                return this.categories.contains(category.trim());
            }
            return false;
        }

        public Set<String> getContributors() {
            return this.contributors;
        }

        public void setContributors(Set<String> contributors) {
            this.contributors.clear();
            this.contributors.addAll(contributors.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public void addContributors(Set<String> contributors) {
            this.contributors.addAll(contributors.stream().map(String::trim).collect(Collectors.toSet()));
        }

        public void addContributor(String contributor) {
            if (StringUtils.isNotBlank((String)contributor)) {
                this.contributors.add(contributor.trim());
            }
        }

        public boolean containsContributor(String name) {
            if (StringUtils.isNotBlank((String)name)) {
                String n = name.trim();
                for (String contributor : this.contributors) {
                    if (!n.contains(contributor) && !n.matches(StringUtils.toSafeRegexPattern((String)contributor))) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("uncategorized", this.uncategorized);
            map.put("categories", this.categories);
            map.put("contributors", this.contributors);
            return map;
        }
    }

    public static class Contributors
    implements Domain {
        private Boolean enabled;
        private String format;

        void setAll(Contributors contributor) {
            this.enabled = contributor.enabled;
            this.format = contributor.format;
        }

        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabledSet() {
            return this.enabled != null;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("enabled", this.enabled);
            map.put("format", this.format);
            return map;
        }
    }

    public static class Labeler
    implements Domain {
        public static Comparator<Labeler> ORDER = (o1, o2) -> {
            if (null == o1.getOrder()) {
                return 1;
            }
            if (null == o2.getOrder()) {
                return -1;
            }
            return o1.getOrder().compareTo(o2.getOrder());
        };
        private String label;
        private String title;
        private String body;
        private Integer order;

        void setAll(Labeler labeler) {
            this.label = labeler.label;
            this.title = labeler.title;
            this.body = labeler.body;
            this.order = labeler.order;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Labeler labeler = (Labeler)o;
            return Objects.equals(this.title, labeler.title) && Objects.equals(this.body, labeler.body);
        }

        public int hashCode() {
            return Objects.hash(this.title, this.body);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("label", this.label);
            map.put("title", this.title);
            map.put("body", this.body);
            map.put("order", this.order);
            return map;
        }
    }

    public static class Replacer
    implements Domain {
        private String search;
        private String replace = "";

        void setAll(Replacer replacer) {
            this.search = replacer.search;
            this.replace = replacer.replace;
        }

        public String getSearch() {
            return this.search;
        }

        public void setSearch(String search) {
            this.search = search;
        }

        public String getReplace() {
            return this.replace;
        }

        public void setReplace(String replace) {
            this.replace = replace;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("search", this.search);
            map.put("replace", this.replace);
            return map;
        }
    }

    public static class Category
    implements Domain {
        public static Comparator<Category> ORDER = (o1, o2) -> {
            if (null == o1.getOrder()) {
                return 1;
            }
            if (null == o2.getOrder()) {
                return -1;
            }
            return o1.getOrder().compareTo(o2.getOrder());
        };
        private final Set<String> labels = new LinkedHashSet<String>();
        private String key;
        private String title;
        private String format;
        private Integer order;

        public static Set<Category> sort(Set<Category> categories) {
            TreeSet<Category> tmp = new TreeSet<Category>(ORDER);
            tmp.addAll(categories);
            return tmp;
        }

        void setAll(Category category) {
            this.key = category.key;
            this.title = category.title;
            this.format = category.format;
            this.order = category.order;
            this.setLabels(category.labels);
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
            if (StringUtils.isBlank((String)this.key)) {
                this.key = title;
            }
        }

        public Set<String> getLabels() {
            return this.labels;
        }

        public void setLabels(Set<String> labels) {
            this.labels.clear();
            this.labels.addAll(labels);
        }

        public void addLabels(Set<String> labels) {
            this.labels.addAll(labels);
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("key", this.key);
            map.put("title", this.title);
            map.put("labels", this.labels);
            map.put("format", this.format);
            map.put("order", this.order);
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Category category = (Category)o;
            return this.key.equals(category.key);
        }

        public int hashCode() {
            return Objects.hash(this.title);
        }

        public static Category of(String key, String title, String format, String ... labels) {
            Category category = new Category();
            category.key = key;
            category.title = title;
            category.format = format;
            category.labels.addAll(Arrays.asList(labels));
            return category;
        }
    }

    public static enum Sort {
        ASC,
        DESC;

    }
}

