/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Chocolatey;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.Github;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.packager.spi.PackagerProcessingException;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;
import org.jreleaser.util.command.Command;

public class ChocolateyPackagerProcessor
extends AbstractRepositoryPackagerProcessor<Chocolatey> {
    public ChocolateyPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
        if (((Chocolatey)this.packager).isRemoteBuild()) {
            return;
        }
        if (!PlatformUtils.isWindows()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_packager_requires_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.createChocolateyPackage(distribution, props);
    }

    @Override
    protected void prepareWorkingCopy(Map<String, Object> props, Path directory, Distribution distribution) throws PackagerProcessingException, IOException {
        super.prepareWorkingCopy(props, directory.resolve(distribution.getName()), distribution);
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        super.doPublishDistribution(distribution, props);
        if (((Chocolatey)this.packager).isRemoteBuild()) {
            return;
        }
        if (!PlatformUtils.isWindows()) {
            this.context.getLogger().warn(RB.$((String)"ERROR_packager_requires_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.publishChocolateyPackage(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        GitService gitService = this.context.getModel().getRelease().getGitService();
        if (!props.containsKey("projectLicenseUrl") || StringUtils.isBlank((String)((String)props.get("projectLicenseUrl")))) {
            this.context.getLogger().warn(RB.$((String)"ERROR_project_no_license_url", (Object[])new Object[0]));
        }
        props.put("chocolateyBucketRepoUrl", gitService.getResolvedRepoUrl(this.context.getModel(), ((Chocolatey)this.packager).getBucket().getOwner(), ((Chocolatey)this.packager).getBucket().getResolvedName()));
        props.put("chocolateyBucketRepoCloneUrl", gitService.getResolvedRepoCloneUrl(this.context.getModel(), ((Chocolatey)this.packager).getBucket().getOwner(), ((Chocolatey)this.packager).getBucket().getResolvedName()));
        props.put("chocolateyPackageName", ((Chocolatey)this.getPackager()).getPackageName());
        props.put("chocolateyUsername", ((Chocolatey)this.getPackager()).getUsername());
        props.put("chocolateyTitle", ((Chocolatey)this.getPackager()).getTitle());
        props.put("chocolateyIconUrl", Templates.resolveTemplate((String)((Chocolatey)this.getPackager()).getIconUrl(), props));
        props.put("chocolateySource", ((Chocolatey)this.packager).getSource());
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        GitService gitService = this.context.getModel().getRelease().getGitService();
        if (!(!fileName.contains(".github") || ((Chocolatey)this.packager).isRemoteBuild() && gitService instanceof Github)) {
            return;
        }
        Path outputFile = "binary.nuspec".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve(((Chocolatey)this.packager).getPackageName().concat(".nuspec")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    private void createChocolateyPackage(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        Command cmd = new Command("choco").arg("pack").arg(((Chocolatey)this.packager).getPackageName().concat(".nuspec"));
        this.executeCommand(packageDirectory, cmd);
    }

    private void publishChocolateyPackage(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        Command cmd = new Command("choco").arg("apikey").arg("-k").arg(((Chocolatey)this.packager).getResolvedApiKey()).arg("-source").arg(((Chocolatey)this.packager).getSource());
        this.executeCommand(packageDirectory, cmd);
        cmd = new Command("choco").arg("push").arg("$(ls *.nupkg | % {$_.FullName})").arg("-s").arg(((Chocolatey)this.packager).getSource());
        this.executeCommand(packageDirectory, cmd);
    }
}

