/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Path;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.VersionPattern;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public abstract class ProjectValidator
extends Validator {
    public static void validateProject(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        boolean javaAssemblers;
        context.getLogger().debug("project");
        Project project = context.getModel().getProject();
        project.setName(ProjectValidator.checkProperty(context, "PROJECT_NAME", "project.name", project.getName(), errors));
        project.setVersion(ProjectValidator.checkProperty(context, "PROJECT_VERSION", "project.version", project.getVersion(), errors));
        project.setVersionPattern(ProjectValidator.checkProperty(context, "PROJECT_VERSION_PATTERN", "project.versionPattern", project.getVersionPattern(), VersionPattern.Type.SEMVER.toString()));
        project.getSnapshot().setPattern(ProjectValidator.checkProperty(context, "PROJECT_SNAPSHOT_PATTERN", "project.snapshot.pattern", project.getSnapshot().getPattern(), ".*-SNAPSHOT"));
        project.getSnapshot().setLabel(ProjectValidator.checkProperty(context, "PROJECT_SNAPSHOT_LABEL", "project.snapshot.label", project.getSnapshot().getLabel(), "early-access"));
        project.getSnapshot().setFullChangelog(ProjectValidator.checkProperty(context, "PROJECT_SNAPSHOT_FULL_CHANGELOG", "project.snapshot.fullChangelog", project.getSnapshot().getFullChangelog(), false));
        if (project.versionPattern().getType() == VersionPattern.Type.CALVER && StringUtils.isBlank((String)project.versionPattern().getFormat())) {
            errors.configuration(RB.$((String)"validation_version_format_missing", (Object[])new Object[]{"project.versionPattern", VersionPattern.Type.CALVER.toString()}));
        }
        boolean javaDistributions = context.getModel().getDistributions().values().stream().map(Distribution::getType).anyMatch(type -> type == Distribution.DistributionType.JAVA_BINARY || type == Distribution.DistributionType.SINGLE_JAR || type == Distribution.DistributionType.NATIVE_IMAGE || type == Distribution.DistributionType.NATIVE_PACKAGE);
        boolean bl = javaAssemblers = !context.getModel().getAssemble().getJlink().isEmpty() || !context.getModel().getAssemble().getJpackage().isEmpty() || !context.getModel().getAssemble().getNativeImage().isEmpty();
        if (mode.validateConfig() && javaDistributions || javaAssemblers) {
            ProjectValidator.validateJava(context, project, errors);
        }
    }

    public static void postValidateProject(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("project");
        Project project = context.getModel().getProject();
        if (StringUtils.isBlank((String)project.getCopyright())) {
            if (project.getExtraProperties().containsKey("inceptionYear") && !project.getAuthors().isEmpty()) {
                project.setCopyright(project.getExtraProperties().get("inceptionYear") + " " + String.join((CharSequence)",", project.getAuthors()));
            } else {
                context.nag("0.4.0", "project.copyright must not be blank");
                project.setCopyright("");
            }
        }
        if (StringUtils.isBlank((String)project.getLicenseUrl())) {
            FileUtils.findLicenseFile((Path)context.getBasedir()).ifPresent(path -> {
                GitService service = context.getModel().getRelease().getGitService();
                String srcUrl = service.getResolvedSrcUrl(context.getModel());
                if (!srcUrl.endsWith("/")) {
                    srcUrl = srcUrl + "/";
                }
                srcUrl = srcUrl + path.getFileName().toString();
                project.setLicenseUrl(srcUrl);
            });
        }
        if (!mode.validateConfig()) {
            return;
        }
        if (context.getModel().getActiveDistributions().isEmpty() && !context.getModel().getAnnounce().isEnabled()) {
            return;
        }
        if (StringUtils.isBlank((String)project.getDescription())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.description"}));
        }
        if (StringUtils.isBlank((String)project.getDocsUrl())) {
            project.setDocsUrl(project.getWebsite());
        }
        if (StringUtils.isBlank((String)project.getWebsite())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.website"}));
        }
        if (StringUtils.isBlank((String)project.getDocsUrl())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.docsUrl"}));
        }
        if (StringUtils.isBlank((String)project.getLicense())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.license"}));
        }
        if (StringUtils.isBlank((String)project.getLongDescription())) {
            project.setLongDescription(project.getDescription());
        }
        if (project.getAuthors().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.authors"}));
        }
    }

    private static void validateJava(JReleaserContext context, Project project, Errors errors) {
        context.getLogger().debug("project.java");
        if (!project.getJava().isSet()) {
            return;
        }
        project.getJava().setEnabled(true);
        if (StringUtils.isBlank((String)project.getJava().getArtifactId())) {
            project.getJava().setArtifactId(project.getName());
        }
        if (StringUtils.isBlank((String)project.getJava().getGroupId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.java.groupId"}));
        }
        if (StringUtils.isBlank((String)project.getJava().getArtifactId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.java.artifactId"}));
        }
        if (!project.getJava().isMultiProjectSet()) {
            project.getJava().setMultiProject(false);
        }
    }
}

