/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryPackager;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Snap
extends AbstractRepositoryPackager {
    public static final String TYPE = "snap";
    public static final String SKIP_SNAP = "skipSnap";
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final Set<String> localPlugs = new LinkedHashSet<String>();
    private final Set<String> localSlots = new LinkedHashSet<String>();
    private final List<Plug> plugs = new ArrayList<Plug>();
    private final List<Slot> slots = new ArrayList<Slot>();
    private final List<Architecture> architectures = new ArrayList<Architecture>();
    private final SnapTap snap = new SnapTap();
    private String packageName;
    private String base = "core20";
    private String grade = "stable";
    private String confinement = "strict";
    private String exportedLogin;
    private Boolean remoteBuild;

    public Snap() {
        super(TYPE);
    }

    void setAll(Snap snap) {
        super.setAll(snap);
        this.packageName = snap.packageName;
        this.base = snap.base;
        this.grade = snap.grade;
        this.confinement = snap.confinement;
        this.exportedLogin = snap.exportedLogin;
        this.remoteBuild = snap.remoteBuild;
        this.setLocalPlugs(snap.localPlugs);
        this.setLocalSlots(snap.localSlots);
        this.setPlugs(snap.plugs);
        this.setSlots(snap.slots);
        this.setArchitectures(snap.architectures);
        this.setSnap(snap.snap);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public String getConfinement() {
        return this.confinement;
    }

    public void setConfinement(String confinement) {
        this.confinement = confinement;
    }

    public Set<String> getLocalPlugs() {
        return this.localPlugs;
    }

    public void setLocalPlugs(Set<String> localPlugs) {
        this.localPlugs.clear();
        this.localPlugs.addAll(localPlugs);
    }

    public void addLocalPlugs(Set<String> localPlugs) {
        this.localPlugs.addAll(localPlugs);
    }

    public void addLocalPlug(String localPlug) {
        if (StringUtils.isNotBlank((String)localPlug)) {
            this.localPlugs.add(localPlug.trim());
        }
    }

    public void removeLocalPlug(String localPlug) {
        if (StringUtils.isNotBlank((String)localPlug)) {
            this.localPlugs.remove(localPlug.trim());
        }
    }

    public Set<String> getLocalSlots() {
        return this.localSlots;
    }

    public void setLocalSlots(Set<String> localSlots) {
        this.localSlots.clear();
        this.localSlots.addAll(localSlots);
    }

    public void addLocalSlots(Set<String> localSlots) {
        this.localSlots.addAll(localSlots);
    }

    public void addLocalSlot(String localSlot) {
        if (StringUtils.isNotBlank((String)localSlot)) {
            this.localSlots.add(localSlot.trim());
        }
    }

    public void removeLocalSlot(String localSlot) {
        if (StringUtils.isNotBlank((String)localSlot)) {
            this.localSlots.remove(localSlot.trim());
        }
    }

    public List<Plug> getPlugs() {
        return this.plugs;
    }

    public void setPlugs(List<Plug> plugs) {
        this.plugs.clear();
        this.plugs.addAll(plugs);
    }

    public void addPlugs(List<Plug> plugs) {
        this.plugs.addAll(plugs);
    }

    public void addPlug(Plug plug) {
        if (null != plug) {
            this.plugs.add(plug);
        }
    }

    public void removePlug(Plug plug) {
        if (null != plug) {
            this.plugs.remove(plug);
        }
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public void setSlots(List<Slot> slots) {
        this.slots.clear();
        this.slots.addAll(slots);
    }

    public void addSlots(List<Slot> slots) {
        this.slots.addAll(slots);
    }

    public void addSlot(Slot slot) {
        if (null != slot) {
            this.slots.add(slot);
        }
    }

    public void removeSlot(Slot slot) {
        if (null != slot) {
            this.slots.remove(slot);
        }
    }

    public List<Architecture> getArchitectures() {
        return this.architectures;
    }

    public void setArchitectures(List<Architecture> architectures) {
        this.architectures.clear();
        this.architectures.addAll(architectures);
    }

    public void addArchitecture(List<Architecture> architectures) {
        this.architectures.addAll(architectures);
    }

    public void addArchitecture(Architecture architecture) {
        if (null != architecture) {
            this.architectures.add(architecture);
        }
    }

    public void removeArchitecture(Architecture architecture) {
        if (null != architecture) {
            this.architectures.remove(architecture);
        }
    }

    public String getExportedLogin() {
        return this.exportedLogin;
    }

    public void setExportedLogin(String exportedLogin) {
        this.exportedLogin = exportedLogin;
    }

    public boolean isRemoteBuild() {
        return this.remoteBuild != null && this.remoteBuild != false;
    }

    public void setRemoteBuild(Boolean remoteBuild) {
        this.remoteBuild = remoteBuild;
    }

    public boolean isRemoteBuildSet() {
        return this.remoteBuild != null;
    }

    public SnapTap getSnap() {
        return this.snap;
    }

    public void setSnap(SnapTap snap) {
        this.snap.setAll(snap);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        int i;
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("base", this.base);
        props.put("grade", this.grade);
        props.put("confinement", this.confinement);
        props.put("exportedLogin", this.exportedLogin);
        props.put("remoteBuild", this.isRemoteBuild());
        props.put(TYPE, this.snap.asMap(full));
        props.put("localPlugs", this.localPlugs);
        props.put("localSlots", this.localSlots);
        LinkedHashMap<String, Map<String, Object>> mapped = new LinkedHashMap<String, Map<String, Object>>();
        for (i = 0; i < this.plugs.size(); ++i) {
            mapped.put("plug " + i, this.plugs.get(i).asMap(full));
        }
        props.put("plugs", mapped);
        mapped = new LinkedHashMap();
        for (i = 0; i < this.slots.size(); ++i) {
            mapped.put("slot " + i, this.slots.get(i).asMap(full));
        }
        props.put("slots", mapped);
        mapped = new LinkedHashMap();
        for (i = 0; i < this.architectures.size(); ++i) {
            mapped.put("architecture " + i, this.architectures.get(i).asMap(full));
        }
        props.put("architectures", mapped);
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.snap;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isUnix((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return SUPPORTED.containsKey((Object)distribution.getType());
    }

    @Override
    public Set<String> getSupportedExtensions(Distribution distribution) {
        return SUPPORTED.getOrDefault((Object)distribution.getType(), Collections.emptySet());
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get(SKIP_SNAP));
    }

    static {
        Set extensions = CollectionUtils.newSet((Object[])new String[]{FileType.TAR_BZ2.extension(), FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TBZ2.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.newSet((Object[])new String[]{FileType.DEB.extension(), FileType.RPM.extension()}));
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, CollectionUtils.newSet((Object[])new String[]{FileType.JAR.extension()}));
    }

    public static class Architecture
    implements Domain {
        private final List<String> buildOn = new ArrayList<String>();
        private final List<String> runOn = new ArrayList<String>();
        private Boolean ignoreError;

        public List<String> getBuildOn() {
            return this.buildOn;
        }

        public void setBuildOn(List<String> buildOn) {
            this.buildOn.clear();
            this.buildOn.addAll(buildOn);
        }

        public void addBuildOn(List<String> buildOn) {
            this.buildOn.addAll(buildOn);
        }

        public void addBuildOn(String str) {
            if (StringUtils.isNotBlank((String)str)) {
                this.buildOn.add(str.trim());
            }
        }

        public List<String> getRunOn() {
            return this.runOn;
        }

        public void setRunOn(List<String> runOn) {
            this.runOn.clear();
            this.runOn.addAll(runOn);
        }

        public void addRunOn(List<String> runOn) {
            this.runOn.addAll(runOn);
        }

        public void addRunOn(String str) {
            if (StringUtils.isNotBlank((String)str)) {
                this.runOn.add(str.trim());
            }
        }

        public boolean hasBuildOn() {
            return !this.buildOn.isEmpty();
        }

        public boolean hasRunOn() {
            return !this.runOn.isEmpty();
        }

        public boolean isIgnoreError() {
            return this.ignoreError != null && this.ignoreError != false;
        }

        public void setIgnoreError(Boolean ignoreError) {
            this.ignoreError = ignoreError;
        }

        public boolean isIgnoreErrorSet() {
            return this.ignoreError != null;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("buildOn", this.buildOn);
            map.put("runOn", this.runOn);
            map.put("ignoreError", this.isIgnoreError());
            return map;
        }
    }

    public static class SnapTap
    extends AbstractRepositoryTap {
        public SnapTap() {
            super(Snap.TYPE, Snap.TYPE);
        }
    }

    public static class Plug
    implements Domain {
        private final Map<String, String> attributes = new LinkedHashMap<String, String>();
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes.clear();
            this.attributes.putAll(attributes);
        }

        public void addAttributes(Map<String, String> attributes) {
            this.attributes.putAll(attributes);
        }

        public void addAttribute(String key, String value) {
            this.attributes.put(key, value);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.name, this.attributes);
            return map;
        }

        public static Plug copyOf(Plug other) {
            Plug copy = new Plug();
            copy.setName(other.getName());
            copy.setAttributes(other.getAttributes());
            return copy;
        }
    }

    public static class Slot
    implements Domain {
        private final Map<String, String> attributes = new LinkedHashMap<String, String>();
        private final List<String> reads = new ArrayList<String>();
        private final List<String> writes = new ArrayList<String>();
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes.clear();
            this.attributes.putAll(attributes);
        }

        public void addAttributes(Map<String, String> attributes) {
            this.attributes.putAll(attributes);
        }

        public void addAttribute(String key, String value) {
            this.attributes.put(key, value);
        }

        public List<String> getReads() {
            return this.reads;
        }

        public void setReads(List<String> reads) {
            this.reads.clear();
            this.reads.addAll(reads);
        }

        public void addReads(List<String> read) {
            this.reads.addAll(read);
        }

        public void addRead(String read) {
            if (StringUtils.isNotBlank((String)read)) {
                this.reads.add(read.trim());
            }
        }

        public void removeRead(String read) {
            if (StringUtils.isNotBlank((String)read)) {
                this.reads.remove(read.trim());
            }
        }

        public List<String> getWrites() {
            return this.writes;
        }

        public void setWrites(List<String> writes) {
            this.writes.clear();
            this.writes.addAll(writes);
        }

        public void addWrites(List<String> write) {
            this.writes.addAll(write);
        }

        public void addWrite(String write) {
            if (StringUtils.isNotBlank((String)write)) {
                this.writes.add(write.trim());
            }
        }

        public void removeWrite(String write) {
            if (StringUtils.isNotBlank((String)write)) {
                this.writes.remove(write.trim());
            }
        }

        public boolean getHasReads() {
            return !this.reads.isEmpty();
        }

        public boolean getHasWrites() {
            return !this.writes.isEmpty();
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.name, this.attributes);
            map.put("read", this.reads);
            map.put("write", this.writes);
            return map;
        }

        public static Slot copyOf(Slot other) {
            Slot copy = new Slot();
            copy.setName(other.getName());
            copy.setAttributes(other.getAttributes());
            copy.setReads(other.getReads());
            copy.setWrites(other.getWrites());
            return copy;
        }
    }
}

