/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.FileSet;
import org.jreleaser.model.Project;
import org.jreleaser.util.MustacheUtils;

abstract class AbstractAssembler
implements Assembler {
    protected final Set<Artifact> outputs = new LinkedHashSet<Artifact>();
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    protected final List<FileSet> fileSets = new ArrayList<FileSet>();
    private final String type;
    protected String name;
    protected boolean enabled;
    protected Active active;
    protected Boolean exported;

    protected AbstractAssembler(String type) {
        this.type = type;
    }

    void setAll(AbstractAssembler assembler) {
        this.active = assembler.active;
        this.enabled = assembler.enabled;
        this.exported = assembler.exported;
        this.name = assembler.name;
        this.setOutputs(assembler.outputs);
        this.setExtraProperties(assembler.extraProperties);
        this.setFileSets(assembler.fileSets);
    }

    @Override
    public Map<String, Object> props() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("distributionName", this.name);
        return props;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public boolean isExported() {
        return this.exported == null || this.exported != false;
    }

    @Override
    public void setExported(boolean exported) {
        this.exported = exported;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.active = Active.of(str);
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public Set<Artifact> getOutputs() {
        return Artifact.sortArtifacts(this.outputs);
    }

    @Override
    public void setOutputs(Set<Artifact> output) {
        this.outputs.clear();
        this.outputs.addAll(output);
    }

    @Override
    public void addOutput(Artifact artifact) {
        if (null != artifact) {
            this.outputs.add(artifact);
        }
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public String getPrefix() {
        return this.getType();
    }

    @Override
    public List<FileSet> getFileSets() {
        return this.fileSets;
    }

    @Override
    public void setFileSets(List<FileSet> fileSets) {
        this.fileSets.clear();
        this.fileSets.addAll(fileSets);
    }

    @Override
    public void addFileSets(List<FileSet> files) {
        this.fileSets.addAll(files);
    }

    @Override
    public void addFileSet(FileSet file) {
        if (null != file) {
            this.fileSets.add(file);
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("exported", this.isExported());
        props.put("active", (Object)this.active);
        this.asMap(full, props);
        LinkedHashMap<String, Map<String, Object>> mappedFileSets = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.fileSets.size(); ++i) {
            mappedFileSets.put("fileSet " + i, this.fileSets.get(i).asMap(full));
        }
        props.put("fileSets", mappedFileSets);
        props.put("extraProperties", this.getResolvedExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

