/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Uploader;
import org.jreleaser.model.uploader.spi.ArtifactUploader;
import org.jreleaser.model.util.Artifacts;

public abstract class AbstractArtifactUploader<U extends Uploader>
implements ArtifactUploader<U> {
    protected final JReleaserContext context;

    protected AbstractArtifactUploader(JReleaserContext context) {
        this.context = context;
    }

    protected List<Artifact> collectArtifacts() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        List keys = this.getUploader().resolveSkipKeys();
        if (this.getUploader().isFiles().booleanValue()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)this.context)) {
                Path path;
                if (!artifact.isActive() || this.isSkip((ExtraProperties)artifact, keys) || !Files.exists(path = artifact.getEffectivePath(this.context), new LinkOption[0]) || 0L == path.toFile().length()) continue;
                artifacts.add(artifact);
            }
        }
        if (this.getUploader().isArtifacts().booleanValue()) {
            for (Distribution distribution : this.context.getModel().getActiveDistributions()) {
                if (!this.context.isDistributionIncluded(distribution) || this.isSkip((ExtraProperties)distribution, keys)) continue;
                for (Artifact artifact : distribution.getArtifacts()) {
                    Path path;
                    if (!artifact.isActive() || this.isSkip((ExtraProperties)artifact, keys) || !Files.exists(path = artifact.getEffectivePath(this.context), new LinkOption[0]) || 0L == path.toFile().length()) continue;
                    artifacts.add(artifact);
                }
            }
        }
        if (this.getUploader().isSignatures().booleanValue() && this.context.getModel().getSigning().isEnabled()) {
            String extension = this.context.getModel().getSigning().isArmored() != false ? ".asc" : ".sig";
            ArrayList<Artifact> signatures = new ArrayList<Artifact>();
            for (Artifact artifact : artifacts) {
                Path signaturePath;
                if (artifact.extraPropertyIsTrue("skipSigning") || !Files.exists(signaturePath = this.context.getSignaturesDirectory().resolve(artifact.getEffectivePath(this.context).getFileName() + extension), new LinkOption[0]) || 0L == signaturePath.toFile().length()) continue;
                signatures.add(Artifact.of((Path)signaturePath));
            }
            artifacts.addAll(signatures);
        }
        return artifacts;
    }

    private boolean isSkip(ExtraProperties props, List<String> keys) {
        for (String key : keys) {
            if (!props.extraPropertyIsTrue(key)) continue;
            return true;
        }
        return false;
    }
}

