/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.announce;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.model.announcer.spi.AnnouncerBuilder;
import org.jreleaser.model.announcer.spi.AnnouncerBuilderFactory;

public class Announcers {
    public static void announce(JReleaserContext context) throws AnnounceException {
        context.getLogger().info(RB.$((String)"announcers.header", (Object[])new Object[0]));
        if (!context.getModel().getAnnounce().isEnabled()) {
            context.getLogger().info(RB.$((String)"announcers.not.enabled", (Object[])new Object[0]));
            return;
        }
        Map<String, Announcer> announcers = Announcers.findAnnouncers(context);
        if (announcers.isEmpty()) {
            context.getLogger().info(RB.$((String)"announcers.not.configured", (Object[])new Object[0]));
            return;
        }
        if (context.hasAnnouncerName()) {
            Announcer announcer = announcers.get(context.getAnnouncerName());
            if (null == announcer) {
                context.getLogger().warn(RB.$((String)"announcers.announcer.not.found", (Object[])new Object[0]), new Object[]{context.getAnnouncerName()});
                return;
            }
            Announcers.announce(context, announcer);
            return;
        }
        for (Map.Entry<String, Announcer> entry : announcers.entrySet()) {
            Announcers.announce(context, entry.getValue());
        }
    }

    private static void announce(JReleaserContext context, Announcer announcer) {
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix(announcer.getName());
        if (announcer.isEnabled()) {
            try {
                announcer.announce();
            }
            catch (AnnounceException e) {
                context.getLogger().warn(e.getMessage().trim());
            }
        } else {
            context.getLogger().debug(RB.$((String)"announcers.announcer.disabled", (Object[])new Object[0]));
        }
        context.getLogger().restorePrefix();
        context.getLogger().decreaseIndent();
    }

    private static Map<String, Announcer> findAnnouncers(JReleaserContext context) {
        JReleaserModel model = context.getModel();
        Map<String, AnnouncerBuilder> builders = StreamSupport.stream(ServiceLoader.load(AnnouncerBuilderFactory.class, Announcers.class.getClassLoader()).spliterator(), false).collect(Collectors.toMap(AnnouncerBuilderFactory::getName, AnnouncerBuilderFactory::getBuilder));
        TreeMap<String, Announcer> announcers = new TreeMap<String, Announcer>();
        builders.forEach((name, builder) -> {
            if (null != model.getAnnounce().findAnnouncer(name)) {
                announcers.put((String)name, builder.configureWith(context).build());
            }
        });
        return announcers;
    }
}

