/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import org.jreleaser.bundle.RB;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public class Env {
    private static final String JRELEASER_PREFIX = "JRELEASER_";

    public static String toVar(String str) {
        return str.replaceAll(" ", "_").replaceAll("-", "_").toUpperCase();
    }

    public static String prefix(String key) {
        if (!key.startsWith(JRELEASER_PREFIX)) {
            return JRELEASER_PREFIX + key;
        }
        return key;
    }

    public static String resolve(String key, String value) {
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return System.getenv(Env.prefix(key));
    }

    public static String check(String key, String value, String property, String dsl, String configFilePath, Errors errors) {
        String prefixedKey;
        if (StringUtils.isBlank(value) && StringUtils.isBlank(value = System.getenv(prefixedKey = Env.prefix(key)))) {
            errors.configuration(RB.$("ERROR_environment_property_check", property, dsl, prefixedKey, configFilePath));
        }
        return value;
    }
}

