/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.templates;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.ResourceUtils;

public final class TemplateUtils {
    private TemplateUtils() {
    }

    public static String trimTplExtension(String str) {
        if (str.endsWith(".tpl")) {
            return str.substring(0, str.length() - 4);
        }
        return str;
    }

    public static Map<String, Reader> resolveAndMergeTemplates(JReleaserLogger logger, String distributionType, String toolName, boolean snapshot, Path templateDirectory) {
        Map<String, Reader> templates = TemplateUtils.resolveTemplates(logger, distributionType, toolName, snapshot);
        if (null != templateDirectory && templateDirectory.toFile().exists()) {
            templates.putAll(TemplateUtils.resolveTemplates(distributionType, toolName, snapshot, templateDirectory));
        }
        return templates;
    }

    public static Map<String, Reader> resolveTemplates(String distributionType, String toolName, boolean snapshot, Path templateDirectory) {
        final LinkedHashMap<String, Reader> templates = new LinkedHashMap<String, Reader>();
        Path snapshotTemplateDirectory = templateDirectory.resolveSibling(templateDirectory.getFileName() + "-snapshot");
        Path directory = templateDirectory;
        if (snapshot && snapshotTemplateDirectory.toFile().exists()) {
            directory = snapshotTemplateDirectory;
        }
        final Path actualTemplateDirectory = directory;
        try {
            Files.walkFileTree(actualTemplateDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    templates.put(actualTemplateDirectory.relativize(file).toString(), Files.newBufferedReader(file));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            String distributionTypeName = distributionType.toLowerCase().replace('_', '-');
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_reading_templates_distribution", (Object[])new Object[]{distributionTypeName, toolName, actualTemplateDirectory.toAbsolutePath()}));
        }
        return templates;
    }

    public static Map<String, Reader> resolveTemplates(final Path templateDirectory) {
        final LinkedHashMap<String, Reader> templates = new LinkedHashMap<String, Reader>();
        try {
            Files.walkFileTree(templateDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    templates.put(templateDirectory.relativize(file).toString(), Files.newBufferedReader(file));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_reading_templates_from", (Object[])new Object[]{templateDirectory.toAbsolutePath()}));
        }
        return templates;
    }

    public static Map<String, Reader> resolveTemplates(JReleaserLogger logger, String distributionType, String toolName, boolean snapshot) {
        LinkedHashMap<String, Reader> templates;
        block7: {
            String distributionTypeName = distributionType.toLowerCase().replace('_', '-');
            templates = new LinkedHashMap<String, Reader>();
            logger.debug(RB.$((String)"templates.templates.resolve.classpath", (Object[])new Object[0]));
            URL location = ResourceUtils.resolveLocation(TemplateUtils.class);
            if (null == location) {
                throw new JReleaserException(RB.$((String)"ERROR_classpath_template_resolve", (Object[])new Object[0]));
            }
            try {
                if ("file".equals(location.getProtocol())) {
                    boolean templateFound = false;
                    String templatePrefix = "META-INF/jreleaser/templates/" + distributionTypeName + "/" + toolName.toLowerCase() + (snapshot ? "-snapshot" : "") + "/";
                    JarFile jarFile = new JarFile(new File(location.toURI()));
                    if (snapshot) {
                        templateFound = TemplateUtils.findTemplate(logger, jarFile, templatePrefix, templates);
                        if (!templateFound) {
                            templatePrefix = "META-INF/jreleaser/templates/" + distributionTypeName + "/" + toolName.toLowerCase() + "/";
                            templateFound = TemplateUtils.findTemplate(logger, jarFile, templatePrefix, templates);
                        }
                    } else {
                        templateFound = TemplateUtils.findTemplate(logger, jarFile, templatePrefix, templates);
                    }
                    break block7;
                }
                throw new JReleaserException(RB.$((String)"ERROR_classpath_template_resolve", (Object[])new Object[0]));
            }
            catch (IOException | URISyntaxException e) {
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_reading_templates_distribution", (Object[])new Object[]{distributionTypeName, toolName, "classpath"}));
            }
        }
        return templates;
    }

    public static Reader resolveTemplate(JReleaserLogger logger, String announcerName) {
        logger.debug(RB.$((String)"templates.templates.resolve.classpath", (Object[])new Object[0]));
        URL location = ResourceUtils.resolveLocation(TemplateUtils.class);
        if (null == location) {
            throw new JReleaserException(RB.$((String)"ERROR_classpath_template_resolve", (Object[])new Object[0]));
        }
        try {
            if ("file".equals(location.getProtocol())) {
                boolean templateFound = false;
                String templateEntryName = "META-INF/jreleaser/templates/announcers/" + announcerName + ".tpl";
                JarFile jarFile = new JarFile(new File(location.toURI()));
                logger.debug(RB.$((String)"templates.search_matching_multiple", (Object[])new Object[0]), new Object[]{templateEntryName});
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (entry.isDirectory() || !entry.getName().equals(templateEntryName)) continue;
                    logger.debug(RB.$((String)"templates.found", (Object[])new Object[0]), new Object[]{templateEntryName});
                    return new InputStreamReader(jarFile.getInputStream(entry));
                }
            }
            throw new JReleaserException(RB.$((String)"ERROR_classpath_template_resolve", (Object[])new Object[0]));
        }
        catch (IOException | URISyntaxException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_reading_templates_announcer", (Object[])new Object[]{announcerName}));
        }
    }

    private static boolean findTemplate(JReleaserLogger logger, JarFile jarFile, String templatePrefix, Map<String, Reader> templates) throws IOException {
        boolean templatesFound = false;
        logger.debug(RB.$((String)"templates.search_matching_multiple", (Object[])new Object[0]), new Object[]{templatePrefix});
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (entry.isDirectory() || !entry.getName().startsWith(templatePrefix)) continue;
            String templateName = entry.getName().substring(templatePrefix.length());
            templates.put(templateName, new InputStreamReader(jarFile.getInputStream(entry)));
            logger.debug(RB.$((String)"templates.found", (Object[])new Object[0]), new Object[]{templateName});
            templatesFound = true;
        }
        return templatesFound;
    }

    public static Reader resolveTemplate(JReleaserLogger logger, Class<?> anchor, String templateKey) {
        logger.debug(RB.$((String)"templates.template.resolve.classpath", (Object[])new Object[0]), new Object[]{anchor.getName(), templateKey});
        URL location = ResourceUtils.resolveLocation(anchor);
        if (null == location) {
            throw new JReleaserException(RB.$((String)"ERROR_classpath_template_resolve", (Object[])new Object[0]));
        }
        try {
            if ("file".equals(location.getProtocol())) {
                JarFile jarFile = new JarFile(new File(location.toURI()));
                logger.debug(RB.$((String)"templates.search_matching", (Object[])new Object[0]), new Object[]{templateKey});
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (entry.isDirectory() || !entry.getName().equals(templateKey)) continue;
                    logger.debug(RB.$((String)"templates.found", (Object[])new Object[0]), new Object[]{templateKey});
                    return new InputStreamReader(jarFile.getInputStream(entry));
                }
                throw new JReleaserException(RB.$((String)"ERROR_template_not_found", (Object[])new Object[]{anchor.getName(), templateKey}));
            }
            throw new JReleaserException(RB.$((String)"ERROR_classpath_template_resolve", (Object[])new Object[0]));
        }
        catch (IOException | URISyntaxException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_reading_template_for", (Object[])new Object[]{anchor.getName() + "@" + templateKey, "classpath"}));
        }
    }
}

