/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.assemble;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.assemble.DistributionAssembler;
import org.jreleaser.model.Assemble;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;

public class Assemblers {
    public static void assemble(JReleaserContext context) {
        Assemble assemble = context.getModel().getAssemble();
        if (!assemble.isEnabled()) {
            context.getLogger().info(RB.$((String)"assemblers.not.enabled", (Object[])new Object[0]));
            return;
        }
        if (!context.getIncludedAssemblers().isEmpty()) {
            for (String assemblerType : context.getIncludedAssemblers()) {
                if (!Assemble.supportedAssemblers().contains(assemblerType)) {
                    context.getLogger().warn(RB.$((String)"ERROR_unsupported_assembler", (Object[])new Object[]{assemblerType}));
                    continue;
                }
                Map assemblers = assemble.findAssemblersByType(assemblerType);
                if (assemblers.isEmpty()) {
                    context.getLogger().debug(RB.$((String)"assemblers.no.match", (Object[])new Object[0]), new Object[]{assemblerType});
                    return;
                }
                if (!context.getIncludedDistributions().isEmpty()) {
                    for (String distributionName : context.getIncludedDistributions()) {
                        if (!assemblers.containsKey(distributionName)) {
                            context.getLogger().error(RB.$((String)"assemblers.distribution.not.configured", (Object[])new Object[0]), new Object[]{assemblerType, distributionName});
                            continue;
                        }
                        assemble.findAllAssemblers().stream().filter(a -> distributionName.equals(a.getName())).peek(assembler -> context.getLogger().info(RB.$((String)"assemblers.assemble.distribution.with", (Object[])new Object[0]), new Object[]{distributionName, assembler.getName()})).forEach(assembler -> Assemblers.assemble(context, assembler));
                    }
                    continue;
                }
                context.getLogger().info(RB.$((String)"assemblers.assemble.all.distributions.with", (Object[])new Object[0]), new Object[]{assemblerType});
                assemblers.values().forEach(assembler -> Assemblers.assemble(context, assembler));
            }
        } else if (!context.getIncludedDistributions().isEmpty()) {
            for (String distributionName : context.getIncludedDistributions()) {
                context.getLogger().info(RB.$((String)"assemblers.assemble.distribution.with.all", (Object[])new Object[0]), new Object[]{distributionName});
                assemble.findAllAssemblers().stream().filter(a -> distributionName.equals(a.getName())).forEach(assembler -> Assemblers.assemble(context, assembler));
            }
        } else {
            context.getLogger().info(RB.$((String)"assemblers.assemble.all.distributions", (Object[])new Object[0]));
            for (Assembler assembler2 : assemble.findAllAssemblers()) {
                String assemblerType = assembler2.getType();
                String distributionName = assembler2.getName();
                if (context.getExcludedAssemblers().contains(assemblerType) || context.getExcludedDistributions().contains(distributionName)) {
                    context.getLogger().info(RB.$((String)"assemblers.assembler.excluded", (Object[])new Object[0]), new Object[]{assemblerType, distributionName});
                    continue;
                }
                Assemblers.assemble(context, assembler2);
            }
        }
    }

    private static void assemble(JReleaserContext context, Assembler assembler) {
        try {
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix(assembler.getType());
            DistributionAssembler processor = Assemblers.createDistributionAssembler(context, assembler);
            processor.assemble();
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
        catch (AssemblerProcessingException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static DistributionAssembler createDistributionAssembler(JReleaserContext context, Assembler assembler) {
        return DistributionAssembler.builder().context(context).assembler(assembler).build();
    }
}

