/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Snap;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SnapValidator
extends Validator {
    public static void validateSnap(JReleaserContext context, Distribution distribution, Snap tool, Errors errors) {
        JReleaserModel model = context.getModel();
        Snap parentTool = model.getPackagers().getSnap();
        if (!tool.isActiveSet() && parentTool.isActiveSet()) {
            tool.setActive(parentTool.getActive());
        }
        if (!tool.resolveEnabled(context.getModel().getProject(), distribution)) {
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            tool.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.snap", new Object[]{distribution.getName()});
        SnapValidator.validateCommitAuthor(tool, parentTool);
        Snap.SnapTap snap = tool.getSnap();
        snap.resolveEnabled(model.getProject());
        if (StringUtils.isBlank((String)snap.getName())) {
            snap.setName(distribution.getName() + "-snap");
        }
        SnapValidator.validateTap(context, distribution, snap, parentTool.getSnap(), "snap.snap");
        TemplateValidator.validateTemplate(context, distribution, tool, parentTool, errors);
        ExtraPropertiesValidator.mergeExtraProperties(tool, parentTool);
        SnapValidator.validateContinueOnError(tool, parentTool);
        SnapValidator.mergeSnapPlugs(tool, parentTool);
        SnapValidator.mergeSnapSlots(tool, parentTool);
        if (StringUtils.isBlank((String)tool.getPackageName())) {
            tool.setPackageName(parentTool.getPackageName());
            if (StringUtils.isBlank((String)tool.getPackageName())) {
                tool.setPackageName(distribution.getName());
            }
        }
        if (StringUtils.isBlank((String)tool.getBase())) {
            tool.setBase(parentTool.getBase());
            if (StringUtils.isBlank((String)tool.getBase())) {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.base"}));
            }
        }
        if (StringUtils.isBlank((String)tool.getGrade())) {
            tool.setGrade(parentTool.getGrade());
            if (StringUtils.isBlank((String)tool.getGrade())) {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.grade"}));
            }
        }
        if (StringUtils.isBlank((String)tool.getConfinement())) {
            tool.setConfinement(parentTool.getConfinement());
            if (StringUtils.isBlank((String)tool.getConfinement())) {
                errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.confinement"}));
            }
        }
        if (!tool.isRemoteBuildSet() && parentTool.isRemoteBuildSet()) {
            tool.setRemoteBuild(parentTool.isRemoteBuild());
        }
        if (!tool.isRemoteBuild() && StringUtils.isBlank((String)tool.getExportedLogin())) {
            tool.setExportedLogin(parentTool.getExportedLogin());
            if (StringUtils.isBlank((String)tool.getExportedLogin())) {
                errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.exportedLogin"}));
            } else if (!context.getBasedir().resolve(tool.getExportedLogin()).toFile().exists()) {
                errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.exportedLogin", context.getBasedir().resolve(tool.getExportedLogin())}));
            }
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, tool, errors);
        List candidateArtifacts = distribution.getArtifacts().stream().filter(Artifact::isActive).filter(artifact -> tool.getSupportedExtensions().stream().anyMatch(ext -> artifact.getPath().endsWith((String)ext))).filter(artifact -> tool.supportsPlatform(artifact.getPlatform())).filter(artifact -> !StringUtils.isTrue((Object)artifact.getExtraProperties().get("skipSnap"))).collect(Collectors.toList());
        if (candidateArtifacts.size() == 0) {
            tool.setActive(Active.NEVER);
            tool.disable();
        } else if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_tool_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap"}));
            tool.disable();
        }
        tool.addArchitecture(parentTool.getArchitectures());
        for (int i = 0; i < tool.getArchitectures().size(); ++i) {
            Snap.Architecture arch = tool.getArchitectures().get(i);
            if (arch.hasBuildOn()) continue;
            errors.configuration(RB.$((String)"validation_snap_missing_buildon", (Object[])new Object[]{"distribution." + distribution.getName() + ".snap.architectures", i}));
        }
    }

    private static void mergeSnapPlugs(Snap tool, Snap common) {
        LinkedHashSet<String> localPlugs = new LinkedHashSet<String>();
        localPlugs.addAll(tool.getLocalPlugs());
        localPlugs.addAll(common.getLocalPlugs());
        tool.setLocalPlugs(localPlugs);
        Map<String, Snap.Plug> commonPlugs = common.getPlugs().stream().collect(Collectors.toMap(Snap.Plug::getName, Snap.Plug::copyOf));
        Map<String, Snap.Plug> toolPlugs = tool.getPlugs().stream().collect(Collectors.toMap(Snap.Plug::getName, Snap.Plug::copyOf));
        commonPlugs.forEach((name, cp) -> {
            Snap.Plug tp = (Snap.Plug)toolPlugs.remove(name);
            if (null != tp) {
                cp.getAttributes().putAll(tp.getAttributes());
            }
        });
        commonPlugs.putAll(toolPlugs);
        tool.setPlugs(new ArrayList<Snap.Plug>(commonPlugs.values()));
    }

    private static void mergeSnapSlots(Snap tool, Snap common) {
        LinkedHashSet<String> localSlots = new LinkedHashSet<String>();
        localSlots.addAll(tool.getLocalSlots());
        localSlots.addAll(common.getLocalSlots());
        tool.setLocalSlots(localSlots);
        Map<String, Snap.Slot> commonSlots = common.getSlots().stream().collect(Collectors.toMap(Snap.Slot::getName, Snap.Slot::copyOf));
        Map<String, Snap.Slot> toolSlots = tool.getSlots().stream().collect(Collectors.toMap(Snap.Slot::getName, Snap.Slot::copyOf));
        commonSlots.forEach((name, cp) -> {
            Snap.Slot tp = (Snap.Slot)toolSlots.remove(name);
            if (null != tp) {
                cp.getAttributes().putAll(tp.getAttributes());
            }
        });
        commonSlots.putAll(toolSlots);
        tool.setSlots(new ArrayList<Snap.Slot>(commonSlots.values()));
    }
}

