/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Domain;
import org.jreleaser.model.Glob;

public class Files
implements Domain {
    private final Set<Artifact> artifacts = new LinkedHashSet<Artifact>();
    private final List<Glob> globs = new ArrayList<Glob>();
    private final Set<Artifact> paths = new LinkedHashSet<Artifact>();
    @JsonIgnore
    private boolean resolved;

    public boolean isEmpty() {
        return this.artifacts.isEmpty() && this.globs.isEmpty();
    }

    public boolean arePathsResolved() {
        return this.resolved;
    }

    public Set<Artifact> getPaths() {
        return Artifact.sortArtifacts(this.paths);
    }

    public void setPaths(Set<Artifact> paths) {
        this.paths.clear();
        this.paths.addAll(paths);
        this.resolved = true;
    }

    void setAll(Files files) {
        this.setArtifacts(files.artifacts);
        this.setGlobs(files.globs);
    }

    public Set<Artifact> getArtifacts() {
        return Artifact.sortArtifacts(this.artifacts);
    }

    public void setArtifacts(Set<Artifact> artifacts) {
        this.artifacts.clear();
        this.artifacts.addAll(artifacts);
    }

    public void addArtifacts(Set<Artifact> artifacts) {
        this.artifacts.addAll(artifacts);
    }

    public void addArtifact(Artifact artifact) {
        if (null != artifact) {
            this.artifacts.add(artifact);
        }
    }

    public List<Glob> getGlobs() {
        return this.globs;
    }

    public void setGlobs(List<Glob> globs) {
        this.globs.clear();
        this.globs.addAll(globs);
    }

    public void addGlobs(List<Glob> globs) {
        this.globs.addAll(globs);
    }

    public void addGlob(Glob glob) {
        if (null != glob) {
            this.globs.add(glob);
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> mappedArtifacts = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact artifact : this.getArtifacts()) {
            mappedArtifacts.put("artifact " + i++, artifact.asMap(full));
        }
        map.put("artifacts", mappedArtifacts);
        LinkedHashMap<String, Map<String, Object>> mappedGlobs = new LinkedHashMap<String, Map<String, Object>>();
        for (i = 0; i < this.globs.size(); ++i) {
            mappedGlobs.put("glob " + i, this.globs.get(i).asMap(full));
        }
        map.put("globs", mappedGlobs);
        return map;
    }
}

