#! /bin/sh
# Copyright (c) 2002 Valesoft Ltd UK.
#
# Author: Chris Haynes 
#
# /etc/init.d/iptables
#
#   and symbolic link from
#
# /etc/init.d/boot.d/S30iptables
#
# System startup script for port redirection using iptables
#
### BEGIN INIT INFO
# Provides: 
# Required-Start: $remote_fs $syslog
# Required-Stop:  $remote_fs $syslog
# Default-Start:  3 5
# Default-Stop:   0 1 2 6
# Description:    Port redirection 80==> 8080 and 443==>8443 in boot
### END INIT INFO


case "$1" in
    start)
	echo "Setting up port redirection in /etc/init.d/iptables"
	modprobe iptable_nat
	iptables -v -A PREROUTING -t nat -p tcp --dport 80 -j REDIRECT --to-port 8080
	echo "Port 80 ==> 8080"
	iptables -v -A PREROUTING -t nat -p tcp --dport 443 -j REDIRECT --to-port 8443
	echo "Port 443 ==> 8443"
	ipchains -t nat -L
	echo
	;;
	
    *)
		echo "Usage iptables start"
	;;
esac
