/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.ns;

import java.io.InputStream;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import org.objectweb.carol.jndi.ns.NameService;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.util.configuration.TraceCarol;

public class OpenOrbCosNaming
implements NameService {
    public int port = 12350;
    public Process cosNamingProcess = null;

    public void start() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("OpenOrbCosNaming.start() on port:" + this.port);
        }
        try {
            if (!this.isStarted()) {
                if (this.port >= 0) {
                    this.cosNamingProcess = Runtime.getRuntime().exec(System.getProperty("java.home") + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "java " + "-Dorg.omg.CORBA.ORBClass=org.openorb.CORBA.ORB " + "-Dorg.omg.CORBA.ORBSingletonClass=org.openorb.CORBA.ORBSingleton " + "org.openorb.util.MapNamingContext -default -ORBPort=" + this.port);
                    Thread.sleep(2000L);
                    InputStream cosError = this.cosNamingProcess.getErrorStream();
                    if (cosError.available() != 0) {
                        byte[] b = new byte[cosError.available()];
                        cosError.read(b);
                        cosError.close();
                        throw new NameServiceException("can not start cosnaming daemon:" + new String(b));
                    }
                    InputStream cosOut = this.cosNamingProcess.getInputStream();
                    if (cosOut.available() != 0) {
                        byte[] b = new byte[cosOut.available()];
                        cosOut.read(b);
                        cosOut.close();
                        if (TraceCarol.isDebugJndiCarol()) {
                            TraceCarol.debugJndiCarol("OpenORBCosNaming:");
                            TraceCarol.debugJndiCarol(new String(b));
                        }
                    }
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                OpenOrbCosNaming.this.stop();
                            }
                            catch (Exception e) {
                                TraceCarol.error("OpenORBCosNaming ShutdownHook problem", e);
                            }
                        }
                    });
                } else if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Can't start OpenORBCosNaming, port=" + this.port + " is < 0");
                }
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("OpenORBCosNaming is already start on port:" + this.port);
            }
        }
        catch (Exception e) {
            TraceCarol.error("Can not start OpenORBCosNaming for an unknow Reason", e);
            throw new NameServiceException("can not start cosnaming daemon: " + e);
        }
    }

    public void stop() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("OpenORBCosNaming.stop()");
        }
        try {
            if (this.cosNamingProcess != null) {
                this.cosNamingProcess.destroy();
            }
            this.cosNamingProcess = null;
        }
        catch (Exception e) {
            throw new NameServiceException("can not stop cosnaming daemon: " + e);
        }
    }

    public boolean isStarted() {
        if (this.cosNamingProcess != null) {
            return true;
        }
        Properties prop = new Properties();
        prop.put("java.naming.factory.initial", "org.openorb.rmi.jndi.CtxFactory");
        prop.put("java.naming.provider.url", "corbaloc::localhost:" + this.port);
        try {
            InitialContext ic = new InitialContext(prop);
        }
        catch (CommunicationException jcm) {
            return false;
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public void setPort(int p) {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("IIOPCosNaming.setPort(" + p + ")");
        }
        if (p != 0) {
            this.port = p;
        }
    }

    public int getPort() {
        return this.port;
    }
}

