/*
 * Decompiled with CFR 0.152.
 */
package lti.java.jcf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import lti.java.jcf.JcfAttribute;
import lti.java.jcf.JcfAttributeCollection;
import lti.java.jcf.JcfClassInput;
import lti.java.jcf.JcfClassOutput;
import lti.java.jcf.JcfClassOutputStream;
import lti.java.jcf.JcfConstantPool;
import lti.java.jcf.JcfExceptionTable;

public class JcfCodeAttribute
extends JcfAttribute {
    public short catMaxStack;
    public short catMaxLocals;
    public byte[] catCode;
    public JcfExceptionTable catExceptionTable;
    public JcfAttributeCollection catExtraAttributes;

    public JcfCodeAttribute(JcfClassInput ist, short nameIndex, JcfConstantPool p) throws IOException, ClassFormatError {
        super(ist, nameIndex, p);
    }

    public void readData(JcfClassInput ist) throws IOException, ClassFormatError {
        this.catMaxStack = ist.readShort();
        this.catMaxLocals = ist.readShort();
        this.catCode = new byte[ist.readInt()];
        this.readCode(ist);
        this.catExceptionTable = new JcfExceptionTable(ist, this);
        this.catExtraAttributes = this.constPool.getClassFile().readAttributes(ist);
    }

    public void write(JcfClassOutput ost) throws IOException {
        ByteArrayOutputStream bost = new ByteArrayOutputStream(512);
        JcfClassOutputStream jost = new JcfClassOutputStream(bost);
        jost.writeShort(this.catMaxStack);
        jost.writeShort(this.catMaxLocals);
        jost.writeInt(this.catCode.length);
        this.writeCode(jost);
        this.catExceptionTable.write(jost);
        this.catExtraAttributes.write(jost);
        this.atrData = bost.toByteArray();
        this.atrLength = this.atrData.length;
        super.write(ost);
    }

    public void writeCode(JcfClassOutput ost) throws IOException, ClassFormatError {
        ost.write(this.catCode);
    }

    public void readCode(JcfClassInput ist) throws IOException, ClassFormatError {
        ist.readFully(this.catCode);
    }
}

