/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.util.JarUtils;

public class ManifestShowJarProcessor
implements JarProcessor<Optional<Manifest>> {
    private final JarFileResolver jarFileResolver;

    public ManifestShowJarProcessor(JarFileResolver jarFileResolver) {
        this.jarFileResolver = jarFileResolver;
    }

    @Override
    public Set<JarProcessor.JarFileResult<Optional<Manifest>>> getResult() throws JarvizException {
        TreeSet<JarProcessor.JarFileResult<Optional<Manifest>>> set = new TreeSet<JarProcessor.JarFileResult<Optional<Manifest>>>();
        for (JarFile jarFile : this.jarFileResolver.resolveJarFiles()) {
            set.add(this.processJarFile(jarFile));
        }
        return set;
    }

    private JarProcessor.JarFileResult<Optional<Manifest>> processJarFile(JarFile jarFile) {
        return JarProcessor.JarFileResult.of(jarFile, JarUtils.getManifest(jarFile));
    }
}

