/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.function.Consumer;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.Format;
import org.kordamp.jarviz.core.InsufficientInputsException;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.internal.Colorizer;
import org.kordamp.jarviz.core.internal.Configuration;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.core.resolvers.JarFileResolvers;
import org.kordamp.jarviz.reporting.Formatter;
import org.kordamp.jarviz.reporting.JsonFormatter;
import org.kordamp.jarviz.reporting.Node;
import org.kordamp.jarviz.reporting.TxtFormatter;
import org.kordamp.jarviz.reporting.XmlFormatter;
import org.kordamp.jarviz.reporting.YamlFormatter;
import org.kordamp.jarviz.util.Algorithm;
import org.kordamp.jarviz.util.ChecksumUtils;

public abstract class AbstractCommand<C extends Configuration<C>> {
    public static final String INDENT = "  ";
    public static final String SPACE = " ";
    public static final String EMPTY = "";

    public abstract int execute(C var1);

    protected Path resolveCacheDirectory(C configuration) {
        Path cache = configuration.getCacheDirectory();
        Path path = cache = null != cache ? cache : Paths.get("cache", new String[0]);
        if (!cache.isAbsolute()) {
            Path basedir = Paths.get(".", new String[0]).normalize();
            cache = basedir.relativize(cache);
        }
        cache = cache.resolve("jarviz");
        try {
            Files.createDirectories(cache, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_CREATE_DIRECTORY", cache), e);
        }
        return cache;
    }

    protected Path resolveReportPath(C configuration, Format format) {
        Path reportPath = configuration.getReportPath();
        return Paths.get(reportPath.toAbsolutePath() + "." + format.toString().toLowerCase(Locale.ROOT), new String[0]);
    }

    protected Formatter resolveFormatter(Format format) {
        switch (format) {
            case XML: {
                return XmlFormatter.INSTANCE;
            }
            case JSON: {
                return JsonFormatter.INSTANCE;
            }
            case YAML: {
                return YamlFormatter.INSTANCE;
            }
        }
        return TxtFormatter.INSTANCE;
    }

    protected Node createRootNode() {
        return Node.root(RB.$("report.key.jarviz", new Object[0]));
    }

    protected Node appendSubject(Node root, Path jarPath, String command, Consumer<Node> result) {
        Node subjects = root.getChildren().isEmpty() ? root.array(RB.$("report.key.subjects", new Object[0])) : root.getChildren().get(0);
        Node resultNode = subjects.collapsable(RB.$("report.key.subject", new Object[0])).node(RB.$("report.key.command", new Object[0])).value(command).end().node(RB.$("report.key.jar", new Object[0])).node(RB.$("report.key.file", new Object[0])).value(jarPath.getFileName()).end().node(RB.$("report.key.size", new Object[0])).value(this.fileSize(jarPath)).end().node(RB.$("report.key.sha256", new Object[0])).value(this.sha256(jarPath)).end().end().node(RB.$("report.key.result", new Object[0]));
        result.accept(resultNode);
        return root;
    }

    protected void writeOutput(C configuration, String content) {
        configuration.getOut().println(content);
    }

    protected void writeReport(C configuration, String content, Format format) {
        Path reportPath = this.resolveReportPath(configuration, format);
        try {
            Files.createDirectories(reportPath.getParent(), new FileAttribute[0]);
            Files.write(reportPath, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_WRITE_FILE", reportPath.toAbsolutePath()), e);
        }
    }

    protected String $$(String key, Object ... args) {
        return Colorizer.colorize(RB.$(key, args));
    }

    protected String $b(boolean val) {
        return Colorizer.bool(val);
    }

    private long fileSize(Path jarPath) {
        try {
            return Files.size(jarPath);
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_UNEXPECTED", new Object[0]), e);
        }
    }

    private String sha256(Path jarPath) {
        return ChecksumUtils.checksum(Algorithm.SHA_256, jarPath);
    }

    protected JarFileResolver createJarFileResolver(C configuration) {
        LinkedHashSet<JarFileResolver> resolvers = new LinkedHashSet<JarFileResolver>();
        Path cacheDirectory = this.resolveCacheDirectory(configuration);
        resolvers.addAll(JarFileResolvers.gavJarFileResolvers(cacheDirectory, configuration.getGavs()));
        resolvers.addAll(JarFileResolvers.pathJarFileResolvers(configuration.getFiles()));
        resolvers.addAll(JarFileResolvers.directoryJarFileResolvers(configuration.getDirectories()));
        resolvers.addAll(JarFileResolvers.classpathJarFileResolvers(configuration.getClasspaths()));
        resolvers.addAll(JarFileResolvers.urlJarFileResolvers(cacheDirectory, configuration.getUrls()));
        if (resolvers.isEmpty()) {
            throw new InsufficientInputsException(this.$$("ERROR_INSUFFICIENT_INPUTS", new Object[0]));
        }
        return JarFileResolvers.compositeJarFileResolver(resolvers);
    }
}

