/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.resolution.model.typesystem;

import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.logic.FunctionalInterfaceLogic;
import com.github.javaparser.resolution.model.LambdaArgumentTypePlaceholder;
import com.github.javaparser.resolution.model.typesystem.NullType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeTransformer;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.resolution.types.parametrization.ResolvedTypeParametersMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReferenceTypeImpl
extends ResolvedReferenceType {
    public static ResolvedReferenceType undeterminedParameters(ResolvedReferenceTypeDeclaration typeDeclaration) {
        return new ReferenceTypeImpl(typeDeclaration, typeDeclaration.getTypeParameters().stream().map(ResolvedTypeVariable::new).collect(Collectors.toList()));
    }

    @Override
    protected ResolvedReferenceType create(ResolvedReferenceTypeDeclaration typeDeclaration, List<ResolvedType> typeParametersCorrected) {
        return new ReferenceTypeImpl(typeDeclaration, typeParametersCorrected);
    }

    @Override
    protected ResolvedReferenceType create(ResolvedReferenceTypeDeclaration typeDeclaration) {
        return new ReferenceTypeImpl(typeDeclaration);
    }

    public ReferenceTypeImpl(ResolvedReferenceTypeDeclaration typeDeclaration) {
        super(typeDeclaration);
    }

    public ReferenceTypeImpl(ResolvedReferenceTypeDeclaration typeDeclaration, List<ResolvedType> typeArguments) {
        super(typeDeclaration, typeArguments);
    }

    @Override
    public ResolvedTypeParameterDeclaration asTypeParameter() {
        return this.typeDeclaration.asTypeParameter();
    }

    @Override
    public boolean isAssignableBy(ResolvedType other) {
        if (other instanceof NullType) {
            return !this.isPrimitive();
        }
        if (!other.isVoid() && this.isJavaLangObject()) {
            return true;
        }
        if (other.isPrimitive()) {
            if (this.isJavaLangObject()) {
                return true;
            }
            if (this.isCorrespondingBoxingType(other.describe())) {
                return true;
            }
            return other.isNumericType() && this.isReferenceType() && this.asReferenceType().getQualifiedName().equals(Number.class.getCanonicalName());
        }
        if (other instanceof LambdaArgumentTypePlaceholder) {
            return FunctionalInterfaceLogic.isFunctionalInterfaceType(this);
        }
        if (other.isReferenceType()) {
            ResolvedReferenceType otherRef = other.asReferenceType();
            if (this.compareConsideringTypeParameters(otherRef)) {
                return true;
            }
            for (ResolvedReferenceType otherAncestor : otherRef.getAllAncestors()) {
                if (!this.compareConsideringTypeParameters(otherAncestor)) continue;
                return true;
            }
            return false;
        }
        if (other.isTypeVariable()) {
            for (ResolvedTypeParameterDeclaration.Bound bound : other.asTypeVariable().asTypeParameter().getBounds()) {
                if (!bound.isExtends() || !this.isAssignableBy(bound.getType())) continue;
                return true;
            }
            return false;
        }
        if (other.isConstraint()) {
            return this.isAssignableBy(other.asConstraintType().getBound());
        }
        if (other.isWildcard()) {
            if (this.isJavaLangObject()) {
                return true;
            }
            if (other.asWildcard().isExtends()) {
                return this.isAssignableBy(other.asWildcard().getBoundedType());
            }
            return false;
        }
        if (other.isUnionType()) {
            Optional<ResolvedReferenceType> common = other.asUnionType().getCommonAncestor();
            return common.map(ancestor -> this.isAssignableBy((ResolvedType)ancestor)).orElse(false);
        }
        return false;
    }

    @Override
    public Set<MethodUsage> getDeclaredMethods() {
        HashSet<MethodUsage> methods = new HashSet<MethodUsage>();
        this.getTypeDeclaration().ifPresent(referenceTypeDeclaration -> {
            for (ResolvedMethodDeclaration methodDeclaration : referenceTypeDeclaration.getDeclaredMethods()) {
                MethodUsage methodUsage = new MethodUsage(methodDeclaration);
                methods.add(methodUsage);
            }
        });
        return methods;
    }

    @Override
    public ResolvedType toRawType() {
        if (this.isRawType()) {
            return this;
        }
        return new ReferenceTypeImpl(this.typeDeclaration, Collections.emptyList());
    }

    @Override
    public boolean mention(List<ResolvedTypeParameterDeclaration> typeParameters) {
        return this.typeParametersValues().stream().anyMatch(tp -> tp.mention(typeParameters));
    }

    @Override
    public ResolvedType transformTypeParameters(ResolvedTypeTransformer transformer) {
        ResolvedReferenceType result = this;
        int i = 0;
        for (ResolvedType tp : this.typeParametersValues()) {
            ResolvedType transformedTp = transformer.transform(tp);
            if (transformedTp != tp) {
                List<ResolvedType> typeParametersCorrected = result.asReferenceType().typeParametersValues();
                typeParametersCorrected.set(i, transformedTp);
                result = this.create(this.typeDeclaration, typeParametersCorrected);
            }
            ++i;
        }
        return result;
    }

    @Override
    public List<ResolvedReferenceType> getAllAncestors() {
        return this.getAllAncestors(ResolvedReferenceTypeDeclaration.depthFirstFunc);
    }

    @Override
    public List<ResolvedReferenceType> getAllAncestors(Function<ResolvedReferenceTypeDeclaration, List<ResolvedReferenceType>> traverser) {
        List<ResolvedReferenceType> ancestors = this.typeDeclaration.getAllAncestors(traverser);
        ancestors = ancestors.stream().map(a -> this.typeParametersMap().replaceAll((ResolvedType)a).asReferenceType()).collect(Collectors.toList());
        return ancestors;
    }

    @Override
    public List<ResolvedReferenceType> getDirectAncestors() {
        ResolvedReferenceTypeDeclaration thisTypeDeclaration;
        List<ResolvedReferenceType> ancestors = this.typeDeclaration.getAncestors();
        ancestors = ancestors.stream().map(a -> this.typeParametersMap().replaceAll((ResolvedType)a).asReferenceType()).collect(Collectors.toList());
        if (this.getTypeDeclaration().isPresent() && (thisTypeDeclaration = this.getTypeDeclaration().get()).isClass()) {
            Optional<ResolvedReferenceType> optionalSuperClass = thisTypeDeclaration.asClass().getSuperClass();
            boolean superClassIsJavaLangObject = optionalSuperClass.isPresent() && optionalSuperClass.get().isJavaLangObject();
            boolean thisIsJavaLangObject = thisTypeDeclaration.asClass().isJavaLangObject();
            if (superClassIsJavaLangObject && !thisIsJavaLangObject) {
                ancestors.add(optionalSuperClass.get());
            }
        }
        return ancestors;
    }

    @Override
    public ResolvedReferenceType deriveTypeParameters(ResolvedTypeParametersMap typeParametersMap) {
        return this.create(this.typeDeclaration, typeParametersMap);
    }

    @Override
    public Set<ResolvedFieldDeclaration> getDeclaredFields() {
        LinkedHashSet<ResolvedFieldDeclaration> allFields = new LinkedHashSet<ResolvedFieldDeclaration>();
        if (this.getTypeDeclaration().isPresent()) {
            allFields.addAll(this.getTypeDeclaration().get().getDeclaredFields());
        }
        return allFields;
    }
}

