/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.collections;

import java.util.Map;
import org.multiverse.api.Stm;
import org.multiverse.api.Txn;
import org.multiverse.api.TxnThreadLocal;
import org.multiverse.api.collections.TxnCollection;
import org.multiverse.api.collections.TxnMap;
import org.multiverse.api.collections.TxnSet;
import org.multiverse.api.references.TxnRefFactory;

public abstract class AbstractTxnMap<K, V>
implements TxnMap<K, V> {
    protected final Stm stm;
    protected final TxnRefFactory defaultRefFactory;

    public AbstractTxnMap(Stm stm) {
        if (stm == null) {
            throw new NullPointerException();
        }
        this.stm = stm;
        this.defaultRefFactory = stm.getDefaultRefFactory();
    }

    @Override
    public final Stm getStm() {
        return this.stm;
    }

    @Override
    public int size() {
        return this.size(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public boolean isEmpty(Txn tx) {
        return this.size(tx) == 0;
    }

    @Override
    public void clear() {
        this.clear(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public V get(Object key) {
        return this.get(TxnThreadLocal.getThreadLocalTxn(), key);
    }

    @Override
    public V put(K key, V value) {
        return this.put(TxnThreadLocal.getThreadLocalTxn(), key, value);
    }

    @Override
    public V remove(Object key) {
        return this.remove(TxnThreadLocal.getThreadLocalTxn(), key);
    }

    @Override
    public TxnSet<K> keySet() {
        return this.keySet(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(TxnThreadLocal.getThreadLocalTxn(), key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(TxnThreadLocal.getThreadLocalTxn(), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putAll(TxnThreadLocal.getThreadLocalTxn(), m);
    }

    @Override
    public void putAll(Txn tx, Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(tx, e.getKey(), e.getValue());
        }
    }

    @Override
    public TxnCollection<V> values() {
        return this.values(TxnThreadLocal.getThreadLocalTxn());
    }

    @Override
    public TxnSet<Map.Entry<K, V>> entrySet() {
        return this.entrySet(TxnThreadLocal.getThreadLocalTxn());
    }

    public String toString() {
        return this.toString(TxnThreadLocal.getThreadLocalTxn());
    }
}

