/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.internal.concurrent.GradleThread;
import org.gradle.internal.impldep.javax.annotation.Nullable;

public class ThreadFactoryImpl
implements ThreadFactory {
    private final AtomicLong counter = new AtomicLong();
    private final String displayName;
    @Nullable
    private final ClassLoader contextClassloader;

    public ThreadFactoryImpl(String displayName, @Nullable ClassLoader contextClassloader) {
        this.displayName = displayName;
        this.contextClassloader = contextClassloader;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(new ManagedThreadRunnable(r));
        thread.setName(this.nextThreadName());
        thread.setContextClassLoader(this.contextClassloader);
        return thread;
    }

    private String nextThreadName() {
        long count = this.counter.incrementAndGet();
        return count == 1L ? this.displayName : this.displayName + " Thread " + count;
    }

    private static class ManagedThreadRunnable
    implements Runnable {
        private final Runnable delegate;

        private ManagedThreadRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            GradleThread.setManaged();
            this.delegate.run();
        }
    }
}

