package org.grails.datastore.mapping.model;

/**
 * Value generation strategies
 *
 * @author Graeme Rocher
 * @since 6.0
 */
public enum ValueGenerator {
    /**
     * Generated natively from the underlying datastore
     */
    NATIVE,

    /**
     * Using an identity column
     */
    IDENTITY,
    /**
     * Generated through assignment
     */
    ASSIGNED,
    /**
     * Generated by the datastore implementation
     */
    GENERATED,
    /**
     * The default generated
     */
    AUTO,
    /**
     * Generated from a sequence
     */
    SEQUENCE,
    /**
     * A generator that uses a HILO algorithm
     */
    HILO,

    /**
     * A generator that uses a sequence and a HILO algorithm
     */
    SEQHILO,
    /**
     * A generator that uses an auto-increment column
     */
    INCREMENT,
    /**
     * A generator that uses UUIDs
     */
    UUID,
    /**
     * A generator that uses UUID2s
     */
    UUID2,
    /**
     * uses a database-generated GUID string on MS SQL Server and MySQL.
     */
    GUID,
    /**
     * use the identifier of another object
     */
    FOREIGN,
    /**
     * Generates the id by selecting from a row using a unique key
     */
    SELECT,
    /**
     * Custom value generation strategy
     */
    CUSTOM

}
