/*
 * Decompiled with CFR 0.152.
 */
package org.grails.buffer;

import java.io.IOException;
import java.io.Writer;
import org.grails.buffer.GrailsPrintWriter;

public class GrailsLazyProxyPrintWriter
extends GrailsPrintWriter {
    private DestinationFactory factory;
    private boolean destinationActivated = false;

    public GrailsLazyProxyPrintWriter(DestinationFactory factory) {
        super(null);
        this.factory = factory;
    }

    @Override
    public Writer getOut() {
        if (!this.destinationActivated) {
            try {
                super.setOut(this.factory.activateDestination());
            }
            catch (IOException e) {
                this.setError();
            }
            this.destinationActivated = true;
        }
        return super.getOut();
    }

    @Override
    public boolean isAllowUnwrappingOut() {
        return this.destinationActivated ? super.isAllowUnwrappingOut() : false;
    }

    @Override
    public Writer unwrap() {
        return this.destinationActivated ? super.unwrap() : this;
    }

    public void updateDestination(DestinationFactory f) {
        this.setDestinationActivated(false);
        this.factory = f;
    }

    @Override
    public boolean isDestinationActivated() {
        return this.destinationActivated;
    }

    public void setDestinationActivated(boolean destinationActivated) {
        this.destinationActivated = destinationActivated;
        if (!this.destinationActivated) {
            super.setOut(null);
        }
    }

    public static interface DestinationFactory {
        public Writer activateDestination() throws IOException;
    }
}

