/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.async.publisher;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class CompletableFuturePublisher<T>
implements Publisher<T> {
    private final Supplier<CompletableFuture<T>> futureSupplier;

    CompletableFuturePublisher(Supplier<CompletableFuture<T>> futureSupplier) {
        this.futureSupplier = futureSupplier;
    }

    public final void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "Subscriber cannot be null");
        subscriber.onSubscribe((Subscription)new CompletableFutureSubscription(subscriber));
    }

    class CompletableFutureSubscription
    implements Subscription {
        private final Subscriber<? super T> subscriber;
        private final AtomicBoolean completed = new AtomicBoolean(false);
        private CompletableFuture<T> future;

        CompletableFutureSubscription(Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        public synchronized void request(long n) {
            if (n != 0L && !this.completed.get()) {
                if (n < 0L) {
                    IllegalArgumentException ex = new IllegalArgumentException("Cannot request a negative number");
                    this.subscriber.onError((Throwable)ex);
                } else {
                    try {
                        CompletableFuture future = (CompletableFuture)CompletableFuturePublisher.this.futureSupplier.get();
                        if (future == null) {
                            this.subscriber.onComplete();
                        } else {
                            this.future = future;
                            future.whenComplete((s, throwable) -> {
                                if (this.completed.compareAndSet(false, true)) {
                                    if (throwable != null) {
                                        this.subscriber.onError(throwable);
                                    } else {
                                        if (s != null) {
                                            this.subscriber.onNext(s);
                                        }
                                        this.subscriber.onComplete();
                                    }
                                }
                            });
                        }
                    }
                    catch (Throwable e) {
                        this.subscriber.onError(e);
                    }
                }
            }
        }

        public synchronized void cancel() {
            if (this.completed.compareAndSet(false, true) && this.future != null) {
                this.future.cancel(false);
            }
        }
    }
}

