/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import grails.util.GrailsWebUtil;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.Writer;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;

public class IncludedContent
implements Writable {
    private String contentType = GrailsWebUtil.getContentType("text/html", "UTF-8");
    private Object content;
    private String redirectURL;

    public IncludedContent(String contentType, Object content) {
        if (contentType != null) {
            this.contentType = contentType;
        }
        this.content = content;
    }

    public IncludedContent(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Object getContent() {
        return this.content;
    }

    public Writer writeTo(Writer target) throws IOException {
        if (this.content == null) {
            return target;
        }
        if (this.content instanceof StreamCharBuffer) {
            ((StreamCharBuffer)this.content).writeTo(target);
        } else if (this.content instanceof String) {
            target.write((String)this.content);
        } else {
            target.write(String.valueOf(this.content));
        }
        return target;
    }

    public char[] getContentAsCharArray() {
        if (this.content == null) {
            return new char[0];
        }
        if (this.content instanceof StreamCharBuffer) {
            return ((StreamCharBuffer)this.content).toCharArray();
        }
        if (this.content instanceof String) {
            return ((String)this.content).toCharArray();
        }
        return String.valueOf(this.content).toCharArray();
    }
}

