/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.uaa.client.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.prefs.BackingStoreException;
import org.springframework.uaa.client.TransmissionAwareUaaService;
import org.springframework.uaa.client.TransmissionService;
import org.springframework.uaa.client.VersionHelper;
import org.springframework.uaa.client.internal.BasicProxyService;
import org.springframework.uaa.client.internal.JdkUrlTransmissionServiceImpl;
import org.springframework.uaa.client.internal.UaaConfigurationProcessor;
import org.springframework.uaa.client.internal.UaaServiceImpl;
import org.springframework.uaa.client.protobuf.UaaClient;
import org.springframework.uaa.client.util.Assert;
import org.springframework.uaa.client.util.Base64;

public class TransmissionAwareUaaServiceImpl
extends UaaServiceImpl
implements TransmissionAwareUaaService {
    private static final String LAST_DOWNLOAD_TIMESTAMP = "last_download_timestamp";
    private static final String LAST_UPLOAD_TIMESTAMP = "last_upload_timestamp";
    private static final String PING_THREAD_NAME_TEMPLATE = "Ping (%s/%s.%s.%s)";
    private static final String THREAD_NAME_TEMPLATE = "Synchronizer (%s/%s.%s.%s)";
    static final String DOWNLOAD_INTERVAL_KEY = "download_interval";
    static final String PING_INTERVAL_KEY = "ping_interval";
    static final String UPLOAD_INTERVAL_KEY = "upload_interval";
    static long THREAD_DELAY = 10000L;
    static long THREAD_SLEEPTIME = 300000L;
    static long UPLOAD_INTERVAL_DEFAULT = 3600000L;
    static long DOWNLOAD_INTERVAL_DEFAULT = 86400000L;
    static long PING_INTERVAL_DEFAULT = 86400000L;
    private TransmissionService transmissionService;
    private Thread transmissionThread;
    private volatile boolean shouldExit = false;

    public TransmissionAwareUaaServiceImpl() {
        this(new JdkUrlTransmissionServiceImpl(new BasicProxyService()));
    }

    public TransmissionAwareUaaServiceImpl(TransmissionService transmissionService) {
        Assert.notNull(transmissionService, "TransmissionService is required");
        this.transmissionService = transmissionService;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                TransmissionAwareUaaServiceImpl.this.stopTransmissionThread();
            }
        });
        this.transmissionThread = new Thread((Runnable)new UaaTransmissionThread(), this.getThreadName(THREAD_NAME_TEMPLATE));
        this.transmissionThread.setDaemon(true);
        this.transmissionThread.start();
    }

    public void setPrivacyLevel(UaaClient.Privacy.PrivacyLevel privacyLevel) {
        if (privacyLevel == this.getPrivacyLevel()) {
            return;
        }
        super.setPrivacyLevel(privacyLevel);
        if (privacyLevel == UaaClient.Privacy.PrivacyLevel.DECLINE_TOU || privacyLevel == UaaClient.Privacy.PrivacyLevel.UNDECIDED_TOU) {
            new Thread(new Runnable(){

                public void run() {
                    TransmissionAwareUaaServiceImpl.this.uploadUaaEnvelope();
                }
            }, this.getThreadName(PING_THREAD_NAME_TEMPLATE)).start();
        }
    }

    public void requestTransmission() {
        if (this.isUaaTermsOfUseAccepted()) {
            new Thread(new Runnable(){

                public void run() {
                    TransmissionAwareUaaServiceImpl.this.uploadUaaEnvelope();
                }
            }, this.getThreadName(PING_THREAD_NAME_TEMPLATE)).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadAndUpdateConfiguration() {
        InputStream configuration = null;
        InputStream configurationSignature = null;
        try {
            configuration = this.transmissionService.download(UaaConfigurationProcessor.UAA_URL);
            configurationSignature = this.transmissionService.download(UaaConfigurationProcessor.SIGNATURE_URL);
            boolean bl = UaaConfigurationProcessor.updateConfiguration(configuration, configurationSignature);
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            this.storeTimestamp(LAST_DOWNLOAD_TIMESTAMP, System.currentTimeMillis());
            if (configuration != null) {
                try {
                    configuration.close();
                }
                catch (IOException e) {}
            }
            if (configurationSignature != null) {
                try {
                    configurationSignature.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    private String getThreadName(String template) {
        UaaClient.Product uaaProduct = VersionHelper.getUaa();
        return String.format(template, uaaProduct.getName(), uaaProduct.getMajorVersion(), uaaProduct.getMinorVersion(), uaaProduct.getPatchVersion());
    }

    private long retrieveInterval(String key, Long defaultValue) {
        try {
            P.sync();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return P.getLong(key, defaultValue);
    }

    private long retrieveTimestamp(String key) {
        try {
            P.sync();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return P.getLong(key, 0L);
    }

    private void storeTimestamp(String key, long timestamp) {
        try {
            P.putLong(key, timestamp);
            P.flush();
        }
        catch (BackingStoreException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadUaaEnvelope() {
        InputStream is = null;
        try {
            UaaClient.UaaEnvelope env = this.createUaaEnvelope();
            String uncompressed = Base64.encodeBytes(env.toByteArray());
            String compressed = Base64.encodeBytes(env.toByteArray(), 2);
            is = compressed.length() < uncompressed.length() ? new ByteArrayInputStream(compressed.getBytes("UTF-8")) : new ByteArrayInputStream(compressed.getBytes("UTF-8"));
            boolean success = this.transmissionService.upload(is);
            if (success) {
                this.storeTimestamp(LAST_UPLOAD_TIMESTAMP, System.currentTimeMillis());
            }
            boolean bl = success;
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    String encodeUaaEnvelope(UaaClient.UaaEnvelope env) throws IOException {
        String uncompressed = Base64.encodeBytes(env.toByteArray());
        String compressed = Base64.encodeBytes(env.toByteArray(), 2);
        if (compressed.length() < uncompressed.length()) {
            return compressed;
        }
        return uncompressed;
    }

    void stopTransmissionThread() {
        this.shouldExit = true;
        if (this.transmissionThread != null) {
            this.transmissionThread.interrupt();
        }
    }

    private class UaaTransmissionThread
    implements Runnable {
        private UaaTransmissionThread() {
        }

        public void run() {
            if (THREAD_DELAY > 0L) {
                try {
                    Thread.sleep(THREAD_DELAY);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            while (!TransmissionAwareUaaServiceImpl.this.shouldExit) {
                long lastUpload = TransmissionAwareUaaServiceImpl.this.retrieveTimestamp(TransmissionAwareUaaServiceImpl.LAST_UPLOAD_TIMESTAMP);
                long lastDownload = TransmissionAwareUaaServiceImpl.this.retrieveTimestamp(TransmissionAwareUaaServiceImpl.LAST_DOWNLOAD_TIMESTAMP);
                long now = System.currentTimeMillis();
                if (!TransmissionAwareUaaServiceImpl.this.isUaaTermsOfUseAccepted()) {
                    if (lastUpload + TransmissionAwareUaaServiceImpl.this.retrieveInterval(TransmissionAwareUaaServiceImpl.PING_INTERVAL_KEY, PING_INTERVAL_DEFAULT) < now) {
                        TransmissionAwareUaaServiceImpl.this.uploadUaaEnvelope();
                    }
                } else if (lastUpload + TransmissionAwareUaaServiceImpl.this.retrieveInterval(TransmissionAwareUaaServiceImpl.UPLOAD_INTERVAL_KEY, UPLOAD_INTERVAL_DEFAULT) < now && TransmissionAwareUaaServiceImpl.this.uploadUaaEnvelope()) {
                    TransmissionAwareUaaServiceImpl.this.clearIfPossible();
                }
                if (lastDownload + TransmissionAwareUaaServiceImpl.this.retrieveInterval(TransmissionAwareUaaServiceImpl.DOWNLOAD_INTERVAL_KEY, DOWNLOAD_INTERVAL_DEFAULT) < now) {
                    TransmissionAwareUaaServiceImpl.this.downloadAndUpdateConfiguration();
                }
                try {
                    if (Thread.interrupted() || TransmissionAwareUaaServiceImpl.this.shouldExit) continue;
                    Thread.sleep(THREAD_SLEEPTIME);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            return;
        }
    }
}

