/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.xml;

import grails.converters.XML;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.support.proxy.EntityProxyHandler;
import org.codehaus.groovy.grails.support.proxy.ProxyHandler;
import org.codehaus.groovy.grails.web.converters.ConverterUtil;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;
import org.springframework.beans.BeanWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainClassMarshaller
implements ObjectMarshaller<XML> {
    private final boolean includeVersion;
    private ProxyHandler proxyHandler;
    private GrailsApplication application;

    public DomainClassMarshaller(GrailsApplication application) {
        this(false, application);
    }

    public DomainClassMarshaller(boolean includeVersion, GrailsApplication application) {
        this.includeVersion = includeVersion;
        this.application = application;
    }

    public DomainClassMarshaller(boolean includeVersion, ProxyHandler proxyHandler, GrailsApplication application) {
        this(includeVersion, application);
        this.proxyHandler = proxyHandler;
    }

    @Override
    public boolean supports(Object object) {
        String name = ConverterUtil.trimProxySuffix(object.getClass().getName());
        return this.application.isArtefactOfType("Domain", name);
    }

    @Override
    public void marshalObject(Object value, XML xml) throws ConverterException {
        GrailsDomainClassProperty[] properties;
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(value);
        Class<?> clazz = value.getClass();
        GrailsDomainClass domainClass = (GrailsDomainClass)this.application.getArtefact("Domain", ConverterUtil.trimProxySuffix(clazz.getName()));
        GrailsDomainClassProperty id = domainClass.getIdentifier();
        Object idValue = beanWrapper.getPropertyValue(id.getName());
        if (idValue != null) {
            xml.attribute("id", String.valueOf(idValue));
        }
        if (this.includeVersion) {
            Object versionValue = beanWrapper.getPropertyValue(domainClass.getVersion().getName());
            xml.attribute("version", String.valueOf(versionValue));
        }
        for (GrailsDomainClassProperty property : properties = domainClass.getPersistentProperties()) {
            xml.startNode(property.getName());
            if (!property.isAssociation()) {
                Object val = beanWrapper.getPropertyValue(property.getName());
                xml.convertAnother(val);
            } else {
                Cloneable referenceObject = beanWrapper.getPropertyValue(property.getName());
                if (this.isRenderDomainClassRelations()) {
                    if (referenceObject != null) {
                        if ((referenceObject = this.proxyHandler.unwrapIfProxy((Object)referenceObject)) instanceof SortedMap) {
                            referenceObject = new TreeMap(referenceObject);
                        } else if (referenceObject instanceof SortedSet) {
                            referenceObject = new TreeSet((SortedSet)((Object)referenceObject));
                        } else if (referenceObject instanceof Set) {
                            referenceObject = new HashSet((Set)((Object)referenceObject));
                        } else if (referenceObject instanceof Map) {
                            referenceObject = new HashMap(referenceObject);
                        } else if (referenceObject instanceof Collection) {
                            referenceObject = new ArrayList((Collection)((Object)referenceObject));
                        }
                        xml.convertAnother(referenceObject);
                    }
                } else if (referenceObject != null) {
                    GrailsDomainClass referencedDomainClass = property.getReferencedDomainClass();
                    if (referencedDomainClass == null || property.isEmbedded() || GrailsClassUtils.isJdk5Enum((Class)property.getType())) {
                        xml.convertAnother(referenceObject);
                    } else if (property.isOneToOne() || property.isManyToOne() || property.isEmbedded()) {
                        this.asShortObject(referenceObject, xml, referencedDomainClass.getIdentifier(), referencedDomainClass);
                    } else {
                        GrailsDomainClassProperty referencedIdProperty = referencedDomainClass.getIdentifier();
                        String refPropertyName = referencedDomainClass.getPropertyName();
                        if (referenceObject instanceof Collection) {
                            Collection o = (Collection)((Object)referenceObject);
                            for (Object e : o) {
                                xml.startNode(xml.getElementName(e));
                                this.asShortObject(e, xml, referencedIdProperty, referencedDomainClass);
                                xml.end();
                            }
                        } else if (referenceObject instanceof Map) {
                            Map map = referenceObject;
                            for (Map.Entry entry : map.entrySet()) {
                                String key = String.valueOf(entry.getKey());
                                Object o = entry.getValue();
                                xml.startNode("entry").attribute("key", key);
                                this.asShortObject(o, xml, referencedIdProperty, referencedDomainClass);
                                xml.end();
                            }
                        }
                    }
                }
            }
            xml.end();
        }
    }

    protected void asShortObject(Object refObj, XML xml, GrailsDomainClassProperty idProperty, GrailsDomainClass referencedDomainClass) throws ConverterException {
        Object idValue;
        if (this.proxyHandler instanceof EntityProxyHandler) {
            idValue = ((EntityProxyHandler)this.proxyHandler).getProxyIdentifier(refObj);
            if (idValue == null) {
                idValue = new BeanWrapperImpl(refObj).getPropertyValue(idProperty.getName());
            }
        } else {
            idValue = new BeanWrapperImpl(refObj).getPropertyValue(idProperty.getName());
        }
        xml.attribute("id", String.valueOf(idValue));
    }

    protected boolean isRenderDomainClassRelations() {
        return false;
    }
}

