/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks.internal;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.properties.TypeScheme;
import org.gradle.api.internal.tasks.properties.annotations.OutputPropertyRoleAnnotationHandler;
import org.gradle.api.tasks.Nested;
import org.gradle.cache.internal.DefaultCrossBuildInMemoryCacheFactory;
import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.event.ScopedListenerManager;
import org.gradle.internal.instantiation.generator.DefaultInstantiatorFactory;
import org.gradle.internal.properties.annotations.NestedValidationUtil;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.properties.annotations.TypeMetadataWalker;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.service.DefaultServiceLocator;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.GradleModuleServices;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.state.DefaultManagedFactoryRegistry;

@NonNullApi
public class PropertyValidationAccess {
    private static final PropertyValidationAccess INSTANCE = new PropertyValidationAccess();
    private final List<TypeScheme> typeSchemes;

    private PropertyValidationAccess() {
        ServiceRegistryBuilder builder = ServiceRegistryBuilder.builder().displayName("Global services");
        builder.provider(new ServiceRegistrationProvider(){

            void configure(ServiceRegistration registration) {
                registration.add(ScopedListenerManager.class, (Object)new DefaultListenerManager(Scope.Global.class));
                registration.add(DefaultCrossBuildInMemoryCacheFactory.class);
                registration.add(DefaultManagedFactoryRegistry.class, (Object)new DefaultManagedFactoryRegistry());
                registration.add(OutputPropertyRoleAnnotationHandler.class);
                registration.add(DefaultInstantiatorFactory.class);
                List servicesProviders = new DefaultServiceLocator(false, new ClassLoader[]{this.getClass().getClassLoader()}).getAll(GradleModuleServices.class);
                for (GradleModuleServices services : servicesProviders) {
                    services.registerGlobalServices(registration);
                }
            }
        });
        ServiceRegistry services = builder.build();
        this.typeSchemes = services.getAll(TypeScheme.class);
    }

    public static void collectValidationProblems(Class<?> topLevelBean, TypeValidationContext validationContext) {
        INSTANCE.collectTypeValidationProblems(topLevelBean, validationContext);
    }

    private void collectTypeValidationProblems(Class<?> topLevelBean, final TypeValidationContext validationContext) {
        if (topLevelBean.equals(TaskInternal.class)) {
            return;
        }
        TypeMetadataStore metadataStore = this.getTypeMetadataStore(topLevelBean);
        if (metadataStore == null) {
            return;
        }
        TypeToken topLevelType = TypeToken.of(topLevelBean);
        TypeMetadataWalker.typeWalker((TypeMetadataStore)metadataStore, Nested.class).walk((Object)topLevelType, (TypeMetadataWalker.TypeMetadataVisitor)new TypeMetadataWalker.StaticMetadataVisitor(){

            public void visitRoot(TypeMetadata typeMetadata, TypeToken<?> value) {
                typeMetadata.visitValidationFailures(null, validationContext);
            }

            public void visitNested(TypeMetadata typeMetadata, String qualifiedName, PropertyMetadata propertyMetadata, TypeToken<?> value) {
                typeMetadata.visitValidationFailures(qualifiedName, validationContext);
                if (Modifier.isFinal(value.getRawType().getModifiers())) {
                    NestedValidationUtil.validateBeanType((TypeValidationContext)validationContext, (String)propertyMetadata.getPropertyName(), (Class)typeMetadata.getType());
                }
            }
        });
    }

    @Nullable
    private TypeMetadataStore getTypeMetadataStore(Class<?> topLevelBean) {
        for (TypeScheme typeScheme : this.typeSchemes) {
            if (!typeScheme.appliesTo(topLevelBean)) continue;
            return typeScheme.getMetadataStore();
        }
        return null;
    }
}

