/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.serialize;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.classpath.TransformedClassPath;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.graph.CombinatorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\t\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\n\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"readClassPath", "Lorg/gradle/internal/classpath/ClassPath;", "Lorg/gradle/internal/serialize/Decoder;", "readDefaultClassPath", "readTransformedClassPath", "writeClassPath", "", "Lorg/gradle/internal/serialize/Encoder;", "classPath", "writeDefaultClassPath", "writeTransformedClassPath", "Lorg/gradle/internal/classpath/TransformedClassPath;", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nClassPathEncodingExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassPathEncodingExtensions.kt\norg/gradle/internal/cc/impl/serialize/ClassPathEncodingExtensionsKt\n+ 2 Combinators.kt\norg/gradle/internal/serialize/graph/CombinatorsKt\n*L\n1#1,91:1\n251#2,5:92\n251#2,5:97\n*S KotlinDebug\n*F\n+ 1 ClassPathEncodingExtensions.kt\norg/gradle/internal/cc/impl/serialize/ClassPathEncodingExtensionsKt\n*L\n45#1:92,5\n53#1:97,5\n*E\n"})
public final class ClassPathEncodingExtensionsKt {
    public static final void writeClassPath(@NotNull Encoder $this$writeClassPath, @NotNull ClassPath classPath) {
        Intrinsics.checkNotNullParameter((Object)$this$writeClassPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        if (classPath instanceof TransformedClassPath) {
            $this$writeClassPath.writeBoolean(true);
            ClassPathEncodingExtensionsKt.writeTransformedClassPath($this$writeClassPath, (TransformedClassPath)classPath);
        } else {
            $this$writeClassPath.writeBoolean(false);
            ClassPathEncodingExtensionsKt.writeDefaultClassPath($this$writeClassPath, classPath);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeDefaultClassPath(@NotNull Encoder $this$writeDefaultClassPath, @NotNull ClassPath classPath) {
        void $this$writeCollection$iv;
        Intrinsics.checkNotNullParameter((Object)$this$writeDefaultClassPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        Encoder encoder = $this$writeDefaultClassPath;
        List list = classPath.getAsFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classPath.asFiles");
        Collection collection$iv = list;
        boolean $i$f$writeCollection = false;
        $this$writeCollection$iv.writeSmallInt(collection$iv.size());
        for (Object element$iv : collection$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            CombinatorsKt.writeFile((Encoder)$this$writeDefaultClassPath, (File)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeTransformedClassPath(@NotNull Encoder $this$writeTransformedClassPath, @NotNull TransformedClassPath classPath) {
        void $this$writeCollection$iv;
        Intrinsics.checkNotNullParameter((Object)$this$writeTransformedClassPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        Encoder encoder = $this$writeTransformedClassPath;
        List list = classPath.getAsFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classPath.asFiles");
        Iterable iterable = list;
        List list2 = classPath.getAsTransformedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"classPath.asTransformedFiles");
        Collection collection$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)list2);
        boolean $i$f$writeCollection = false;
        $this$writeCollection$iv.writeSmallInt(collection$iv.size());
        for (Object element$iv : collection$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Object object = it.getFirst();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.first");
            CombinatorsKt.writeFile((Encoder)$this$writeTransformedClassPath, (File)((File)object));
            Object object2 = it.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.second");
            CombinatorsKt.writeFile((Encoder)$this$writeTransformedClassPath, (File)((File)object2));
        }
    }

    @NotNull
    public static final ClassPath readClassPath(@NotNull Decoder $this$readClassPath) {
        Intrinsics.checkNotNullParameter((Object)$this$readClassPath, (String)"<this>");
        boolean isTransformed = $this$readClassPath.readBoolean();
        return isTransformed ? ClassPathEncodingExtensionsKt.readTransformedClassPath($this$readClassPath) : ClassPathEncodingExtensionsKt.readDefaultClassPath($this$readClassPath);
    }

    @NotNull
    public static final ClassPath readDefaultClassPath(@NotNull Decoder $this$readDefaultClassPath) {
        Intrinsics.checkNotNullParameter((Object)$this$readDefaultClassPath, (String)"<this>");
        int size = $this$readDefaultClassPath.readSmallInt();
        DefaultClassPath.Builder builder = DefaultClassPath.builderWithExactSize((int)size);
        for (int i = 0; i < size; ++i) {
            builder.add(CombinatorsKt.readFile((Decoder)$this$readDefaultClassPath));
        }
        ClassPath classPath = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"builder.build()");
        return classPath;
    }

    @NotNull
    public static final ClassPath readTransformedClassPath(@NotNull Decoder $this$readTransformedClassPath) {
        Intrinsics.checkNotNullParameter((Object)$this$readTransformedClassPath, (String)"<this>");
        int size = $this$readTransformedClassPath.readSmallInt();
        TransformedClassPath.Builder builder = TransformedClassPath.builderWithExactSize((int)size);
        for (int i = 0; i < size; ++i) {
            builder.add(CombinatorsKt.readFile((Decoder)$this$readTransformedClassPath), CombinatorsKt.readFile((Decoder)$this$readTransformedClassPath));
        }
        TransformedClassPath transformedClassPath = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)transformedClassPath, (String)"builder.build()");
        return (ClassPath)transformedClassPath;
    }
}

