/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.task;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.internal.jvm.inspection.JavaInstallationRegistry;
import org.gradle.internal.jvm.inspection.JvmToolchainMetadata;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;
import org.gradle.jvm.toolchain.internal.task.ToolchainReportRenderer;

@UntrackedTask(because="Produces only non-cacheable console output")
public abstract class ShowToolchainsTask
extends DefaultTask {
    private static final Comparator<JvmToolchainMetadata> TOOLCHAIN_COMPARATOR = Comparator.comparing(t -> t.metadata.getDisplayName()).thenComparing(t -> t.metadata.getLanguageVersion());
    private final ToolchainReportRenderer toolchainRenderer = new ToolchainReportRenderer();

    public ShowToolchainsTask() {
        this.getOutputs().upToDateWhen(SerializableLambdas.spec((SerializableLambdas.SerializableSpec & Serializable)element -> false));
    }

    @TaskAction
    public void showToolchains() {
        StyledTextOutput output = this.getTextOutputFactory().create(((Object)((Object)this)).getClass());
        this.toolchainRenderer.setOutput(output);
        output.println();
        List<JvmToolchainMetadata> toolchains = this.allReportableToolchains();
        List<JvmToolchainMetadata> validToolchains = this.validToolchains(toolchains);
        List<JvmToolchainMetadata> invalidToolchains = this.invalidToolchains(toolchains);
        this.printOptions(output);
        validToolchains.forEach(this.toolchainRenderer::printToolchain);
        this.toolchainRenderer.printInvalidToolchains(invalidToolchains);
    }

    private void printOptions(StyledTextOutput output) {
        boolean detectionEnabled = this.getToolchainConfiguration().isAutoDetectEnabled();
        boolean downloadEnabled = this.getToolchainConfiguration().isDownloadEnabled();
        output.withStyle(StyledTextOutput.Style.Identifier).println((Object)" + Options");
        output.withStyle(StyledTextOutput.Style.Normal).format("     | %s", new Object[]{Strings.padEnd((String)"Auto-detection:", (int)20, (char)' ')});
        output.withStyle(StyledTextOutput.Style.Description).println((Object)(detectionEnabled ? "Enabled" : "Disabled"));
        output.withStyle(StyledTextOutput.Style.Normal).format("     | %s", new Object[]{Strings.padEnd((String)"Auto-download:", (int)20, (char)' ')});
        output.withStyle(StyledTextOutput.Style.Description).println((Object)(downloadEnabled ? "Enabled" : "Disabled"));
        output.println();
    }

    private List<JvmToolchainMetadata> invalidToolchains(List<JvmToolchainMetadata> toolchains) {
        return toolchains.stream().filter(t -> !this.isValidToolchain().test((JvmToolchainMetadata)t)).collect(Collectors.toList());
    }

    private List<JvmToolchainMetadata> validToolchains(Collection<JvmToolchainMetadata> toolchains) {
        return toolchains.stream().filter(this.isValidToolchain()).sorted(TOOLCHAIN_COMPARATOR).collect(Collectors.toList());
    }

    private Predicate<? super JvmToolchainMetadata> isValidToolchain() {
        return t -> t.metadata.isValidInstallation();
    }

    private List<JvmToolchainMetadata> allReportableToolchains() {
        return this.getInstallationRegistry().toolchains();
    }

    @Inject
    protected JavaInstallationRegistry getInstallationRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProviderFactory getProviderFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected abstract ToolchainConfiguration getToolchainConfiguration();
}

