/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.filelock.DefaultLockOptions;

public class DefaultCacheBuilder
implements CacheBuilder {
    private final CacheFactory factory;
    private final File baseDir;
    private Map<String, ?> properties = Collections.emptyMap();
    private Action<? super PersistentCache> initializer;
    private CacheCleanupStrategy cacheCleanupStrategy;
    private LockOptions lockOptions = DefaultLockOptions.mode(FileLockManager.LockMode.Shared);
    private String displayName;

    public DefaultCacheBuilder(CacheFactory factory, File baseDir) {
        this.factory = factory;
        this.baseDir = baseDir;
    }

    @Override
    public CacheBuilder withProperties(Map<String, ?> properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public CacheBuilder withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public CacheBuilder withInitialLockMode(FileLockManager.LockMode mode) {
        this.lockOptions = DefaultLockOptions.mode(mode);
        return this;
    }

    @Override
    public CacheBuilder withInitializer(Action<? super PersistentCache> initializer) {
        this.initializer = initializer;
        return this;
    }

    @Override
    public CacheBuilder withCleanupStrategy(CacheCleanupStrategy cacheCleanupStrategy) {
        this.cacheCleanupStrategy = cacheCleanupStrategy;
        return this;
    }

    @Override
    public PersistentCache open() {
        return this.factory.open(this.baseDir, this.displayName, this.properties, this.lockOptions, this.initializer, this.cacheCleanupStrategy);
    }
}

