/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.messaging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddress;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddressSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.messaging.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerConfigSerializer
implements Serializer<WorkerConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerConfigSerializer.class);

    public WorkerConfig read(Decoder decoder) throws IOException {
        LogLevel logLevel = LogLevel.values()[decoder.readSmallInt()];
        boolean shouldPublishJvmMemoryInfo = decoder.readBoolean();
        NativeServices.NativeServicesMode nativeServicesMode = NativeServices.NativeServicesMode.values()[decoder.readSmallInt()];
        String gradleUserHomeDirPath = decoder.readString();
        MultiChoiceAddress serverAddress = new MultiChoiceAddressSerializer().read(decoder);
        long workerId = decoder.readSmallLong();
        String displayName = decoder.readString();
        Action<? super WorkerProcessContext> workerAction = WorkerConfigSerializer.deserializeWorker(decoder.readBinary(), this.getClass().getClassLoader());
        return new WorkerConfig(logLevel, shouldPublishJvmMemoryInfo, gradleUserHomeDirPath, serverAddress, workerId, displayName, workerAction, nativeServicesMode);
    }

    public void write(Encoder encoder, WorkerConfig config) throws IOException {
        encoder.writeSmallInt(config.getLogLevel().ordinal());
        encoder.writeBoolean(config.shouldPublishJvmMemoryInfo());
        encoder.writeSmallInt(config.getNativeServicesMode().ordinal());
        encoder.writeString((CharSequence)config.getGradleUserHomeDirPath());
        new MultiChoiceAddressSerializer().write(encoder, config.getServerAddress());
        encoder.writeSmallLong(config.getWorkerId());
        encoder.writeString((CharSequence)config.getDisplayName());
        encoder.writeBinary(WorkerConfigSerializer.serializeWorker(config.getWorkerAction()));
    }

    private static Action<? super WorkerProcessContext> deserializeWorker(byte[] serializedWorker, ClassLoader loader) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedWorker);
        ClassLoaderObjectInputStream in = null;
        try {
            Action workerAction;
            in = new ClassLoaderObjectInputStream((InputStream)bais, loader);
            Action action = workerAction = (Action)in.readObject();
            return action;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot load worker action's class", e);
        }
        catch (UnsupportedClassVersionError e) {
            String message;
            if (e instanceof ClassLoaderObjectInputStream.UnsupportedClassVersionErrorWithJavaVersion) {
                ClassLoaderObjectInputStream.UnsupportedClassVersionErrorWithJavaVersion e2 = (ClassLoaderObjectInputStream.UnsupportedClassVersionErrorWithJavaVersion)e;
                message = String.format("Unsupported worker JDK version. Required: %s. Current: %s", e2.getVersion().getMajorVersion(), JavaVersion.current().getMajorVersion());
            } else {
                message = "Unsupported worker JDK version: " + JavaVersion.current().getMajorVersion();
            }
            throw new GradleException(message, (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Error closing ObjectInputStream", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serializeWorker(Action<? super WorkerProcessContext> action) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(baos);
            out.writeObject(action);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Error closing ObjectOutputStream", (Throwable)e);
                }
            }
        }
    }
}

