/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolutionConflictTracker;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ResolvableSelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.internal.component.model.DefaultComponentOverrideMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.RejectedByAttributesVersion;
import org.gradle.internal.resolve.RejectedByRuleVersion;
import org.gradle.internal.resolve.RejectedBySelectorVersion;
import org.gradle.internal.resolve.RejectedVersion;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentIdResolveResult;
import org.gradle.util.internal.TextUtil;

class SelectorState
implements DependencyGraphSelector,
ResolvableSelectorState {
    private final Long id;
    private final DependencyState dependencyState;
    private final DependencyToComponentIdResolver resolver;
    private final ResolvedVersionConstraint versionConstraint;
    private final List<ComponentSelectionDescriptorInternal> dependencyReasons = Lists.newArrayListWithExpectedSize((int)4);
    private final boolean isProjectSelector;
    private final AttributeDesugaring attributeDesugaring;
    private ComponentIdResolveResult preferResult;
    private ComponentIdResolveResult requireResult;
    private ModuleVersionResolveException failure;
    private ModuleResolveState targetModule;
    private boolean resolved;
    private boolean forced;
    private boolean softForced;
    private boolean fromLock;
    private boolean reusable;
    private boolean markedReusableAlready;
    private ClientModule clientModule;
    private boolean changing;
    private int outgoingEdgeCount;

    SelectorState(Long id, DependencyState dependencyState, DependencyToComponentIdResolver resolver, ResolveState resolveState, ModuleIdentifier targetModuleId, boolean versionByAncestor) {
        this.id = id;
        this.resolver = resolver;
        this.targetModule = resolveState.getModule(targetModuleId);
        if (versionByAncestor) {
            this.dependencyReasons.add(ComponentSelectionReasons.BY_ANCESTOR);
        }
        this.update(dependencyState);
        this.dependencyState = dependencyState;
        this.versionConstraint = versionByAncestor ? resolveState.resolveVersionConstraint(DefaultImmutableVersionConstraint.of()) : resolveState.resolveVersionConstraint(dependencyState.getDependency().getSelector());
        this.isProjectSelector = this.getSelector() instanceof ProjectComponentSelector;
        this.attributeDesugaring = resolveState.getAttributeDesugaring();
    }

    @Override
    public boolean isProject() {
        return this.isProjectSelector;
    }

    public void use(boolean deferSelection) {
        ++this.outgoingEdgeCount;
        if (this.outgoingEdgeCount == 1) {
            this.targetModule.addSelector(this, deferSelection);
        }
    }

    public void release(ResolutionConflictTracker conflictTracker) {
        --this.outgoingEdgeCount;
        assert (this.outgoingEdgeCount >= 0) : "Inconsistent selector state detected: outgoing edge count cannot be negative";
        if (this.outgoingEdgeCount == 0) {
            this.removeAndMarkSelectorForReuse(conflictTracker);
        }
    }

    private void removeAndMarkSelectorForReuse(ResolutionConflictTracker conflictTracker) {
        this.targetModule.removeSelector(this, conflictTracker);
        this.resolved = false;
    }

    @Override
    public Long getResultId() {
        return this.id;
    }

    public String toString() {
        return this.dependencyState.getDependency().toString();
    }

    @Override
    public ComponentSelector getRequested() {
        return this.attributeDesugaring.desugarSelector(this.dependencyState.getRequested());
    }

    public ModuleResolveState getTargetModule() {
        return this.targetModule;
    }

    @Nullable
    ModuleVersionResolveException getFailure() {
        return this.failure;
    }

    @Override
    public ComponentIdResolveResult resolve(VersionSelector allRejects) {
        VersionSelector requiredSelector = this.versionConstraint == null ? null : this.versionConstraint.getRequiredSelector();
        this.requireResult = this.resolve(requiredSelector, allRejects, this.requireResult);
        return this.requireResult;
    }

    @Override
    public ComponentIdResolveResult resolvePrefer(VersionSelector allRejects) {
        if (this.versionConstraint == null || this.versionConstraint.getPreferredSelector() == null) {
            return null;
        }
        this.preferResult = this.resolve(this.versionConstraint.getPreferredSelector(), allRejects, this.preferResult);
        return this.preferResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentIdResolveResult resolve(@Nullable VersionSelector selector, VersionSelector rejector, ComponentIdResolveResult previousResult) {
        try {
            if (!this.requiresResolve(previousResult, rejector)) {
                ComponentIdResolveResult componentIdResolveResult = previousResult;
                return componentIdResolveResult;
            }
            DefaultBuildableComponentIdResolveResult idResolveResult = new DefaultBuildableComponentIdResolveResult();
            if (this.dependencyState.failure != null) {
                idResolveResult.failed(this.dependencyState.failure);
            } else {
                this.resolver.resolve(this.dependencyState.getDependency(), selector, rejector, idResolveResult);
            }
            if (idResolveResult.getFailure() != null) {
                this.failure = idResolveResult.getFailure();
            }
            DefaultBuildableComponentIdResolveResult defaultBuildableComponentIdResolveResult = idResolveResult;
            return defaultBuildableComponentIdResolveResult;
        }
        finally {
            this.resolved = true;
        }
    }

    private boolean requiresResolve(@Nullable ComponentIdResolveResult previousResult, @Nullable VersionSelector allRejects) {
        this.reusable = false;
        if (previousResult == null) {
            return true;
        }
        if (previousResult.getFailure() != null) {
            return false;
        }
        if (previousResult.isRejected()) {
            return false;
        }
        return allRejects != null && allRejects.accept(previousResult.getModuleVersionId().getVersion());
    }

    @Override
    public void markResolved() {
        this.resolved = true;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    boolean markForReuse() {
        if (!this.resolved) {
            return true;
        }
        this.reusable = true;
        if (this.markedReusableAlready) {
            return true;
        }
        this.markedReusableAlready = true;
        return false;
    }

    boolean canResolve() {
        if (this.reusable) {
            return true;
        }
        return !this.resolved;
    }

    public void overrideSelection(ComponentState selected) {
        this.resolved = true;
        this.reusable = false;
        this.targetModule = selected.getModule();
    }

    public ComponentSelectionReasonInternal getSelectionReason() {
        return ComponentSelectionReasons.of(this.dependencyReasons);
    }

    public void addReasonsForSelector(ComponentSelectionReasonInternal selectionReason) {
        ComponentIdResolveResult result = this.preferResult == null ? this.requireResult : this.preferResult;
        ArrayList<String> rejectedBySelector = null;
        if (result != null) {
            for (RejectedVersion rejectedVersion : result.getRejectedVersions()) {
                String version = rejectedVersion.getId().getVersion();
                if (rejectedVersion instanceof RejectedBySelectorVersion) {
                    if (rejectedBySelector == null) {
                        rejectedBySelector = new ArrayList<String>();
                    }
                    rejectedBySelector.add(version);
                    continue;
                }
                if (rejectedVersion instanceof RejectedByRuleVersion) {
                    String reason = ((RejectedByRuleVersion)rejectedVersion).getReason();
                    selectionReason.addCause(ComponentSelectionReasons.REJECTION.withDescription(new RejectedByRuleReason(version, reason)));
                    continue;
                }
                if (!(rejectedVersion instanceof RejectedByAttributesVersion)) continue;
                selectionReason.addCause(ComponentSelectionReasons.REJECTION.withDescription(new RejectedByAttributesReason((RejectedByAttributesVersion)rejectedVersion)));
            }
        }
        for (ComponentSelectionDescriptorInternal descriptor : this.dependencyReasons) {
            if (descriptor.getCause() == ComponentSelectionCause.REQUESTED || descriptor.getCause() == ComponentSelectionCause.CONSTRAINT) {
                if (rejectedBySelector != null) {
                    descriptor = descriptor.withDescription(new RejectedBySelectorReason(rejectedBySelector, descriptor));
                } else if (result != null && !result.getUnmatchedVersions().isEmpty()) {
                    descriptor = descriptor.withDescription(new UnmatchedVersionsReason(result.getUnmatchedVersions(), descriptor));
                }
            }
            selectionReason.addCause(descriptor);
        }
    }

    public DependencyMetadata getDependencyMetadata() {
        return this.dependencyState.getDependency();
    }

    @Override
    public IvyArtifactName getFirstDependencyArtifact() {
        List<IvyArtifactName> artifacts = this.dependencyState.getDependency().getArtifacts();
        return artifacts == null || artifacts.isEmpty() ? null : artifacts.get(0);
    }

    @Override
    @Deprecated
    public ClientModule getClientModule() {
        return this.clientModule;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public ResolvedVersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    @Override
    public ComponentSelector getSelector() {
        return this.dependencyState.getDependency().getSelector();
    }

    @Override
    public boolean isForce() {
        return this.forced;
    }

    @Override
    public boolean isSoftForce() {
        return this.softForced;
    }

    @Override
    public boolean isFromLock() {
        return this.fromLock;
    }

    @Override
    public boolean hasStrongOpinion() {
        return this.forced || this.versionConstraint != null && this.versionConstraint.isStrict();
    }

    public void update(DependencyState dependencyState) {
        if (dependencyState != this.dependencyState) {
            if (!this.forced && dependencyState.isForced()) {
                this.forced = true;
                if (dependencyState.getDependency() instanceof LenientPlatformDependencyMetadata) {
                    this.softForced = true;
                    this.targetModule.resolveOptimizations.declareForcedPlatformInUse();
                }
                this.resolved = false;
            }
            if (!this.fromLock && dependencyState.isFromLock()) {
                this.fromLock = true;
                this.resolved = false;
            }
            dependencyState.addSelectionReasons(this.dependencyReasons);
            this.trackDetailsForOverrideMetadata(dependencyState);
        }
    }

    private void trackDetailsForOverrideMetadata(DependencyState dependencyState) {
        ClientModule nextClientModule = DefaultComponentOverrideMetadata.extractClientModule(dependencyState.getDependency());
        if (nextClientModule != null && !nextClientModule.equals(this.clientModule)) {
            if (this.clientModule == null) {
                this.clientModule = nextClientModule;
            } else {
                throw new InvalidUserDataException(dependencyState.getDependency().getSelector().getDisplayName() + " has more than one client module definitions.");
            }
        }
        this.changing = this.changing || dependencyState.getDependency().isChanging();
    }

    private static class RejectedBySelectorReason
    implements Describable {
        private final Collection<String> rejectedVersions;
        private final ComponentSelectionDescriptorInternal descriptor;

        private RejectedBySelectorReason(Collection<String> rejectedVersions, ComponentSelectionDescriptorInternal descriptor) {
            this.rejectedVersions = rejectedVersions;
            this.descriptor = descriptor;
        }

        public String getDisplayName() {
            boolean hasCustomDescription = this.descriptor.hasCustomDescription();
            StringBuilder sb = new StringBuilder(this.estimateSize(hasCustomDescription));
            sb.append("rejected version").append(TextUtil.getPluralEnding(this.rejectedVersions)).append(" ");
            Joiner.on((String)", ").appendTo(sb, this.rejectedVersions);
            if (hasCustomDescription) {
                sb.append(" because ").append(this.descriptor.getDescription());
            }
            return sb.toString();
        }

        private int estimateSize(boolean hasCustomDescription) {
            return 20 + this.rejectedVersions.size() * 8 + (hasCustomDescription ? 24 : 0);
        }
    }

    private static class RejectedByAttributesReason
    implements Describable {
        private final RejectedByAttributesVersion version;

        private RejectedByAttributesReason(RejectedByAttributesVersion version) {
            this.version = version;
        }

        public String getDisplayName() {
            TreeFormatter formatter = new TreeFormatter();
            this.version.describeTo(formatter);
            return "version " + formatter;
        }
    }

    private static class RejectedByRuleReason
    implements Describable {
        private final String version;
        private final String reason;

        private RejectedByRuleReason(String version, @Nullable String reason) {
            this.version = version;
            this.reason = reason;
        }

        public String getDisplayName() {
            return this.version + " by rule" + (this.reason != null ? " because " + this.reason : "");
        }
    }

    private static class UnmatchedVersionsReason
    implements Describable {
        private final Collection<String> rejectedVersions;
        private final ComponentSelectionDescriptorInternal descriptor;

        private UnmatchedVersionsReason(Collection<String> rejectedVersions, ComponentSelectionDescriptorInternal descriptor) {
            this.rejectedVersions = rejectedVersions;
            this.descriptor = descriptor;
        }

        public String getDisplayName() {
            boolean hasCustomDescription = this.descriptor.hasCustomDescription();
            StringBuilder sb = new StringBuilder(this.estimateSize(hasCustomDescription));
            sb.append("didn't match version").append(TextUtil.getPluralEnding(this.rejectedVersions)).append(" ");
            Joiner.on((String)", ").appendTo(sb, this.rejectedVersions);
            if (hasCustomDescription) {
                sb.append(" because ").append(this.descriptor.getDescription());
            }
            return sb.toString();
        }

        private int estimateSize(boolean hasCustomDescription) {
            return 24 + this.rejectedVersions.size() * 8 + (hasCustomDescription ? 24 : 0);
        }
    }
}

