/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Severity;

public class DiagnosticToProblemListener
implements DiagnosticListener<JavaFileObject> {
    private final ProblemReporter problemReporter;

    public DiagnosticToProblemListener(ProblemReporter problemReporter) {
        this.problemReporter = problemReporter;
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        String message = diagnostic.getMessage(Locale.getDefault());
        String label = DiagnosticToProblemListener.mapKindToLabel(diagnostic.getKind());
        String resourceName = diagnostic.getSource() != null ? DiagnosticToProblemListener.getPath(diagnostic.getSource()) : null;
        int line = Math.toIntExact(diagnostic.getLineNumber());
        int column = Math.toIntExact(diagnostic.getColumnNumber());
        int length = Math.toIntExact(diagnostic.getEndPosition() - diagnostic.getStartPosition());
        Severity severity = DiagnosticToProblemListener.mapKindToSeverity(diagnostic.getKind());
        this.problemReporter.reporting(problem -> {
            ProblemSpec spec = problem.label(label).severity(severity).details(message);
            switch (severity) {
                case ADVICE: {
                    spec.category("compilation", new String[]{"java", "compilation-advice"});
                    break;
                }
                case WARNING: {
                    spec.category("compilation", new String[]{"java", "compilation-warning"});
                    break;
                }
                case ERROR: {
                    spec.category("compilation", new String[]{"java", "compilation-failed"});
                }
            }
            if (resourceName != null) {
                spec.lineInFileLocation(resourceName, line, column, length);
            }
        });
    }

    private static String getPath(JavaFileObject fileObject) {
        return fileObject.getName();
    }

    private static String mapKindToLabel(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return "Java compilation error";
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return "Java compilation warning";
            }
            case NOTE: {
                return "Java compilation note";
            }
            case OTHER: {
                return "Java compilation problem";
            }
        }
        return "Unknown java compilation problem";
    }

    private static Severity mapKindToSeverity(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return Severity.ERROR;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return Severity.WARNING;
            }
        }
        return Severity.ADVICE;
    }
}

