/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.artifacts.configurations.ProjectComponentObservationListener;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.execution.plan.Node;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scopes.Build.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u001a\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gradle/configurationcache/RelevantProjectsRegistry;", "Lorg/gradle/api/internal/artifacts/configurations/ProjectComponentObservationListener;", "build", "Lorg/gradle/internal/build/BuildState;", "projectStateRegistry", "Lorg/gradle/api/internal/project/ProjectStateRegistry;", "(Lorg/gradle/internal/build/BuildState;Lorg/gradle/api/internal/project/ProjectStateRegistry;)V", "targetProjects", "", "Lorg/gradle/api/internal/project/ProjectState;", "collect", "", "project", "projects", "isLocalProject", "", "projectState", "projectObserved", "consumingProjectPath", "Lorg/gradle/util/Path;", "targetProjectPath", "projectStateOf", "node", "Lorg/gradle/execution/plan/Node;", "relevantProjects", "", "nodes", "", "configuration-cache"})
public final class RelevantProjectsRegistry
implements ProjectComponentObservationListener {
    @NotNull
    private final BuildState build;
    @NotNull
    private final ProjectStateRegistry projectStateRegistry;
    @NotNull
    private final Set<ProjectState> targetProjects;

    public RelevantProjectsRegistry(@NotNull BuildState build2, @NotNull ProjectStateRegistry projectStateRegistry) {
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        Intrinsics.checkNotNullParameter((Object)projectStateRegistry, (String)"projectStateRegistry");
        this.build = build2;
        this.projectStateRegistry = projectStateRegistry;
        this.targetProjects = new LinkedHashSet();
    }

    @NotNull
    public final Set<ProjectState> relevantProjects(@NotNull List<? extends Node> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Set result2 = new LinkedHashSet();
        for (ProjectState projectState : this.targetProjects) {
            this.collect(projectState, result2);
        }
        for (Node node : nodes) {
            ProjectState project = this.projectStateOf(node);
            if (project == null || !this.isLocalProject(project)) continue;
            this.collect(project, result2);
        }
        return result2;
    }

    private final void collect(ProjectState project, Set<ProjectState> projects) {
        if (!projects.add(project)) {
            return;
        }
        ProjectState parent = project.getParent();
        if (parent != null) {
            this.collect(parent, projects);
        }
    }

    private final ProjectState projectStateOf(Node node) {
        ProjectInternal projectInternal = node.getOwningProject();
        return projectInternal != null ? projectInternal.getOwner() : null;
    }

    private final boolean isLocalProject(ProjectState projectState) {
        return projectState.getOwner() == this.build;
    }

    public void projectObserved(@Nullable Path consumingProjectPath, @NotNull Path targetProjectPath) {
        Intrinsics.checkNotNullParameter((Object)targetProjectPath, (String)"targetProjectPath");
        ProjectState projectState = this.projectStateRegistry.stateFor(targetProjectPath);
        Intrinsics.checkNotNullExpressionValue((Object)projectState, (String)"projectStateRegistry.stateFor(targetProjectPath)");
        this.targetProjects.add(projectState);
    }
}

