/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.cache.Cache;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Cast;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.steps.DeferredExecutionAwareStep;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.UpToDateResult;
import org.gradle.internal.execution.steps.WorkspaceResult;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.operations.execution.ExecuteDeferredWorkProgressDetails;

public class IdentityCacheStep<C extends IdentityContext, R extends WorkspaceResult>
implements DeferredExecutionAwareStep<C, R> {
    private final BuildOperationProgressEventEmitter progressEventEmitter;
    private final Step<? super IdentityContext, ? extends R> delegate;

    public IdentityCacheStep(BuildOperationProgressEventEmitter progressEventEmitter, Step<? super IdentityContext, ? extends R> delegate) {
        this.progressEventEmitter = progressEventEmitter;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        return (R)((WorkspaceResult)this.delegate.execute(work, (IdentityContext)context));
    }

    @Override
    public <T> Deferrable<Try<T>> executeDeferred(UnitOfWork work, C context, Cache<UnitOfWork.Identity, ExecutionEngine.IdentityCacheResult<T>> cache) {
        UnitOfWork.Identity identity = ((IdentityContext)context).getIdentity();
        ExecutionEngine.IdentityCacheResult cacheResult = (ExecutionEngine.IdentityCacheResult)cache.getIfPresent((Object)identity);
        if (cacheResult != null) {
            this.emitExecuteDeferredProgressDetails(work, ((IdentityContext)context).getIdentity(), cacheResult);
            return Deferrable.completed(cacheResult.getResult());
        }
        return Deferrable.deferred(() -> {
            ExecutionEngine.IdentityCacheResult maybeExecutedResult = (ExecutionEngine.IdentityCacheResult)cache.get((Object)identity, () -> this.executeInCache(work, context));
            this.emitExecuteDeferredProgressDetails(work, context.getIdentity(), maybeExecutedResult);
            return maybeExecutedResult.getResult();
        });
    }

    private <T> void emitExecuteDeferredProgressDetails(UnitOfWork work, UnitOfWork.Identity identity, ExecutionEngine.IdentityCacheResult<T> cacheResult) {
        cacheResult.getOriginMetadata().ifPresent(originMetadata -> this.progressEventEmitter.emitNowIfCurrent((Object)new DefaultExecuteDeferredWorkProgressDetails(work.getBuildOperationWorkType().orElse(null), identity, (OriginMetadata)originMetadata)));
    }

    private <T> ExecutionEngine.IdentityCacheResult<T> executeInCache(UnitOfWork work, C context) {
        Object result = this.execute(work, context);
        return new DefaultIdentityCacheResult(((WorkspaceResult)result).getOutputAs(Object.class).map(Cast::uncheckedNonnullCast), ((UpToDateResult)result).getReusedOutputOriginMetadata().orElseGet(() -> result.getAfterExecutionOutputState().map(ExecutionOutputState::getOriginMetadata).orElse(null)));
    }

    private static class DefaultExecuteDeferredWorkProgressDetails
    implements ExecuteDeferredWorkProgressDetails {
        private final String workType;
        private final UnitOfWork.Identity identity;
        private final OriginMetadata originMetadata;

        public DefaultExecuteDeferredWorkProgressDetails(@Nullable String workType, UnitOfWork.Identity identity, OriginMetadata originMetadata) {
            this.workType = workType;
            this.identity = identity;
            this.originMetadata = originMetadata;
        }

        @Nullable
        public String getWorkType() {
            return this.workType;
        }

        public String getIdentity() {
            return this.identity.getUniqueId();
        }

        public String getOriginBuildInvocationId() {
            return this.originMetadata.getBuildInvocationId();
        }

        public byte[] getOriginBuildCacheKeyBytes() {
            return this.originMetadata.getBuildCacheKey().toByteArray();
        }

        public long getOriginExecutionTime() {
            return this.originMetadata.getExecutionTime().toMillis();
        }
    }

    private static class DefaultIdentityCacheResult<T>
    implements ExecutionEngine.IdentityCacheResult<T> {
        private final Try<T> result;
        private final OriginMetadata originMetadata;

        public DefaultIdentityCacheResult(Try<T> result, @Nullable OriginMetadata originMetadata) {
            this.result = result;
            this.originMetadata = originMetadata;
        }

        @Override
        public Try<T> getResult() {
            return this.result;
        }

        @Override
        public Optional<OriginMetadata> getOriginMetadata() {
            return Optional.ofNullable(this.originMetadata);
        }
    }
}

