/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.internal.artifacts.GlobalDependencyResolutionRules;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResolveIvyFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResolverProviderFactory;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolversChain;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.resolve.caching.ComponentMetadataSupplierRuleExecutor;

public class ComponentResolversFactory {
    private final List<ResolverProviderFactory> resolverFactories;
    private final ResolveIvyFactory moduleDependencyResolverFactory;
    private final ProjectDependencyResolver projectDependencyResolver;
    private final ImmutableAttributesFactory attributesFactory;
    private final ComponentMetadataSupplierRuleExecutor componentMetadataSupplierRuleExecutor;
    private final GlobalDependencyResolutionRules metadataHandler;
    private final LocalComponentRegistry localComponentRegistry;

    @Inject
    public ComponentResolversFactory(List<ResolverProviderFactory> resolverFactories, ResolveIvyFactory moduleDependencyResolverFactory, ProjectDependencyResolver projectDependencyResolver, ImmutableAttributesFactory attributesFactory, ComponentMetadataSupplierRuleExecutor componentMetadataSupplierRuleExecutor, GlobalDependencyResolutionRules metadataHandler, LocalComponentRegistry localComponentRegistry) {
        this.resolverFactories = resolverFactories;
        this.moduleDependencyResolverFactory = moduleDependencyResolverFactory;
        this.projectDependencyResolver = projectDependencyResolver;
        this.attributesFactory = attributesFactory;
        this.componentMetadataSupplierRuleExecutor = componentMetadataSupplierRuleExecutor;
        this.metadataHandler = metadataHandler;
        this.localComponentRegistry = localComponentRegistry;
    }

    public ComponentResolvers create(ResolveContext resolveContext, List<? extends ResolutionAwareRepository> repositories, AttributesSchemaInternal consumerSchema) {
        ArrayList<ComponentResolvers> resolvers = new ArrayList<ComponentResolvers>(3);
        for (ResolverProviderFactory factory : this.resolverFactories) {
            factory.create(resolvers, this.localComponentRegistry);
        }
        resolvers.add(this.projectDependencyResolver);
        ResolutionStrategyInternal resolutionStrategy = resolveContext.getResolutionStrategy();
        AttributeContainerInternal requestedAttributes = resolveContext.getAttributes();
        resolvers.add(this.moduleDependencyResolverFactory.create(resolutionStrategy, repositories, this.metadataHandler.getComponentMetadataProcessorFactory(), (AttributeContainer)requestedAttributes, (AttributesSchema)consumerSchema, this.attributesFactory, this.componentMetadataSupplierRuleExecutor));
        return new ComponentResolversChain(resolvers);
    }
}

