/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.MutableClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.ClassloaderBackedPluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.InvalidPluginException;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.PluginResolutionStrategyInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.PluginRequestApplicator;
import org.gradle.plugin.use.internal.PluginResolverFactory;
import org.gradle.plugin.use.resolve.internal.AlreadyOnClasspathIgnoringPluginResolver;
import org.gradle.plugin.use.resolve.internal.AlreadyOnClasspathPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginArtifactRepositories;
import org.gradle.plugin.use.resolve.internal.PluginArtifactRepositoriesProvider;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolveContext;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.tracker.internal.PluginVersionTracker;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.TextUtil;

public class DefaultPluginRequestApplicator
implements PluginRequestApplicator {
    private final PluginRegistry pluginRegistry;
    private final PluginResolverFactory pluginResolverFactory;
    private final PluginArtifactRepositoriesProvider pluginRepositoriesProvider;
    private final PluginResolutionStrategyInternal pluginResolutionStrategy;
    private final PluginInspector pluginInspector;
    private final PluginVersionTracker pluginVersionTracker;
    private final PluginRequestApplicator.PluginApplicationListener pluginApplicationListenerBroadcaster;

    public DefaultPluginRequestApplicator(PluginRegistry pluginRegistry, PluginResolverFactory pluginResolverFactory, PluginArtifactRepositoriesProvider pluginRepositoriesProvider, PluginResolutionStrategyInternal pluginResolutionStrategy, PluginInspector pluginInspector, PluginVersionTracker pluginVersionTracker, ListenerManager listenerManager) {
        this.pluginRegistry = pluginRegistry;
        this.pluginResolverFactory = pluginResolverFactory;
        this.pluginRepositoriesProvider = pluginRepositoriesProvider;
        this.pluginResolutionStrategy = pluginResolutionStrategy;
        this.pluginInspector = pluginInspector;
        this.pluginVersionTracker = pluginVersionTracker;
        this.pluginApplicationListenerBroadcaster = (PluginRequestApplicator.PluginApplicationListener)listenerManager.getBroadcaster(PluginRequestApplicator.PluginApplicationListener.class);
    }

    public void applyPlugins(PluginRequests requests, PluginRequests autoAppliedPlugins, ScriptHandlerInternal scriptHandler, @Nullable PluginManagerInternal target, ClassLoaderScope classLoaderScope) {
        if (target == null || DefaultPluginRequestApplicator.noPluginsApplied(requests, autoAppliedPlugins)) {
            DefaultPluginRequestApplicator.defineScriptHandlerClassScope(scriptHandler, classLoaderScope, Collections.emptyList());
            return;
        }
        PluginArtifactRepositories resolveContext = this.pluginRepositoriesProvider.createPluginResolveRepositories();
        DefaultPluginRequestApplicator.addPluginArtifactRepositories(resolveContext, scriptHandler.getRepositories());
        PluginResolver effectivePluginResolver = this.wrapInAlreadyInClasspathResolver(classLoaderScope, resolveContext);
        LinkedList<Consumer<PluginManagerInternal>> pluginApplyActions = new LinkedList<Consumer<PluginManagerInternal>>();
        this.resolvePluginRequests(requests, scriptHandler, classLoaderScope, effectivePluginResolver, pluginApplyActions);
        if (!autoAppliedPlugins.isEmpty()) {
            this.resolveAutoAppliedPlugins(autoAppliedPlugins, scriptHandler, classLoaderScope, effectivePluginResolver, pluginApplyActions);
        }
        pluginApplyActions.forEach(pluginApplyAction -> pluginApplyAction.accept(target));
    }

    private void resolvePluginRequests(PluginRequests requests, ScriptHandlerInternal scriptHandler, ClassLoaderScope classLoaderScope, PluginResolver effectivePluginResolver, List<Consumer<PluginManagerInternal>> pluginApplyActions) {
        LinkedHashMap pluginImplsFromOtherLoaders = new LinkedHashMap();
        List<Result> results = this.resolvePluginRequests(requests, effectivePluginResolver);
        if (!results.isEmpty()) {
            this.applyPlugins(scriptHandler, classLoaderScope, pluginApplyActions, pluginImplsFromOtherLoaders, results);
        }
        DefaultPluginRequestApplicator.defineScriptHandlerClassScope(scriptHandler, classLoaderScope, pluginImplsFromOtherLoaders.values());
    }

    private void resolveAutoAppliedPlugins(PluginRequests autoAppliedPlugins, ScriptHandlerInternal scriptHandler, ClassLoaderScope classLoaderScope, PluginResolver effectivePluginResolver, List<Consumer<PluginManagerInternal>> pluginApplyActions) {
        AlreadyOnClasspathIgnoringPluginResolver alreadyOnClasspathIgnoringPluginResolver = new AlreadyOnClasspathIgnoringPluginResolver(effectivePluginResolver, (PluginDescriptorLocator)new ClassloaderBackedPluginDescriptorLocator(scriptHandler.getClassLoader()));
        List<Result> autoAppliedPluginRequests = this.resolvePluginRequests(autoAppliedPlugins, alreadyOnClasspathIgnoringPluginResolver);
        if (!autoAppliedPluginRequests.isEmpty()) {
            MutableClassLoaderScope mutableClassLoaderScope = classLoaderScope.asMutable("-plugins");
            scriptHandler.dropResolvedClassPath();
            LinkedHashMap pluginImplementations = new LinkedHashMap();
            this.applyPlugins(scriptHandler, (ClassLoaderScope)mutableClassLoaderScope, pluginApplyActions, pluginImplementations, autoAppliedPluginRequests);
            DefaultPluginRequestApplicator.defineScriptHandlerClassScope(scriptHandler, (ClassLoaderScope)mutableClassLoaderScope, pluginImplementations.values());
        }
    }

    public void applyPlugins(PluginRequests requests, ScriptHandlerInternal scriptHandler, @Nullable PluginManagerInternal target, ClassLoaderScope classLoaderScope) {
        this.applyPlugins(requests, PluginRequests.EMPTY, scriptHandler, target, classLoaderScope);
    }

    private void applyPlugins(final ScriptHandlerInternal scriptHandler, final ClassLoaderScope classLoaderScope, final List<Consumer<PluginManagerInternal>> pluginApplyActions, final Map<Result, PluginImplementation<?>> pluginImplsFromOtherLoaders, List<Result> results) {
        for (final Result result : results) {
            this.applyPlugin(result.request, result.found.getPluginId(), new Runnable(){

                @Override
                public void run() {
                    result.found.execute(new PluginResolveContext(){

                        @Override
                        public void addLegacy(PluginId pluginId, Object dependencyNotation) {
                            pluginApplyActions.add(target -> DefaultPluginRequestApplicator.this.applyLegacyPlugin(target, result, pluginId));
                            scriptHandler.addScriptClassPathDependency(dependencyNotation);
                        }

                        @Override
                        public void add(PluginImplementation<?> plugin) {
                            pluginApplyActions.add(target -> DefaultPluginRequestApplicator.this.applyPlugin(target, result, plugin));
                        }

                        @Override
                        public void addFromDifferentLoader(PluginImplementation<?> plugin) {
                            pluginApplyActions.add(target -> DefaultPluginRequestApplicator.this.applyPlugin(target, result, plugin));
                            pluginImplsFromOtherLoaders.put(result, plugin);
                        }
                    });
                    String pluginVersion = result.found.getPluginVersion();
                    if (pluginVersion != null) {
                        DefaultPluginRequestApplicator.this.pluginVersionTracker.setPluginVersionAt(classLoaderScope, result.found.getPluginId().getId(), pluginVersion);
                    }
                }
            });
        }
    }

    private void applyPlugin(PluginManagerInternal target, Result result, PluginImplementation<?> impl) {
        this.applyPlugin(result.request, result.found.getPluginId(), () -> {
            if (result.request.isApply()) {
                target.apply(impl);
            }
        });
    }

    private void applyLegacyPlugin(PluginManagerInternal target, Result result, PluginId id) {
        this.applyPlugin(result.request, id, () -> {
            if (result.request.isApply()) {
                target.apply(id.toString());
            }
        });
    }

    private List<Result> resolvePluginRequests(PluginRequests requests, PluginResolver effectivePluginResolver) {
        return CollectionUtils.collect((Iterable)requests, request -> {
            PluginRequestInternal configuredRequest = this.pluginResolutionStrategy.applyTo(request);
            return this.resolveToFoundResult(effectivePluginResolver, configuredRequest);
        }).stream().filter(r -> !((Result)r).alreadyApplied).collect(Collectors.toList());
    }

    private static void addPluginArtifactRepositories(PluginArtifactRepositories resolveContext, RepositoryHandler repositories) {
        resolveContext.applyRepositoriesTo(repositories);
    }

    private static void defineScriptHandlerClassScope(ScriptHandlerInternal scriptHandler, ClassLoaderScope classLoaderScope, Iterable<PluginImplementation<?>> pluginsFromOtherLoaders) {
        DefaultPluginRequestApplicator.exportBuildLogicClassPathTo(classLoaderScope, scriptHandler.getInstrumentedScriptClassPath());
        for (PluginImplementation<?> pluginImplementation : pluginsFromOtherLoaders) {
            classLoaderScope.export(pluginImplementation.asClass().getClassLoader());
        }
        classLoaderScope.lock();
    }

    private static void exportBuildLogicClassPathTo(ClassLoaderScope classLoaderScope, ClassPath classPath) {
        classLoaderScope.export(classPath);
    }

    private PluginResolver wrapInAlreadyInClasspathResolver(ClassLoaderScope classLoaderScope, PluginArtifactRepositories resolveContext) {
        ClassLoaderScope parentLoaderScope = classLoaderScope.getParent();
        ClassloaderBackedPluginDescriptorLocator scriptClasspathPluginDescriptorLocator = new ClassloaderBackedPluginDescriptorLocator(parentLoaderScope.getExportClassLoader());
        PluginResolver pluginResolver = this.pluginResolverFactory.create(resolveContext);
        return new AlreadyOnClasspathPluginResolver(pluginResolver, this.pluginRegistry, parentLoaderScope, (PluginDescriptorLocator)scriptClasspathPluginDescriptorLocator, this.pluginInspector, this.pluginVersionTracker);
    }

    private void applyPlugin(PluginRequestInternal request, PluginId id, Runnable applicator) {
        try {
            try {
                applicator.run();
                this.pluginApplicationListenerBroadcaster.pluginApplied(request);
            }
            catch (UnknownPluginException e) {
                throw this.couldNotApply(request, id, e);
            }
            catch (Exception e) {
                throw this.exceptionOccurred(request, e);
            }
        }
        catch (Exception e) {
            throw new LocationAwareException((Throwable)e, request.getScriptDisplayName(), request.getLineNumber());
        }
    }

    private static boolean noPluginsApplied(PluginRequests requests, PluginRequests autoAppliedPlugins) {
        return requests.isEmpty() && autoAppliedPlugins.isEmpty();
    }

    private InvalidPluginException couldNotApply(PluginRequestInternal request, PluginId id, UnknownPluginException cause) {
        return new InvalidPluginException(String.format("Could not apply requested plugin %s as it does not provide a plugin with id '%s'. This is caused by an incorrect plugin implementation. Please contact the plugin author(s).", request, id), (Throwable)cause);
    }

    private InvalidPluginException exceptionOccurred(PluginRequestInternal request, Exception e) {
        return new InvalidPluginException(String.format("An exception occurred applying plugin request %s", request), (Throwable)e);
    }

    private Result resolveToFoundResult(PluginResolver effectivePluginResolver, PluginRequestInternal request) {
        Result result = new Result(request);
        try {
            effectivePluginResolver.resolve(request, result);
        }
        catch (Exception e) {
            throw new LocationAwareException((Throwable)new GradleException(String.format("Error resolving plugin %s", request.getDisplayName()), (Throwable)e), request.getScriptDisplayName(), request.getLineNumber());
        }
        if (!result.isFound()) {
            String message = this.buildNotFoundMessage(request, result);
            UnknownPluginException exception = new UnknownPluginException(message);
            throw new LocationAwareException((Throwable)exception, request.getScriptDisplayName(), request.getLineNumber());
        }
        return result;
    }

    private String buildNotFoundMessage(PluginRequestInternal pluginRequest, Result result) {
        if (result.notFoundList.isEmpty()) {
            return String.format("Plugin %s was not found", pluginRequest.getDisplayName());
        }
        Formatter sb = new Formatter();
        sb.format("Plugin %s was not found in any of the following sources:%n", pluginRequest.getDisplayName());
        for (NotFound notFound : result.notFoundList) {
            sb.format("%n- %s (%s)", notFound.source, notFound.message);
            if (notFound.detail == null) continue;
            sb.format("%n%s", TextUtil.indent((String)notFound.detail, (String)"  "));
        }
        return sb.toString();
    }

    private static class Result
    implements PluginResolutionResult {
        private final List<NotFound> notFoundList = new LinkedList<NotFound>();
        private final PluginRequestInternal request;
        private PluginResolution found;
        private boolean alreadyApplied;

        public Result(PluginRequestInternal request) {
            this.request = request;
        }

        @Override
        public void notFound(String sourceDescription, String notFoundMessage) {
            this.notFoundList.add(new NotFound(sourceDescription, notFoundMessage, null));
        }

        @Override
        public void notFound(String sourceDescription, String notFoundMessage, String notFoundDetail) {
            this.notFoundList.add(new NotFound(sourceDescription, notFoundMessage, notFoundDetail));
        }

        @Override
        public void found(String sourceDescription, PluginResolution pluginResolution) {
            this.found = pluginResolution;
        }

        @Override
        public void alreadyApplied() {
            this.alreadyApplied = true;
        }

        @Override
        public boolean isFound() {
            return this.alreadyApplied || this.found != null;
        }
    }

    private static class NotFound {
        private final String source;
        private final String message;
        private final String detail;

        private NotFound(String source, String message, @Nullable String detail) {
            this.source = source;
            this.message = message;
            this.detail = detail;
        }
    }
}

