/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.problems;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.initialization.ClassLoaderScopeId;
import org.gradle.initialization.ClassLoaderScopeOrigin;
import org.gradle.initialization.ClassLoaderScopeRegistryListener;
import org.gradle.initialization.ClassLoaderScopeRegistryListenerManager;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.problems.ProblemLocationAnalyzer;
import org.gradle.problems.Location;

public class DefaultProblemLocationAnalyzer
implements ProblemLocationAnalyzer,
ClassLoaderScopeRegistryListener,
Closeable {
    private final Lock lock = new ReentrantLock();
    private final Map<String, ClassLoaderScopeOrigin.Script> scripts = new HashMap<String, ClassLoaderScopeOrigin.Script>();
    private final ClassLoaderScopeRegistryListenerManager listenerManager;

    public DefaultProblemLocationAnalyzer(ClassLoaderScopeRegistryListenerManager listenerManager) {
        this.listenerManager = listenerManager;
        listenerManager.add(this);
    }

    @Override
    public void close() throws IOException {
        this.listenerManager.remove(this);
        this.lock.lock();
        try {
            this.scripts.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void childScopeCreated(ClassLoaderScopeId parentId, ClassLoaderScopeId childId, @Nullable ClassLoaderScopeOrigin origin) {
        if (origin instanceof ClassLoaderScopeOrigin.Script) {
            ClassLoaderScopeOrigin.Script scriptOrigin = (ClassLoaderScopeOrigin.Script)origin;
            this.lock.lock();
            try {
                this.scripts.put(scriptOrigin.getFileName(), scriptOrigin);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void classloaderCreated(ClassLoaderScopeId scopeId, ClassLoaderId classLoaderId, ClassLoader classLoader, ClassPath classPath, @Nullable HashCode implementationHash) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location locationForUsage(List<StackTraceElement> stack, boolean fromException) {
        int endPos;
        int startPos;
        if (fromException) {
            startPos = 0;
            endPos = stack.size();
        } else {
            startPos = this.findFirstUserCode(stack);
            if (startPos == stack.size()) {
                return null;
            }
            endPos = this.findNextGradleType(startPos, stack);
        }
        this.lock.lock();
        try {
            for (int i = startPos; i < endPos; ++i) {
                StackTraceElement element = stack.get(i);
                if (element.getLineNumber() < 0 || !this.scripts.containsKey(element.getFileName())) continue;
                ClassLoaderScopeOrigin.Script source = this.scripts.get(element.getFileName());
                int lineNumber = element.getLineNumber();
                Location location = new Location(source.getLongDisplayName(), source.getShortDisplayName(), lineNumber);
                return location;
            }
            Location location = null;
            return location;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int findNextGradleType(int startPos, List<StackTraceElement> stack) {
        for (int i = startPos; i < stack.size(); ++i) {
            StackTraceElement element = stack.get(i);
            if (!element.getClassName().startsWith("org.gradle.")) continue;
            return i;
        }
        return stack.size();
    }

    private int findFirstUserCode(List<StackTraceElement> stack) {
        int pos;
        for (pos = 0; pos < stack.size() && DefaultProblemLocationAnalyzer.isNonUserCode(stack.get(pos)); ++pos) {
        }
        return pos;
    }

    private static boolean isNonUserCode(StackTraceElement element) {
        String className = element.getClassName();
        return className.startsWith("org.gradle.") || className.startsWith("jdk.") || className.startsWith("java.lang.reflect.") || className.startsWith("java.util.concurrent.") || className.equals("java.lang.Thread") || className.startsWith("sun.") || className.startsWith("com.sun.") || className.startsWith("groovy.lang.") || className.startsWith("org.codehaus.groovy.");
    }
}

